c FORTRAN PROGRAM FOR GENERATING RAINFALL DATA BASED ON BARTLETT-LEWIS MODEL
c WITH PARETO STORM INTER-ARRIVAL TIME (SALIM AND PAWITAN,2002).

	SUBROUTINE PARETO(PARM,N,RAIN)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)

c VARIABLES:
c	PARM(6) = THE PARAMETERS OF THE MODEL
c		(1)= SCALE PARM OF STORM INTER-ARRRIVAL TIME (PARETO)
c		(2)= MEAN OF STORM INTER-ARRIVAL TIME (PARETO)
c		(3)= MEAN RAINCELL INTENSITY (EXP)
c		(4)= 1/MEAN RAINCELL DURATION (EXP)
c		(5)= RATE OF RAINCELL/STORM (POISSON)
c		(6)= 1/MEAN LENGTH OF STORM (EXP)

c	POSTORM(N) = POSITION OF THE STORMS
c	NSTORM	 = NUMBER OF STORMS TO BE SIMULATED
c	CLDPOST	 = POSITION OF RAINCELLS INSIDE A STORM
c	CHILD    = NUMBER OF RAINCELLS INSIDE A STORM
c	LENGTH	 = LENGTH OF STORM
c	IX,IY,IZ = SEED FOR RND NUMBER GENERATION
c	N = LENGTH OF RAINFALL DATA TO BE GENERATED
c	RAIN(N)  = OUTPUT VECTOR CONTAINS SIMULATED RAINFALL DATA

c EXTERNAL SUBROUTINES NEEDED
c	UNIDEV = GENERATE UNIFORM (0,1) R.V.
c	POIDEV = GENERATE POISSON R.V.		

	REAL PARM(6)
	DOUBLE PRECISION RAIN(N),POSTORM(N)
	INTEGER N,NSTORM
	
	REAL UNIDEV
	EXTERNAL UNIDEV
	EXTERNAL POIDEV
	
	INTEGER CHILD,IX,IY,IZ,P
	DOUBLE PRECISION LENGTH,INTENS(5000)
	DOUBLE PRECISION DURAT(5000),CLDPOST(5000)
	DOUBLE PRECISION FINISH(5000)

c PARAMETER BOUND; LOWER BOUND OF PARAMETER SPACES WHICH WE BELIEVE IS PLAUSIBLE
	IF (PARM(1).LT.0.05) PARM(1)=0.05
	IF (PARM(2).LT.10.0) PARM(2)=10.0
	IF (PARM(3).LT.0.5) PARM(3)=0.5
	IF (PARM(4).LT.1.) PARM(4)=1.
	IF (PARM(5).LT.4.0) PARM(5)=4.0
	IF (PARM(6).LT.0.1) PARM(6)=0.1

c SEED FOR RANDOM NUMBER GENERATION
	ix=10
	iy=11
	iz=12

c START GENERATING RAINFALL DATA
	I=1
	POSTORM(1)=1

c GENERATE STORM POSITION AND DISCARD VERY LONG DRY RUN (> 500)
	
 10	IF (POSTORM(I).LT.(N+1)) THEN
		TEMP=(PARM(2)/(PARM(1)*PARM(2)-1))*
     +	  DBLE((1-DBLE(UNIDEV(ix,iy,iz)))**(1/(PARM(1)*PARM(2))-1)-1)
		IF (TEMP.LT.500) THEN
			POSTORM(I+1)=POSTORM(I)+TEMP
			I=I+1
		ENDIF
		GO TO 10
	ENDIF

	NSTORM=I-1

c FOR EACH STORM GENERATE THE FOLLOWING:
c (1) LENGTH OF STORM
c (2) NO. OF RAINCELLS INSIDE THE STORM

	DO I=1,NSTORM
	   LENGTH=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(6)	
	   DURAT(1)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(4)
	   CHILD=IDINT(POIDEV(PARM(5)*LENGTH,IX,IY,IZ))
	   INTENS(1)=-PARM(3)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
	   CLDPOST(1)=POSTORM(I) 
	   FINISH(1)=CLDPOST(1)+DURAT(1)	

  	   IF (CHILD.LT.1) GO TO 11	

c FOR EACH RAINCELL, GENERATE THE FOLLOWING:
c (1) DURATION OF THE RAINCELL
c (2) INTENSITY OF THE RAINCELL

	   DO J=2,CHILD+1
		DURAT(J)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/PARM(4)			   	
		INTENS(J)=-PARM(3)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
      			  
		CLDPOST(J)=CLDPOST(1)+DBLE(UNIDEV(IX,IY,IZ))*LENGTH
		FINISH(J)=CLDPOST(J)+DURAT(J)

		IF (FINISH(J).GT.(N+1)) GO TO 20
	   ENDDO

 
c FILLED-IN THE RAIN

 11	   DO 12 J=1,CHILD+1	
		IF (FINISH(J).GE.(N+1)) THEN
			FINISH(J)=N+0.99
		ENDIF

		IF (CLDPOST(J).GE.(N+1)) THEN
			CLDPOST(J)=N+0.99
		ENDIF
c IF THE RAINCELL DOES NOT GO OVER THE HOUR
		IF ((FINISH(J)-IDINT(CLDPOST(J))).LE. 1.0) THEN
			K=IDINT(CLDPOST(J))
			RAIN(K)=RAIN(K)+(INTENS(J)*DURAT(J))  
c IF RAINCELL FINISHES AT THE NEXT HOUR
		ELSE
			K=IDINT(CLDPOST(J))
			P=IDINT(FINISH(J))
			RAIN(K)=RAIN(K)+(INTENS(J)*(1.0-CLDPOST(J)+K))
			IF (P.gt.N) then 
				P=N
			ENDIF

			IF ((K+1).gt.P) GO TO 13
			DO M=(K+1),P
			   RAIN(M)=RAIN(M)+INTENS(J)
			ENDDO
			RAIN(P)=RAIN(P)-(1.0-FINISH(J)+P)*INTENS(J)
 13      	ENDIF
 12        ENDDO
      ENDDO
c END OF FILLED-IN PROCESS
 20   RETURN
      END		


