c FORTRAN PROGRAM FOR GENERATING RAINFALL DATA BASED ON MULTI-LAYER BARTLETT-LEWIS MODEL
c WITH PARETO STORM INTER-ARRIVAL TIME (SALIM AND PAWITAN,2002).

	SUBROUTINE PRT3LYR(PARM,N,RAIN)
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)

c VARIABLES:
c	PARM(8) = PARAMETERS OF THE MODEL
c	THESE TWO PARAMETERS ARE SUFFICIENT TO SPECIFY THE PARETO DISTRIBUTION
c		(1)= SCALE PARAMETER OF STORM INTER-ARRIVAL TIME DISTRIBUTION (PARETO)
c		(2)= MEAN OF STORM INTER-ARRIVAL TIME DISTRIBUTION (PARETO)
c		(3)= MEAN RAINCELL INTENSITY (EXP)
c		(4)= 1/MEAN RAINCELL DURATION (EXP)
c		(5)= RATE OF SUB-STORMS/STORM (POISSON)
c		(6)= 1/MEAN LENGTH OF STORM (EXP)
c		(7)= RATE OF CELLS/SUB-STORM (POISSON)
c		(8)= 1/MEAN LENGTH OF SUB-STORM (EXP)

c	POSTORM(N) = POSITION OF THE STORMS
c	NSTORM	 = NUMBER OF STORMS TO BE SIMULATED
c	CLDPOS	 = POSITION OF SUB-STORMS INSIDE A STORM
c	CELLPOS	 = POSITION OF RAINCELLS INSIDE A SUB-STORM
c	CHILD    = NUMBER OF SUB-STORM INSIDE A STORM
c	CELL	 = NUMBER OF CELLS INSIDE A SUB-STORM
c	LENGTH	 = LENGTH OF STORM
c	LENCLD	 = LENGTH OF A SUB-STORM INSIDE A STORM
c	IX,IY,IZ = SEED FOR RND NUMBER GENERATION
c	N = LENGTH OF RAINFALL DATA TO BE GENERATED
c	RAIN(N)  = OUTPUT VECTOR CONTAINS SIMULATED RAINFALL DATA

c EXTERNAL SUBROUTINES NEEDED
c	UNIDEV = GENERATE UNIFORM (0,1) R.V.
c	POIDEV = GENERATE POISSON R.V.	
	
	REAL PARM(8)
	DOUBLE PRECISION RAIN(N),POSTORM(N),DPARM(8)
	INTEGER N,NSTORM

	DOUBLE PRECISION CELLPOS(5000),CLDPOS(5000)
	DOUBLE PRECISION LENGTH,LENCLD
	
	REAL UNIDEV
	EXTERNAL UNIDEV
	EXTERNAL POIDEV
	
	INTEGER CHILD,CELL,IX,IY,IZ,P
	DOUBLE PRECISION INTENS(20000)
	DOUBLE PRECISION DURAT(20000)
	DOUBLE PRECISION FINISH(20000)


	DO I=1,8
		DPARM(I)=DBLE(PARM(I))
	ENDDO 

c PARAMETER BOUND; LOWER BOUND OF PARAMETER SPACES WHICH WE BELIEVE IS PLAUSIBLE

	IF (DPARM(1).LT.0.015) DPARM(1)=0.015
	IF (DPARM(2).LT.130.0) DPARM(2)=130.
	IF (DPARM(3).LT.0.5) DPARM(3)=0.5
	IF (DPARM(4).LT.3) DPARM(4)=3
	IF (DPARM(5).LT.0.01) DPARM(5)=0.01
	IF (DPARM(6).LT.0.006) DPARM(6)=0.006
	IF (DPARM(7).LT.3.0) DPARM(7)=3.0
 	IF (DPARM(8).LT.0.2) DPARM(8)=0.2	

c SEED FOR RANDOM NUMBER GENERATION
	ix=10
	iy=11
	iz=12

c START GENERATING RAINFALL DATA

	I=1
	POSTORM(1)=1


c DISCARD VERY LONG DRY RUN 	
 10	IF (POSTORM(I).LT.(N+1)) THEN
            TEMP=(DPARM(2)/(DPARM(1)*DPARM(2)-1))*
     +	DBLE((1-DBLE(UNIDEV(ix,iy,iz)))**(1/(DPARM(1)*DPARM(2))-1)-1)
	    IF (TEMP.LT.500) THEN
			POSTORM(I+1)=POSTORM(I)+TEMP
			I=I+1
	    ENDIF
	    GO TO 10
	ENDIF

	NSTORM=I-1

c FOR EACH STORM GENERATE THE FOLLOWING:
c (1) LENGTH OF STORM
c (2) NO. OF SUB-STORM

	DO 13 I=1,NSTORM
	   LENGTH=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/DPARM(6)	
	   CHILD=1+IDINT(POIDEV(DPARM(5)*LENGTH,IX,IY,IZ))

  	   IF (CHILD.LT.1) GO TO 13

c THERE IS A SUB-STORM ASSOCIATED WITH STORM ORIGIN.

	   CLDPOS(1)=POSTORM(I)

c FOR EACH SUB-STORM, GENERATE THE FOLLOWING:
c (1) LENGTH OF SUB-STORM
c (2) NO. OF RAINCELLS INSIDE THE SUB-STORM
	   DO 12 L=1,CHILD
		LENCLD=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/DPARM(8)
		CELL=IDINT(POIDEV(DPARM(7)*LENCLD,IX,IY,IZ))
		IF (CELL.LT.1) GO TO 12

c FOR EACH RAINCELL, GENERATE THE FOLLOWING:
c (1) DURATION OF THE RAINCELL
c (2) INTENSITY OF THE RAINCELL

		DURAT(1)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/DPARM(4)			   	
		INTENS(1)=-DPARM(3)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
      			  
		CELLPOS(1)=CLDPOS(L)+DBLE(UNIDEV(IX,IY,IZ))*LENCLD
		FINISH(1)=CELLPOS(1)+DURAT(1)

		IF (CELL.GT.1) THEN
		    DO K=2,CELL
		       CELLPOS(K)=CLDPOS(L)+DBLE(UNIDEV(IX,IY,IZ))*LENCLD
			 DURAT(K)=-DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))/DPARM(4)
			 INTENS(K)=-DPARM(3)*DLOG(1.0-DBLE(UNIDEV(IX,IY,IZ)))
     			 FINISH(K)=CELLPOS(K)+DURAT(K)
		    ENDDO
		ENDIF
 
c BEGIN TO "FILLED-IN" THE RAINFALL
 		DO 11 J=1,CELL	
		    IF (FINISH(J).GT.(N+1)) THEN
			FINISH(J)=N+0.99
		    ENDIF

		    IF (CELLPOS(J).GT.(N+1)) THEN
		       CELLPOS(J)=N+0.99
		    ENDIF

c IF THE RAINCELL DOES NOT GO OVER THE HOUR, DO THE FOLLOWING 
		    IF ((FINISH(J)-IDINT(CELLPOS(J))).LE. 1.0) THEN
		       K=IDINT(CELLPOS(J))
		       RAIN(K)=RAIN(K)+(INTENS(J)*DURAT(J))  

c IF RAINCELL FINISHES AT THE NEXT HOUR, DO THE FOLLOWING 
		    ELSE
		       K=IDINT(CELLPOS(J))
     		       P=IDINT(FINISH(J))

     		       RAIN(K)=RAIN(K)+(INTENS(J)*(1.0-(CELLPOS(J)-K)))
		       IF (P.gt.N) THEN 
		          P=N
		       ENDIF
		       IF ((K+1).gt.P) GO TO 14
		       DO M=(K+1),P
			  RAIN(M)=DBLE(RAIN(M))+INTENS(J)
		       ENDDO
		       RAIN(P)=RAIN(P)-(1.0-FINISH(J)+P)*INTENS(J)
 14      	    ENDIF
 11		ENDDO
c END OF FILLED-IN PROCESS

c DETERMINE POSITION OF THE NEXT SUB-STORM
		CLDPOS(L+1)=POSTORM(I)+DBLE(UNIDEV(IX,IY,IZ))*LENGTH
 12	   ENDDO

 13	ENDDO 
 20   RETURN
      END		



