C   ROUTINE NAME        - LOCAL
C
C-----------------------------------------------------------------------
C
C   COMPUTER            - IBM PC/SINGLE
C
C   LATEST REVISION     - OKTOBER 15, 1986
C                           (ALTERATIONS IN THE COMMENTS AND IN THE
C                           ROUTINE PARAMETERS TO MEET THE REQUIREMENTS
C                           OF THE LATEST (JULY 31, 1986) VERSION OF
C                           THE GLOBAL ROUTINE.)
C
C   PURPOSE             - MINIMUM OF FUNCTION OF N VARIABLES USING
C                           A RANDOM WALK METHOD UNIRANDI WITH A GIVEN
C                           INITIAL STEP LENGTH.
C
C   USAGE               - CALL LOCAL (M,N,RELCON,MAXFN,X,F,NFEV,R,
C                           MIN,MAX)
C
C   ARGUMENTS    M      - NUMBER OF RESIDUALS OR OBSERVATIONS.(INPUT)
C                N      - THE NUMBER OF UNKNOWN PARAMETERS (I.E.,
C                           THE LENGTH OF X) (INPUT)
C                RELCON - CONVERGENCE CRITERION. (INPUT) THIS IS
C                           SATISFIED IF, ON TWO SUCCESSIVE ITERATIONS,
C                           THE PARAMETER ESTIMATES (I.E., X(I),
C                           I=1,...,N) OR THE FUNCTION VALUE DIFFERS,
C                           COMPONENT BY COMPONENT, BY AT MOST RELCON.
C                MAXFN  - MAXIMUM NUMBER OF FUNCTION EVALUATIONS (I.E.,
C                           CALLS TO SUBROUTINE FUNCT) ALLOWED. (INPUT)
C                           THE ACTUAL NUMBER OF CALLS TO FUNCT MAY
C                           EXCEED MAXFN SLIGHTLY.
C                X      - VECTOR OF LENGTH N CONTAINING PARAMETER
C                           VALUES.
C                         ON INPUT, X SHOULD CONTAIN THE INITIAL
C                           ESTIMATE OF THE LOCATION OF THE MINIMUM.
C                         ON OUTPUT, X CONTAINS THE FINAL ESTIMATE
C                           OF THE LOCATION OF THE MINIMUM.
C                F      - A SCALAR CONTAINING THE VALUE OF THE OBJECTIVE
C                           FUNCTION AT THE FINAL PARAMETER ESTIMATES.
C                         ON INPUT, F SHOULD CONTAIN THE FUNCTION VALUE
C                           AT THE INITIAL PARAMETER ESTIMATES.
C                         ON OUTPUT, F CONTAINS THE FUNCTION VALUE
C                           AT THE FINAL PARAMETER ESTIMATES.
C                NFEV   - THE NUMBER OF FUNCTION EVALUATIONS (OUTPUT)
C                R      - A VECTOR OF LENGTH 3*N USED AS WORKING SPACE.
C                MIN    - A VECTOR OF LENGTH N CONTAINING SCALING
C                           FACTORS SUPPLIED BY THE GLOBAL ROUTINE
C                           (INPUT)
C                MAX    - A VECTOR OF LENGTH N CONTAINING SCALING
C                           FACTORS SUPPLIED BY THE GLOBAL ROUTINE
C                           (INPUT)
C
C   REFERENCE           - TIMO JARVI: A RANDOM SEARCH OPTIMIZER WITH
C                           AN APPLICATION TO A MAX-MIN PROBLEM. A
C                           SPECIAL TRAJECTORY ESTIMATION PROBLEM,
C                           PUBLICATIONS OF THE INSTITUTE FOR APPLIED
C                           MATHEMATICS, NO. 3, UNIVERSITY OF TURKU,
C                           1973.
C
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32
C                       - SINGLE/H36,H48,H60
C
C   REQUIRED ROUTINES   - URDMN,FUN
C
C-----------------------------------------------------------------------
C
      SUBROUTINE LOCAL (M,N,RELCON,MAXFN,X,F,NFEV,R,MIN,MAX)
      REAL R(100,15),X(15),X1(15),MIN(1),MAX(1)
      DATA                ZERO,ONEN3,HALF,ONE,TWO/
     *                    0.0,0.001,0.5,1.0,2.0/
C                                  FIRST EXECUTABLE STATEMENT
C                                  INITIAL STEP LENGTH
	DATA IX/100/,IY/151/,IZ/245/ 
      H = ONEN3
      DELTF = ONE
      ITEST = 0
      NFEV = 0
      EPS = RELCON
C                                  EVALUATE 100 RANDOM VECTORS
    5 CALL UNIF(IX,IY,IZ,1500,R)
      IRNDM = 0
   15 IRNDM = IRNDM+1
      IF (IRNDM.GT.100) GO TO 5
C                                  SELECT A RANDOM VECTOR HAVING NORM
C                                    LESS OR EQUAL TO 0.5
      A = ZERO
      DO 20 I=1,N
      R(IRNDM,I) = R(IRNDM,I)-HALF
   20 A = A+R(IRNDM,I)*R(IRNDM,I)
      IF (A.LE.ZERO) GO TO 15
      A = SQRT(A)
      IF (A.GT.HALF) GO TO 15
C                                  NEW TRIAL POINT
      DO 25 I=1,N
      R(IRNDM,I) = R(IRNDM,I)/A
   25 X1(I) = X(I)+H*R(IRNDM,I)
      CALL FUN (X1,F1,N,M,MIN,MAX)
      NFEV = NFEV+1
      IF (F1.LT.F) GO TO 35
      IF (NFEV.GT.MAXFN) GO TO 50
C                                  STEP IN THE OPPOSITE DIRECTION
      H = -H
      DO 30 I=1,N
   30 X1(I) = X(I)+H*R(IRNDM,I)
      CALL FUN (X1,F1,N,M,MIN,MAX)
      NFEV = NFEV+1
      IF (F1.LT.F) GO TO 35
      IF (NFEV.GT.MAXFN) GO TO 50
      ITEST = ITEST+1
      IF (ITEST.LT.2) GO TO 15
C                                  DECREASE STEP LENGTH
      H = H*HALF
      ITEST = 0
C                                  RELATIVE CONVERGENCE TEST FOR THE
C                                    OBJECTIVE FUNCTION
      IF (DELTF.LT.EPS) GO TO 50
C                                  CONVERGENCE TEST FOR THE STEP LENGTH
      IF (ABS(H)-RELCON) 50,15,15
   35 DO 40 I=1,N
   40 X(I) = X1(I)
      DELTF = (F-F1)/ABS(F1)
      F = F1
C                                  INCREASE STEP LENGTH
      H = H*TWO
      DO 45 I=1,N
   45 X1(I) = X(I)+H*R(IRNDM,I)
      CALL FUN (X1,F1,N,M,MIN,MAX)
      NFEV = NFEV+1
      IF (F1.LT.F) GO TO 35
C                                  CHECK TOLERANCE MAXFN
      IF (NFEV.GT.MAXFN) GO TO 50
C                                  DECREASE STEP LENGTH
      H = ABS(H*HALF)
      GO TO 15
   50 RETURN
      END
