/* 
SAS code (Version 8) for using PROC NLMIXED 
to implement maximum likelihood fitting of random 
log-linear models (2.5) and 2.6 to Table 2.  
*/

options linesize=80;

data simon;
input row column count int;
datalines;
1 1 0    7.5   
1 2 1    5.0 
1 3 0    2.5 
1 4 0    0.0 
1 5 0   -2.5 
1 6 1   -5.0 
1 7 0   -7.5 
2 1 0    4.5 
2 2 0    3.0 
2 3 0    1.5 
2 4 1    0.0 
2 5 0   -1.5 
2 6 0   -3.0 
2 7 0   -4.5 
3 1 0    1.5 
3 2 0    1.0 
3 3 3    0.5 
3 4 6    0.0 
3 5 4   -0.5 
3 6 0   -1.0 
3 7 0   -1.5 
4 1 0   -1.5 
4 2 0   -1.0 
4 3 1   -0.5 
4 4 4    0.0 
4 5 7    0.5 
4 6 4    1.0 
4 7 0    1.5 
5 1 1   -4.5 
5 2 0   -3.0 
5 3 0   -1.5 
5 4 2    0.0 
5 5 6    1.5 
5 6 10   3.0 
5 7 1    4.5 
6 1 0   -7.5 
6 2 0   -5.0 
6 3 0   -2.5 
6 4 0    0.0 
6 5 0    2.5 
6 6 2    5.0 
6 7 1    7.5 

;

data indsimon;
set simon;
cell = _N_;
if row=1 then row1=1; else row1=0;
if row=2 then row2=1; else row2=0;
if row=3 then row3=1; else row3=0;
if row=4 then row4=1; else row4=0;
if row=5 then row5=1; else row5=0;

if column=1 then column1=1; else column1=0;
if column=2 then column2=1; else column2=0;
if column=3 then column3=1; else column3=0;
if column=4 then column4=1; else column4=0;
if column=5 then column5=1; else column5=0;
if column=6 then column6=1; else column6=0;

run;

* independence model;

proc genmod data=indsimon;
class row column;
model count = row column / link=log dist=poisson;
run;

* L x L model;

proc genmod data=indsimon;
class row column;
model count = row column int / link=log dist=poisson;
run;

* GLLMM model shrinking probabilities toward independence fit;
* using MLE's from model with no random effects as starting values;

proc nlmixed data=indsimon qpoints=10 cov;
parms alpha=-2.2156 r1=-.4055 r2=-1.0986 r3=1.4663 r4=1.6740
                    r5=1.8971 
                    c1=-.6931 c2=-.6931 c3=.6931 c4=1.8718
                    c5=2.1401 c6=2.1401 
                    sd=0.1;

lp = alpha + r1 * row1 + r2 * row2 + r3 * row3 + r4 * row4 + r5 * row5 
           + c1 * column1 + c2 * column2 + c3 * column3 + c4 * column4 
           + c5 * column5 + c6 * column6 
           + u;

mu = exp(lp);

model count ~ poisson(mu);

random u ~ normal(0, sd*sd) subject=cell;

predict mu out=pred;

run;

* GLLMM model shrinking cell probabilities toward L x L interaction fit;
* using MLE's from model with no random effects as starting values;

proc nlmixed data=indsimon qpoints=10 cov;
parms alpha=-2.2156 r1=-.4055 r2=-1.0986 r3=1.4663 r4=1.6740
                    r5=1.8971 
                    c1=-.6931 c2=-.6931 c3=.6931 c4=1.8718
                    c5=2.1401 c6=2.1401 beta=.4398 
                    sd=0.1;
lp = alpha + r1 * row1 + r2 * row2 + r3 * row3 + r4 * row4 + r5 * row5 
           + c1 * column1 + c2 * column2 + c3 * column3 + c4 * column4 
           + c5 * column5 + c6 * column6 
           + beta * int  + u;

mu = exp(lp);

model count ~ poisson(mu);

random u ~ normal(0, sd*sd) subject=cell;

predict mu out=pred;

run;


proc print data=pred;
var pred;


