/* 
SAS code (Version 8) for using PROC NLMIXED 
to implement maximum likelihood fitting of random association 
model (5.1) using global odds ratios to Table 3.  
*/

data clin1;
input center y11 y12 y13 y21 y22 y23;
datalines;
1 13 7 6 1 1 10
2  2 5 10 2 2  1
3 11 23 7 2 8 2 
4 7 11 8 0 3 2
5 15 3 5 1 1 5
6 13 5 5 4 0 1
7 7 4 13 1 1 11
8 15 9 2 3 2 2
;
run;

data clin2;
set clin1;
r1tot = y11 + y12 + y13;
r2tot = y21 + y22 + y23;
c1tot = y11 + y21;
c2tot = c1tot + y12 + y22;
total = r1tot + r2tot;
run;

proc nlmixed data=clin2 qpoints=15 cov;
   parms alpha = 0.82 sd=1.0; 
   global1 = exp(alpha + u);
   global2 = exp(alpha + u);
   eta1 = r1tot/total;
   zeta1 = c1tot/total;
   zeta2 = c2tot/total;
   s1 =    ((1 + (eta1 + zeta1)*(global1-1))**2
          + 4*global1*(1-global1)*eta1*zeta1)**.5;
   s2 =    ((1 + (eta1 + zeta2)*(global2-1))**2
          + 4*global2*(1-global2)*eta1*zeta2)**.5;  
   if (global1 = 1.0) then
      f1 =  eta1*zeta1;
   else
      f1 =  .5*((global1 - 1)**(-1))*
            (1 + (eta1 + zeta1)*(global1 - 1) - s1);
   if (global2 = 1.0) then
      f2 =  eta1*zeta2;
   else
      f2 =  .5*((global2 - 1)**(-1))*
            (1 + (eta1 + zeta2)*(global2 - 1) - s2);
   f11 = f1;
   f12 = eta1 - f11;
   f13 = zeta1 - f11;
   f14 = 1 - (f11+f12+f13);
   f21 = f2;
   f22 = eta1 - f21;
   f23 = zeta2 - f21;
   f24 = 1 - (f21+f22+f23);
   pi11 = f11;
   pi12 = f21 - f11;
   pi13 = f22;
   pi21 = f13;
   pi22 = f23 - f13;
   pi23 = f24;

   ll = y11*log(pi11) + y12*log(pi12) + y13*log(pi13) 
        + y21*log(pi21) + y22*log(pi22) + y23*log(pi23);
   
      
   model y11 ~ general(ll);
   random u ~ normal(0, sd*sd) subject = center; 
   predict alpha + u out=pred;
run;