	!*********************************
	!**pmsar11.f					**
	!**posterior	                **
	!**								**
	!**post							**
	!*********************************

	subroutine post (n,m,p,arm,armH,pi,sample_mean,csi1,y,
     &				 mu,lambda,phi,eta,bbeta,gmm,per,perH,
     &				 prior_gmm,prior_mu,prior_lambda,prior_phi,
     &				 prior_eta,prior_bbeta,posterior)
	
	use msimsl
	
	implicit none
	
	integer tt,n,p,i,m,j,arm,d,h,armH 
	real*8 y(30000),yy(30000),sample_mean,summ,pi,gmm(9,9),
     &mu(9),lambda(9),phi(9,9),eta(22),prior_gmm(9*9),prior_mu(2),
     &prior_lambda(2),prior_phi(2),prior_eta(2),posterior,
     &csi1(30000,9),ln_pdf(30000,9),huge_ln_pdf(30000,9),per(30000),
     &perH(30000,9),a,witch(24),prior_bbeta(2),bbeta(9,22)

	do tt=1,n
		if (y(tt).gt.-998) then
		yy(tt)=y(tt)
		else
		yy(tt)=sample_mean
		end if
	end do
	
	do d=1,n/24
		do h=1,24
			if ((d-1)*24+h.gt.p) then
				do i=1,m
					if(y((d-1)*24+h).gt.-998) then
						summ=0
						if (p.gt.0) then
							do j=1,p
							summ=summ+yy((d-1)*24+h-j)*phi(i,j)
							end do
						end if
					huge_ln_pdf((d-1)*24+h,i)=dlog(dsqrt(lambda(i)/
     &				(2*pi)))+(-lambda(i)*((y((d-1)*24+h)-mu(i)-summ-
     &				per((d-1)*24+h)-perH((d-1)*24+h,i))**2)/2)
					else
					huge_ln_pdf((d-1)*24+h,i)=0.
					end if
				end do
			end if
		end do
	end do
	
	do i=1,m
		do d=1,n/24
			
			do h=1,24
			witch(h)=huge_ln_pdf((d-1)*24+h,i)
			end do

			ln_pdf(d,i)=0
			do h=1,24
			ln_pdf(d,i)=ln_pdf(d,i)+witch(h)
			end do
			 
		end do
	end do
	
	posterior=0
	do d=1,n/24
		summ=0
		do i=1,m
		summ=summ+dexp(ln_pdf(d,i)+dlog(csi1(d,i)))
		end do
		posterior=posterior+dlog(summ)
	end do
	
	do i=1,m
	a=i
	posterior=posterior+dlog(a)
	end do
	
	do i=1,m
	
		summ=0
		do j=1,m
		summ=summ+prior_gmm((i-1)*m+j)
     		end do
		
		posterior=posterior+DLNGAM(summ)
				
		do j=1,m
		posterior=posterior-DLNGAM(prior_gmm((i-1)*m+j))
     		end do
		
		do j=1,m
		posterior=posterior+(prior_gmm((i-1)*m+j)-1)*dlog(gmm(i,j))
     		end do
	
	end do
	
	do i=1,m
	posterior=posterior+(dlog(prior_mu(2)/(2*pi))/2)-
     &prior_mu(2)/2*((mu(i)-prior_mu(1))**2)
	end do	
			
	do i=1,m
	posterior=posterior+prior_lambda(1)*dlog(prior_lambda(2))-
     &DLNGAM(prior_lambda(1))+(prior_lambda(1)-1)*dlog(lambda(i))-
     &lambda(i)*prior_lambda(2)
     	end do
			
	if (p.gt.0) then
		do i=1,m
			do j=1,p
			posterior=posterior+(dlog(prior_phi(2)/(2*pi))/2)-
     &		prior_phi(2)/2*((phi(i,j)-prior_phi(1))**2)
			end do
		end do
	end if
	
	do j=1,2*arm
	posterior=posterior+(dlog(prior_eta(2)/(2*pi))/2)-
     &prior_eta(2)/2*((eta(j)-prior_eta(1))**2)
	end do
	
	do i=1,m
		do j=1,2*armH
		posterior=posterior+(dlog(prior_bbeta(2)/(2*pi))/2)-
     &	prior_bbeta(2)/2*((bbeta(i,j)-prior_bbeta(1))**2)
		end do
	end do
	
	return
	end