	!**********************************************************
	!**   Periodic Markov Switching Autoregressive Models    **
      !**   for Bayesian Analysis and Forecasting of           **   
	!**   Air Pollution                                      **
	!**         L.Spezia - R.Paroli - P.Dellaportas          **
	!**        Statistical Modelling, n.4 1-20, 2004         **
	!**********************************************************
      !*                                                       **                                                  
	!*              CONSTRAINT IDENTIFICATION                **
      !**********************************************************
	!*                                                       **
      !*      Fortran90 program (using the IMSL library)       **
	!*                                                       **
	!*%%% This program is free software                      **
	!*                                                       **
	!*%%% Users who use this program in published works      **
	!*%%% are asked to acknowledge its use and cite this     **
	!*%%% paper as reference                                 ** 
	!*                                                       **
	!*                                                       **
	!* - This main has to be linked with the following       **
	!*     subroutines                                       **
	!*                                                       **
	!*     PMSAR01 - PMSAR02 - PMSAR03 - PMSAR04 -           **
      !*     PMSAR05 - PMSAR06 - PMSAR07 - PMSAR08 -           **
	!*     PMSAR09 - PMSAR10                                 **
      !*													     **
      !*                                                       **
	!* - INPUT data from file 'CO.txt'                       **
      !* - OUTPUT files:  'diag_out.txt' - 'mu_out.txt' -      **
	!*                  'lambda_out.txt' - 'phi_out.txt' -   **
	!*                  'bbeta1_out.txt' - 'bbeta2_out.txt'  **
	!*                  'bbeta3_out.txt' - 'bbeta4_out.txt'  **
	!*                  'bbeta5_out.txt' - 'bbeta6_out.txt'  **
	!*                  'output.txt'                         **
      !*                                                       **
      !*                                                       ** 
	!* ----------------------------------------------------- **
	!*  Author's contact information:                        **
	!*  Roberta Paroli                                       **
	!*  Istituto di Statistica - Universit Cattolica S.C.   ** 
	!*  Largo Gemelli 1 - 20131 Milano (Italy)               **
	!*  E-mail:roberta.paroli@unicatt.it                     **
	!*                                                       **     
	!**********************************************************
	use msimsl
	
	implicit none
	
	integer tt,n,m,p,s,q,arm,armH,i,fact,missing,nn,sample_mean,j,
     &states_couples(9*9),burn_in,sample,iteration,d,h,z(30000),
     &x(30000),perm(9),c,rate
	real*8 yy(30000),pi,y(30000),hyp,prior_gmm(9*9),prior_mu(2),
     &prior_lambda(2),prior_phi(2),prior_eta(2),prior_bbeta(2),gmm(9,9),
     &mu(9),lambda(9),phi(9,9),eta(22),bbeta(9,22),per(30000),
     &perH(30000,9),y_new(30000),harmonia(30000,22),harmoniaH(30000,22),
     &ln_pdf(30000,9),csi1(30000,9),csi2(30000,9),csi3(30000,9),summ,
     &line(9),y_ran(30000)
	
	real*8 gmm_diag_out(10000),mu_out(10000),lambda_out(10000),
     &phi_out(10000),bbeta_1_out(10000),bbeta_2_out(10000),
     &bbeta_3_out(10000),bbeta_4_out(10000),bbeta_5_out(10000),
     &bbeta_6_out(10000)
           	
	open(2001,file='c:diag_out.txt')
	open(3001,file='c:\mu_out.txt')
	open(4001,file='c:\lambda_out.txt')
	open(5001,file='c:\phi_out.txt')
	open(6001,file='c:\bbeta1_out.txt')
	open(6002,file='c:\bbeta2_out.txt')
      open(6003,file='c:\bbeta3_out.txt')
      open(6004,file='c:\bbeta4_out.txt')
      open(6005,file='c:\bbeta5_out.txt')
      open(6006,file='c:\bbeta6_out.txt')
              
      open(10000,file='c:\output.txt')
			
	open(111,file='c:\CO.txt')
	read(111,*) (yy(tt),tt=1,25536)
	
	n=2*365*24			

	write (10000,*) "n",n
	m=3
	write (10000,*) "m",m
	p=2
	write (10000,*) "p",p
	s=365*24/2
	write (10000,*) "s",s
	arm=1	
	write (10000,*) "arm",arm
	q=24/2
	write (10000,*) "q",q
	armH=3	
	write (10000,*) "armH",armH

	pi=3.141592653589793
	
	fact=1
	do i=2,m
	fact=fact*i
	end do
	
	do tt=1,n
		if (yy(tt).eq.0.) then
		yy(tt)=0.1
		end if
		
		if (yy(tt).gt.-998) then
		y(tt)=log(yy(tt))
		else
		y(tt)=-999
		end if
	end do
	
	missing=0
	
	do tt=1,n
		if (y(tt).eq.-999) then
		missing=missing+1
		end if
	end do
	
	nn=n-missing
	
	write (10000,*) "missing",missing
	
	sample_mean=0
	do tt=1,n
		if (y(tt).gt.-998) then
		sample_mean=sample_mean+y(tt)
		end if
	end do
	sample_mean=sample_mean/nn
	
	!*****PRIOR PARAMETERS*****
	
	do i=1,m
		do j=1,m 
			if (i.eq.j) then
			prior_gmm((i-1)*m+j)=m
			else
			prior_gmm((i-1)*m+j)=0.6
			end if
		end do
	end do
	
	hyp=15./2
	prior_mu(1)=dlog(hyp)	
	prior_mu(2)=0.1
				
	prior_lambda(1)=1.
	prior_lambda(2)=1.			
		
	prior_phi(1)=0.
	prior_phi(2)=0.1
	
	prior_eta(1)=0.
	prior_eta(2)=0.1
	
	prior_bbeta(1)=0.
	prior_bbeta(2)=0.1
	
	!*****STARTING VALUES*****
	
	do i=1,m
		do j=1,m
		gmm(i,j)=1./m	
		end do
	end do
	
	do i=1,m
	mu(i)=sample_mean*i/m	
	lambda(i)=1.		
		do j=1,p
		phi(i,j)=0.			
		end do
	end do
		
	do tt=1,n
	per(tt)=0.	
		do i=1,m
		perH(tt,i)=0.
		end do
	end do

	do tt=1,n
		if (y(tt).gt.-999) then
		y_new(tt)=y(tt)
		else
		y_new(tt)=y_new(tt-1)
		end if	
	end do
		
	!*****END STARTING VALUES*****
	
	do tt=1,n
		do j=1,2*arm,2
		harmonia(tt,j)=dcos(pi*(j+1)/2*tt/s)
		harmonia(tt,j+1)=dsin(pi*(j+1)/2*tt/s)
		end do
	end do
	
	do tt=1,n
		do j=1,2*armH,2
		harmoniaH(tt,j)=dcos(pi*(j+1)/2*tt/q)
		harmoniaH(tt,j+1)=dsin(pi*(j+1)/2*tt/q)
		end do
	end do
	
	do i=1,m
		do j=1,m
		states_couples((i-1)*m+j)=10*i+j
		end do
	end do
	
	!**********BLOCK GIBBS SAMPLING**********
	
	burn_in=500*fact
	write (10000,*) "BURN IN",burn_in
	sample=5000*fact
	write (10000,*) "SAMPLE",sample

	do iteration=1,(burn_in+sample)
	
	write (*,*) "iteration",iteration
			
	!LOG OF THE PDF'S
	
	call pdf (y_new,m,n,pi,mu,lambda,p,phi,per,perH,ln_pdf)			!pmsar01.f
	
	!GENERATION OF THE SEQUENCES OF HIDDEN STATES

	!csi1   t+1|t
	!csi2   t|t
	!csi3   t|t+1,t
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	!GENERATION OF THE TRANSITION PROBABILITIES
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	!GENERATION OF THE MU'S
	
	call muh (m,n,x,y_new,lambda,prior_mu,p,phi,per,perH,mu)		!pmsar05.f							
		
	!GENERATION OF THE LAMBDA'S
	
	call lambdah (m,n,x,y_new,mu,prior_lambda,
     &			  p,phi,per,perH,lambda)							!pmsar06.f
					
	!GENERATION OF THE PHI'S
	
	if (p.gt.0) then
	call fi(m,n,p,y_new,x,mu,lambda,prior_phi,per,perH,phi)			!pmsar07.f
	end if
					
	!GENERATION OF THE ETA'S
	
	call etah (n,m,p,y_new,x,prior_eta,arm,
     &		   phi,harmonia,mu,lambda,perH,eta)						!pmsar08.f

	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	!GENERATION OF THE BETA'S
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,
     &			phi,harmoniaH,mu,lambda,per,bbeta)					!pmsar09.f

	!SELECTION OF A PERMUTATION
	
	do i=1,m
 740	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 740
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 910
				end if
			end do
 910		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
	line(i)=mu(i)
	end do
	do i=1,m
	mu(i)=line(perm(i))
	end do
	
	do i=1,m
	line(i)=lambda(i)
	end do
	do i=1,m
	lambda(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi(i,j)
		end do
		do i=1,m
		phi(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	!GENERATION OF THE MISSING DATA
	
	call miss (m,n,x,y,mu,lambda,p,phi,per,perH,y_ran,y_new)		!pmsar10.f	
	
	rate=fact*5/2
	if (iteration.gt.burn_in) then
		if(int(iteration/rate)*rate.eq.iteration)then
		gmm_diag_out((iteration-burn_in)/rate)=gmm(1,1)
		mu_out((iteration-burn_in)/rate)=mu(1)
		lambda_out((iteration-burn_in)/rate)=lambda(1)
		phi_out((iteration-burn_in)/rate)=phi(1,1)
		bbeta_1_out((iteration-burn_in)/rate)=bbeta(1,1)
		bbeta_2_out((iteration-burn_in)/rate)=bbeta(1,2)
		bbeta_3_out((iteration-burn_in)/rate)=bbeta(1,3)
		bbeta_4_out((iteration-burn_in)/rate)=bbeta(1,4)
		bbeta_5_out((iteration-burn_in)/rate)=bbeta(1,5)
		bbeta_6_out((iteration-burn_in)/rate)=bbeta(1,6)
		end if
	end if
	
	end do !do iteration=1,(burn_in+sample)
	
	!**********ESTIMATES**********
		
	!Gamma's
	
	do tt=1,sample/rate
	write (2001,*),gmm_diag_out(tt)
	end do
	
	!Mu's
	
	do tt=1,sample/rate
	write (3001,*),mu_out(tt)
	end do
	
	!Lambda's
	
	do tt=1,sample/rate
	write (4001,*),lambda_out(tt)
	end do
	
	!Phi's
	
	do tt=1,sample/rate
	write (5001,*),phi_out(tt)
	end do
	
	!Beta's
	
	do tt=1,sample/rate
	write (6001,*),bbeta_1_out(tt)
	write (6002,*),bbeta_2_out(tt)
	write (6003,*),bbeta_3_out(tt)
	write (6004,*),bbeta_4_out(tt)
	write (6005,*),bbeta_5_out(tt)
	write (6006,*),bbeta_6_out(tt)
	end do
	
	end !end of the code