      !**********************************************************
	!**   Periodic Markov Switching Autoregressive Models    **
      !**   for Bayesian Analysis and Forecasting of           **   
	!**   Air Pollution                                      **
	!**         L.Spezia - R.Paroli - P.Dellaportas          ** 
	!**        Statistical Modelling, n.4 1-20, 2004         **
	!**                                                      **
	!**********************************************************
      !*                                                       **
      !*               PARAMETERS ESTIMATION                   **
      !**********************************************************
	!*                                                       **
      !*                                                       **
      !*      Fortran90 program (using the IMSL library)       **
	!*                                                       **
	!*%%% This program is free software                      **
	!*                                                       **
	!*%%% Users who use this program in published works      **
	!*%%% are asked to acknowledge its use and cite this     **
	!*%%% paper as reference                                 ** 
	!*                                                       **
	!*                                                       **
	!* - This main has to be linked with the following       **
	!*     subroutines                                       **
	!*                                                       **
	!*     PMSAR01 - PMSAR02 - PMSAR03 - PMSAR04 -           **
      !*     PMSAR05 - PMSAR06 - PMSAR07 - PMSAR08 -           **
	!*     PMSAR09 - PMSAR10 - PMSAR11                       **
      !*													     **
      !*                                                       **
	!* - INPUT data from file 'CO.txt'                       **
      !* - OUTPUT files:  'states.txt' - 'fitted.txt'          **
	!*                  'output.txt'                         **
      !*                                                       **
      !* ----------------------------------------------------- **
	!*  Author's contact information:                        **
	!*  Roberta Paroli                                       **
	!*  Istituto di Statistica - Universit Cattolica S.C.   ** 
	!*  Largo Gemelli 1 - 20131 Milano (Italy)               **
	!*  E-mail:roberta.paroli@unicatt.it                     **
	!*                                                       **     
	!**********************************************************
	 
	use msimsl
	
	implicit none
	
	integer m,n,p,s,q,arm,armH,tt,fact,i,missing,nn,j,d,h,perm(9),
     &states_couples(9*9),burn_in,sample,iteration,z(30000),x(30000),
     &counts_states(30000,9),states_mode(30000,2)
	real*8 yy(30000),pi,y(30000),sample_mean,prior_gmm(9*9),
     &prior_mu(2),prior_lambda(2),prior_phi(2),prior_eta(2),
     &prior_bbeta(2),hyp,gmm(9,9),mu(9),lambda(9),phi(9,9),eta(22),
     &bbeta(9,22),per(30000),perH(30000,9),y_new(30000),
     &harmonia(30000,22),harmoniaH(30000,22),ln_pdf(30000,9),
     &csi1(30000,9),csi2(30000,9),csi3(30000,9),matt(2,9),cargo(2),
     &lambda_mean(9),summ,line(9),mu_mean(9),phi_mean(9,9),eta_mean(22),
     &bbeta_mean(9,22),gmm_mean(9*9),y_ran(30000),y_mean(30000),
     &delta(9),a,mean_absolute_error,mean_squared_error,
     &root_mean_squared_error
	
	open(8000,file='c:\states.txt')
      open(9000,file='c:\fitted.txt')
      open(10000,file='c:\output.txt')
			
	open(111,file='c:\CO.txt')
	read(111,*) (yy(tt),tt=1,25536)
	
	n=2*365*24			

	write (10000,*) "n",n
	m=3
	write (10000,*) "m",m
	p=2
	write (10000,*) "p",p
	s=365*24/2
	write (10000,*) "s",s
	arm=1	
	write (10000,*) "arm",arm
	q=24/2
	write (10000,*) "q",q
	armH=3	
	write (10000,*) "armH",armH

	pi=3.141592653589793
	
	fact=1
	do i=2,m
	fact=fact*i
	end do
	
	do tt=1,n
		if (yy(tt).eq.0.) then
		yy(tt)=0.1
		end if
		
		if (yy(tt).gt.-998) then
		y(tt)=log(yy(tt))
		else
		y(tt)=-999
		end if
	end do
	
	missing=0
	
	do tt=1,n
		if (y(tt).eq.-999) then
		missing=missing+1
		end if
	end do
	
	nn=n-missing
	
	write (10000,*) "missing",missing
	
	sample_mean=0
	do tt=1,n
		if (y(tt).gt.-998) then
		sample_mean=sample_mean+y(tt)
		end if
	end do
	sample_mean=sample_mean/nn
	
	!*****PRIOR PARAMETERS*****
	
	do i=1,m
		do j=1,m 
			if (i.eq.j) then
			prior_gmm((i-1)*m+j)=m
			else
			prior_gmm((i-1)*m+j)=0.6
			end if
		end do
	end do
	
	hyp=15./2
	prior_mu(1)=dlog(hyp)	
	prior_mu(2)=0.1
				
	prior_lambda(1)=1.
	prior_lambda(2)=1.			
		
	prior_phi(1)=0.
	prior_phi(2)=0.1
	
	prior_eta(1)=0.
	prior_eta(2)=0.1
	
	prior_bbeta(1)=0.
	prior_bbeta(2)=0.1
	
	!*****STARTING VALUES*****
	
	do i=1,m
		do j=1,m
		gmm(i,j)=1./m	
		end do
	end do
	
	do i=1,m
	mu(i)=sample_mean*i/m	
	lambda(i)=1.		
		do j=1,p
		phi(i,j)=0.			
		end do
	end do
		
	do tt=1,n
	per(tt)=0.	
		do i=1,m
		perH(tt,i)=0.
		end do
	end do

	do tt=1,n
		if (y(tt).gt.-999) then
		y_new(tt)=y(tt)
		else
		y_new(tt)=y_new(tt-1)
		end if	
	end do
		
	!*****END STARTING VALUES*****
	
	do tt=1,n
		do j=1,2*arm,2
		harmonia(tt,j)=dcos(pi*(j+1)/2*tt/s)
		harmonia(tt,j+1)=dsin(pi*(j+1)/2*tt/s)
		end do
	end do
	
	do tt=1,n
		do j=1,2*armH,2
		harmoniaH(tt,j)=dcos(pi*(j+1)/2*tt/q)
		harmoniaH(tt,j+1)=dsin(pi*(j+1)/2*tt/q)
		end do
	end do
	
	do i=1,m
		do j=1,m
		states_couples((i-1)*m+j)=10*i+j
		end do
	end do
	
	!**********BLOCK GIBBS SAMPLING**********
	
	burn_in=500*fact
	write (10000,*) "BURN IN",burn_in
	sample=5000*fact
	write (10000,*) "SAMPLE",sample

	do iteration=1,(burn_in+sample)
	
	write (*,*) "iteration",iteration
			
	!LOG OF THE PDF'S
	
	call pdf (y_new,m,n,pi,mu,lambda,p,phi,per,perH,ln_pdf)			!pmsar01.f
	
	!GENERATION OF THE SEQUENCES OF HIDDEN STATES

	!csi1   t+1|t
	!csi2   t|t
	!csi3   t|t+1,t
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	!GENERATION OF THE LAMBDA'S
	
	call lambdah (m,n,x,y_new,mu,prior_lambda,
     &			  p,phi,per,perH,lambda)							!pmsar06.f
     
      !SELECT A PERMUTATION

	do i=1,m
	matt(1,i)=lambda(i)
	matt(2,i)=i
	end do
	
 434	continue
 
  	do i=1,m-1
		if (matt(1,i).gt.matt(1,i+1)) then
		cargo(1)=matt(1,i)
		cargo(2)=matt(2,i)
		matt(1,i)=matt(1,i+1)
		matt(2,i)=matt(2,i+1)
		matt(1,i+1)=cargo(1)
		matt(2,i+1)=cargo(2)
		goto 434
		end if
	end do
	
	do i=1,m
	lambda(i)=matt(1,i)
	perm(i)=matt(2,i)
	end do
	
	if (iteration.gt.burn_in) then
		do i=1,m
		lambda_mean(i)=(lambda_mean(i)*(iteration-burn_in-1)+
     &	lambda(i))/(iteration-burn_in)
		end do
	end if
		
	do d=1,n/24
		do i=1,m
			if(z(d).eq.i) then
			z(d)=perm(i)
			go to 910
			end if
		end do
 910	continue
	end do
	
	if (iteration.gt.burn_in) then
		do d=1,n/24
			do i=1,m
				if (z(d).eq.i) then
				counts_states(d,i)=counts_states(d,i)+1
				end if
			end do
		end do
	end if
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
	line(i)=mu(i)
	end do
	do i=1,m
	mu(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi(i,j)
		end do
		do i=1,m
		phi(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	!GENERATION OF THE MU'S
	
	call muh (m,n,x,y_new,lambda,prior_mu,p,phi,per,perH,mu)		!pmsar05.f							

	if (iteration.gt.burn_in) then
		do i=1,m
		mu_mean(i)=(mu_mean(i)*(iteration-burn_in-1)
     &	+mu(i))/(iteration-burn_in)
		end do
	end if
	
	!GENERATION OF THE PHI'S
	
	if (p.gt.0) then
	call fi(m,n,p,y_new,x,mu,lambda,prior_phi,per,perH,phi)			!pmsar07.f
	end if
	
	if (iteration.gt.burn_in) then
		do i=1,m
			do j=1,p
			phi_mean(i,j)=(phi_mean(i,j)*(iteration-burn_in-1)
     &		+phi(i,j))/(iteration-burn_in)
			end do
		end do
	end if
	
	!GENERATION OF THE ETA'S
	
	call etah (n,m,p,y_new,x,prior_eta,arm,
     &		   phi,harmonia,mu,lambda,perH,eta)						!pmsar08.f

	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	if (iteration.gt.burn_in) then
		do j=1,2*arm
		eta_mean(j)=(eta_mean(j)*(iteration-burn_in-1)+
     &	eta(j))/(iteration-burn_in)
		end do
	end if
	
	!GENERATION OF THE BETA'S
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,
     &			phi,harmoniaH,mu,lambda,per,bbeta)					!pmsar09.f
     
      do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	if (iteration.gt.burn_in) then
		do i=1,m
			do j=1,2*armH
			bbeta_mean(i,j)=(bbeta_mean(i,j)*(iteration-burn_in-1)+
     &		bbeta(i,j))/(iteration-burn_in)
			end do
		end do
	end if
	
	!GENERATION OF THE TRANSITION PROBABILITIES
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	if (iteration.gt.burn_in) then
		do i=1,m
			do j=1,m
			gmm_mean((i-1)*m+j)=(gmm_mean((i-1)*m+j)*
     &		(iteration-burn_in-1)+gmm(i,j))/(iteration-burn_in)
			end do
		end do
	end if
	
	!GENERATION OF THE MISSING DATA
	
	call miss (m,n,x,y,mu,lambda,p,phi,per,perH,y_ran,y_new)		!pmsar10.f	
	
	if (iteration.gt.burn_in) then
		do tt=1,n
		y_mean(tt)=(y_mean(tt)*(iteration-burn_in-1)
     &	+y_ran(tt))/(iteration-burn_in)
		end do
	end if
	
	end do !do iteration=1,(burn_in+sample)
	
	!**********ESTIMATES**********
		
	!Hidden states
	
	do d=1,n/24
	states_mode(d,1)=counts_states(d,m)
	states_mode(d,2)=m
	end do
	
	do d=1,n/24
		do i=m-1,1,-1
			if (counts_states(d,i).gt.states_mode(d,1)) then
			states_mode(d,1)=counts_states(d,i)
			states_mode(d,2)=i
			end if
		end do
	end do
	
	do d=1,n/24
	write(8000,*),states_mode(d,2)
	end do
	
	!Gamma's
	
	do i=1,m*m
	write (10000,*) "gmm_mean(i,j)=",gmm_mean(i)
	end do
	
	!Delta's
	
	do i=1,m
		do j=1,m
		gmm(i,j)=gmm_mean((i-1)*m+j)
		end do
	end do
	
	call deltah (m,gmm,delta)										!pmsar11.f
	
	do i=1,m
	write (10000,*) "delta(i)=",delta(i)
	end do
	
	!Mu's
	
	do i=1,m
	write (10000,*) "mu_mean(i)=",mu_mean(i)
	end do
	
	!Lambda's
	
	do i=1,m
	write (10000,*) "lambda_mean(i)=",lambda_mean(i)
	end do
		
	!Phi's
	
	do i=1,m
		do j=1,p
		write (10000,*) "phi_mean(i,j)=",phi_mean(i,j)
		end do
	end do
	
	!Eta's
	
	do j=1,2*arm
	write (10000,*) "eta_mean(j)=",eta_mean(j)
	end do
	
	!Bbeta's
	
	do i=1,m
		do j=1,2*armH
		write (10000,*) "bbeta_mean(i,j)=",bbeta_mean(i,j)
		end do
	end do
	
	!Theoric Values

	do tt=1,n
	write (9000,*),y_mean(tt)
	end do
			
	!MEAN ABSOLUT ERROR
		
	summ=0
	do tt=p+1,n
		if (y(tt).gt.-998) then
		a=abs(y(tt)-y_mean(tt))
		summ=summ+a
		end if
	end do

	mean_absolute_error=summ/(nn-p)
	
	write (10000,*) "mean_absolute_error=",mean_absolute_error
	
	!MEAN SQUARED ERROR
		
	summ=0
	do tt=1,n
		if (y(tt).gt.-998) then
		a=((y(tt)-y_mean(tt))**2)
		summ=summ+a
		end if
	end do

	mean_squared_error=summ/(nn-p)
	
	write (10000,*) "mean_squared_error=",mean_squared_error
	
	root_mean_squared_error=dsqrt(mean_squared_error)
	
	write (10000,*) "root_mean_squared_error=",root_mean_squared_error
	
	end !end of the code