      !**********************************************************
	!**   Periodic Markov Switching Autoregressive Models    **
      !**   for Bayesian Analysis and Forecasting of           **   
	!**   Air Pollution                                      **
	!**         L.Spezia - R.Paroli - P.Dellaportas          **
	!**        Statistical Modelling, n.4 1-20, 2004         **
	!**                                                      **
	!**********************************************************
      !*                                                       **
      !*                     FORECASTING                       **
      !**********************************************************
	!*                                                       **
      !*                                                       **
      !*      Fortran90 program (using the IMSL library)       **
	!*                                                       **
	!*%%% This program is free software                      **
	!*                                                       **
	!*%%% Users who use this program in published works      **
	!*%%% are asked to acknowledge its use and cite this     **
	!*%%% paper as reference                                 ** 
	!*                                                       **
	!*                                                       ** 
	!* 													     **
      !*                                                       **
	!* - INPUT data from file 'CO.txt'  - 'fitted.txt'       ** 
	!*         estimates of the parameters at lines 81-118   ** 
	!*                                                       **
      !* - OUTPUT files:  'states.txt' - 'predictions.txt'     **
	!*                  'output.txt' - 'observation.txt'     **
      !*                                                       **
      !* ----------------------------------------------------- **
	!*  Author's contact information:                        **
	!*  Roberta Paroli                                       **
	!*  Istituto di Statistica - Universit Cattolica S.C.   ** 
	!*  Largo Gemelli 1 - 20131 Milano (Italy)               **
	!*  E-mail:roberta.paroli@unicatt.it                     **
	!*                                                       **     
	!**********************************************************

	
	use msimsl
	
	implicit none
	
	integer m,n,p,s,q,arm,armH,n_plus,tt,i,j,burn_in,sample,iteration,
     &d,h,d_pred,z(30000),x(30000),step_ahead,hh,counts_states(30000,9),
     &states_mode(30000,2),missing
	real*8 pi,yy(30000),y(30000),gmm(9,9),mu(9),lambda(9),phi(9,9),
     &eta(22),bbeta(9,22),harmonia(30000,22),harmoniaH(30000,22),
     &per(30000),perH(30000,9),summ,y_extra(30000),ln_pdf(30000,9),
     &huge_ln_pdf(30000,9),witch(24),y_mean(30000),csi1(30000,9),
     &csi2(30000,9),csi3(30000,9),sum1,sum2,jolly,csi22(9),
     &random,y_ran(30000),y_past(30000),y_pred(30000),
     &forecasting(30000),a,predictive_mean_absolute_error,
     &predictive_mean_squared_error,predictive_root_mean_squared_error

	open(7000,file='c:observations.txt')
      open(8000,file='c:states.txt')
      open(9000,file='c:predictions.txt')
      open(10000,file='c:output.txt')
	
	open(111,file='c:forecasting\CO.txt')
	open(222,file='c:fitted.txt')
      read(111,*) (yy(tt),tt=1,25536)
	read(222,*) (y_mean(tt),tt=1,17520)

	do STEP_AHEAD=24,24	
	write (10000,*) "STEP_AHEAD",step_ahead
	write (8000,*) "STEP_AHEAD",step_ahead
	write (9000,*) "STEP_AHEAD",step_ahead
	
	n_plus=25536	
	write (10000,*) "n_plus",n_plus
	n=2*365*24
	write (10000,*) "n",n
	m=3
	write (10000,*) "m",m
	p=1
	write (10000,*) "p",p
	s=365*24/2
	write (10000,*) "s",s
	arm=1	
	write (10000,*) "arm",arm
	q=24/2
	write (10000,*) "q",q
	armH=3	
	write (10000,*) "armH",armH
	
	pi=3.141592653589793
	
	do tt=1,n_plus
		if (yy(tt).eq.0.) then
		yy(tt)=0.1
		end if
		
		if (yy(tt).gt.-998) then
		y(tt)=log(yy(tt))
		else
		y(tt)=-999
		end if
	write(7000,*),y(tt)
	end do
		
	!**********ESTIMATES********** 

	gmm(1,1)=0.646315798177615     
	gmm(1,2)=0.224591213412936     
	gmm(1,3)=0.129092988409444     
	gmm(2,1)=2.449168526113266E-002
	gmm(2,2)=0.623434544582496     
	gmm(2,3)=0.352073770156372     
	gmm(3,1)=2.110910321142169E-002
	gmm(3,2)=0.131669169835870     
 	gmm(3,3)=0.847221726952706     
	mu(1)=0.497005957479938     
	mu(2)=0.116257634261317     
	mu(3)=0.184597116224414     
	lambda(1)=2.29334850308554     
	lambda(2)=7.07164444730258     
	lambda(3)=16.1524243617422     
	phi(1,1)=0.161986384579542     
	phi(2,1)=0.795756424620304     
	phi(3,1)=0.775793953907616     
	eta(1)=0.121544671160378     
	eta(2)=-6.385469753407647E-003
	bbeta(1,1)=-0.274539393893601     
	bbeta(1,2)=-0.250070617790407     
	bbeta(1,3)=-0.204101735304473     
	bbeta(1,4)=-0.339262883275561     
	bbeta(1,5)= 0.154040936422865     
	bbeta(1,6)=3.809175676710680E-003
	bbeta(2,1)=-0.130664839381572     
	bbeta(2,2)=-7.853209580438449E-002
	bbeta(2,3)=-0.195388992845426     
	bbeta(2,4)=-0.123825521471217     
	bbeta(2,5)=0.145698082869302     
	bbeta(2,6)=-1.452983657675405E-002
	bbeta(3,1)=-9.089629139651148E-002
	bbeta(3,2)=-8.564605781550892E-002
	bbeta(3,3)=-0.161520568537590     
	bbeta(3,4)=-0.121020132919188     
	bbeta(3,5)=8.388537856887335E-002
	bbeta(3,6)=-3.685022302091826E-002
	
	do tt=1,n_plus
		do j=1,2*arm,2
		harmonia(tt,j)=dcos(pi*(j+1)/2*tt/s)
		harmonia(tt,j+1)=dsin(pi*(j+1)/2*tt/s)
		end do
	end do
	
	do tt=1,n_plus
		do j=1,2*armH,2
		harmoniaH(tt,j)=dcos(pi*(j+1)/2*tt/q)
		harmoniaH(tt,j+1)=dsin(pi*(j+1)/2*tt/q)
		end do
	end do
	
	do tt=1,n_plus
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	
	do i=1,m
		do tt=1,n_plus
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do

	do tt=1,n
		if (y(tt).gt.-998)then
		y_extra(tt)=y(tt)
		else
		y_extra(tt)=y_mean(tt)
		end if
	end do
	
	!LOG OF THE PDF'S
	
	do d=1,n/24
		do h=1,24
			do i=1,m
			summ=0
				if ((d-1)*24+h.gt.p) then
					if (p.gt.0) then
						do j=1,p
						summ=summ+y_extra((d-1)*24+h-j)*phi(i,j)
						end do
					end if
				huge_ln_pdf((d-1)*24+h,i)=dlog(dsqrt(lambda(i)/
     &			(2*pi)))+(-lambda(i)*((y_extra((d-1)*24+h)-
     &			mu(i)-summ-per((d-1)*24+h)-perH((d-1)*24+h,i))**2)/2)
				else
				huge_ln_pdf((d-1)*24+h,i)=0.
				end if
			end do
		end do
	end do
	
	do i=1,m
		do d=1,n/24
			
			do h=1,24
			witch(h)=huge_ln_pdf((d-1)*24+h,i)
			end do

			ln_pdf(d,i)=0
			do h=1,24
			ln_pdf(d,i)=ln_pdf(d,i)+witch(h)
			end do
		end do
	end do
	
	!FILTERED PROBABILITIES
	
	do i=1,m
	csi1(1,i)=1./m
	end do
		
	do d=1,(n/24)-1
		
		do i=1,m
		csi2(d,i)=dlog(csi1(d,i))+ln_pdf(d,i)
		csi22(i)=csi2(d,i)
		end do
					
 3333		continue
		do i=1,m-1
			if(csi22(i).gt.csi22(i+1)) then
			jolly=csi22(i)
			csi22(i)=csi22(i+1)
			csi22(i+1)=jolly
			goto 3333
			end if
		end do
		
		do i=1,m
		csi2(d,i)=csi2(d,i)-csi22(m)
		end do
		
		sum1=0
		do i=1,m
		sum1=sum1+dexp(csi2(d,i))
		end do
				
		do i=1,m
		csi2(d,i)=dexp(csi2(d,i)-dlog(sum1))
		end do
		
		do i=1,m
			sum2=0
			do j=1,m
			sum2=sum2+csi2(d,j)*gmm(j,i)
			end do
		csi1(d+1,i)=sum2
		end do

	end do

	do i=1,m
	csi2(n/24,i)=dlog(csi1(n/24,i))+ln_pdf(n/24,i)
	csi22(i)=csi2(n/24,i)
	end do
	
 4444	continue
	do i=1,m-1
		if(csi22(i).gt.csi22(i+1)) then
		jolly=csi22(i)
		csi22(i)=csi22(i+1)
		csi22(i+1)=jolly
		goto 4444
		end if
	end do
	
	do i=1,m
	csi2(n/24,i)=csi2(n/24,i)-csi22(m)
	end do
				
	sum1=0
	do i=1,m
	sum1=sum1+dexp(csi2(n/24,i))
	end do
	
	do i=1,m
	csi2(n/24,i)=dexp(csi2(n/24,i)-dlog(sum1))
	end do
	
	!**********FORECASTING**********
	
	burn_in=100								
	write (10000,*) "BURN IN",burn_in
	sample=1000								
	write (10000,*) "SAMPLE",sample

	do iteration=1,burn_in+sample					
	write(*,*) "iteration", iteration
	
	do d_pred=n/24+1,n_plus/24
	
	!GENERATION OF THE FUTURE STATE
	
	do i=1,m
		sum2=0
		do j=1,m
		sum2=sum2+csi2(d_pred-1,j)*gmm(j,i)
		end do
	csi1(d_pred,i)=sum2
	
	end do

	do j=1,m
	csi3(d_pred,j)=csi1(d_pred,j)
	end do
	
	do j=2,m
	csi3(d_pred,j)=csi3(d_pred,j-1)+csi3(d_pred,j)
	end do
	
	call drnun (1,random)
	do j=1,m
		if (random.le.csi3(d_pred,j)) then
		z(d_pred)=j
		goto 20
		end if
	end do
	
 20	continue
	
	if (iteration.gt.burn_in) then
		do i=1,m
			if (z(d_pred).eq.i) then
			counts_states(d_pred,i)=counts_states(d_pred,i)+1
			end if
		end do
	end if
	
	do h=1,24
	x((d_pred-1)*24+h)=z(d_pred)
	end do
	
	!GENERATION OF THE PREDICTIONS
	
	do h=1,24
	
	!write(10000,*) "h",h
	!write(10000,*) "y_extra"
	!do tt=1,(d_pred-1)*24+h
	!write(10000,*) y_extra(tt)
	!end do

	do hh=1,step_ahead
	
	!write(10000,*) "hh",hh
	
	!write(10000,*) "y_ran"
	!do tt=1,(d_pred-1)*24+h
	!write(10000,*) y_ran(tt)
	!end do
	
	if (p.gt.0) then
		do j=1,p
			if ((d_pred-1)*24+h-step_ahead+hh-j.le.(d_pred-1)*24) then
			y_past(j)=y_extra((d_pred-1)*24+h-step_ahead+hh-j)
			else
			y_past(j)=y_ran((d_pred-1)*24+h-step_ahead+hh-j)
			end if		
	!	write(10000,*) "y_past(j)",y_past(j)
		end do
	end if
			
	
	
	if (h+hh.le.step_ahead) then
	
	!write(10000,*) "valore dato di y_extra"
		y_ran((d_pred-1)*24+h-step_ahead+hh)=
     &	y_extra((d_pred-1)*24+h-step_ahead+hh) 
	else
	
	!write(10000,*) "valore costruito"
		do i=1,m
	!write(10000,*) "x =", x((d_pred-1)*24+h) 
	
		if (x((d_pred-1)*24+h).eq.i) then
			if (p.gt.0) then
				summ=0
				do j=1,p
				summ=summ+y_past(j)*phi(i,j)
				end do
			end if
	        call drnnoa(1,random)
	
			y_ran((d_pred-1)*24+h+hh-step_ahead)=mu(i)+summ+
     &		per((d_pred-1)*24+h+hh-step_ahead)+
     &		perH((d_pred-1)*24+h+hh-step_ahead,i)+
     &		random/dsqrt(lambda(i))
	!write(10000,*) "y_ran",y_ran((d_pred-1)*24+h-step_ahead+hh)
		end if
	end do
	
	end if
	
	!write(10000,*) "y_ran",y_ran((d_pred-1)*24+h-step_ahead+hh)	
	
	if (hh.eq.step_ahead) then
	y_pred((d_pred-1)*24+h)=y_ran((d_pred-1)*24+h)
	end if

	if (iteration.gt.burn_in) then
	forecasting((d_pred-1)*24+h)=(forecasting((d_pred-1)*24+h)*
     &(iteration-burn_in-1)+y_pred((d_pred-1)*24+h))/
     &(iteration-burn_in)
	end if
		
	end do	!do hh=1,step_ahead
	    
	end do	!do h=1,24
	

	!GENERATION OF THE STATE GIVEN THE OBSERVATION
	
	!ln_pdf
	
	do tt=(d_pred-1)*24+1,d_pred*24
		if (y(tt).gt.-998)then
		y_extra(tt)=y(tt)
		else
		y_extra(tt)=y_pred(tt)
		end if
	end do
	
	do h=1,24
		do i=1,m
		summ=0
			if (p.gt.0) then
				do j=1,p
				summ=summ+y_extra((d_pred-1)*24+h-j)*phi(i,j)
				end do
			end if
		huge_ln_pdf((d_pred-1)*24+h,i)=dlog(dsqrt(lambda(i)/
     &	(2*pi)))+(-lambda(i)*((y_extra((d_pred-1)*24+h)-mu(i)-
     &	summ-per((d_pred-1)*24+h)-perH((d_pred-1)*24+h,i))**2)/2)
		end do
	end do
	
	do i=1,m
		do h=1,24
		witch(h)=huge_ln_pdf((d_pred-1)*24+h,i)
		end do

		ln_pdf(d_pred,i)=0
		do h=1,24
		ln_pdf(d_pred,i)=ln_pdf(d_pred,i)+witch(h)
		end do
	end do
	
	!csi1 and csi2
	
	do i=1,m
		sum2=0
		do j=1,m
		sum2=sum2+csi2(d_pred-1,j)*gmm(j,i)
		end do
	csi1(d_pred,i)=sum2
	end do
	
	do i=1,m
	csi2(d_pred,i)=dlog(csi1(d_pred,i))+ln_pdf(d_pred,i)
	csi22(i)=csi2(d_pred,i)
	end do
	
 4447	continue
	do i=1,m-1
		if(csi22(i).gt.csi22(i+1)) then
		jolly=csi22(i)
		csi22(i)=csi22(i+1)
		csi22(i+1)=jolly
		goto 4447
		end if
	end do
	
	do i=1,m
	csi2(d_pred,i)=csi2(d_pred,i)-csi22(m)
	end do
				
	sum1=0
	do i=1,m
	sum1=sum1+dexp(csi2(d_pred,i))
	end do
	
	do i=1,m
	csi2(d_pred,i)=dexp(csi2(d_pred,i)-dlog(sum1))
	end do
	
	!csi3
	
	do i=1,m
	csi3(d_pred,i)=csi2(d_pred,i)
	end do
	
	do j=2,m
	csi3(d_pred,j)=csi3(d_pred,j-1)+csi3(d_pred,j)
	end do
	
	call drnun (1,random)
	
	do j=1,m
		if (random.le.csi3(d_pred,j)) then
		z(d_pred)=j
		goto 2417
		end if
	end do
	
 2417	continue
	
	do d=d_pred-1,1,-1
	
		do i=1,m
		csi3(d,i)=csi2(d,i)*gmm(i,z(d+1))
		end do
		
		summ=0
		do i=1,m
		summ=summ+csi3(d,i)
		end do
	
		do i=1,m
		csi3(d,i)=csi3(d,i)/summ
		end do
	
		do j=2,m
		csi3(d,j)=csi3(d,j-1)+csi3(d,j)
		end do
		
		call drnun (1,random)
	
		do j=1,m
			if (random.le.csi3(d,j)) then
			z(d)=j
			goto 30
			end if
		end do
 30	continue

	end do
	
	do d=1,d_pred
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	end do	!do d_pred=n/24+1,n_plus/24
	
	end do	!do iteration=1,burn_in+sample	
	
	!Hidden states
	
	do d=n/24+1,n_plus/24
	states_mode(d,1)=counts_states(d,m)
	states_mode(d,2)=m
	end do
	
	do d=n/24+1,n_plus/24
		do i=m-1,1,-1
			if (counts_states(d,i).gt.states_mode(d,1)) then
			states_mode(d,1)=counts_states(d,i)
			states_mode(d,2)=i
			end if
		end do
	end do
	
	do d=n/24+1,n_plus/24
	write(8000,*),states_mode(d,2)
	end do
	
	!Theoric Values

	do tt=n+1,n_plus
	write (9000,*),forecasting(tt)
	end do
			
	!MEAN ABSOLUT ERROR
		
	missing=0
	do tt=n+p+1,n_plus
		if (y(tt).eq.-999) then
		missing=missing+1
		end if
	end do
		
	summ=0
	do tt=n+p+1,n_plus
		if (y(tt).gt.-998) then
		summ=summ+abs(y(tt)-forecasting(tt))
		end if
	end do

	predictive_mean_absolute_error=summ/(n_plus-n-missing-p)
	
	write (10000,*) "predictive_mean_absolute_error=",
     &predictive_mean_absolute_error
	
	!MEAN SQUARED ERROR
		
	summ=0
	do tt=n+p+1,n_plus
		if (y(tt).gt.-998) then
		summ=summ+((y(tt)-forecasting(tt))**2)
		end if
	end do

	predictive_mean_squared_error=summ/(n_plus-n-missing-p)
	
	write (10000,*) "predictive_mean_squared_error=",
     &predictive_mean_squared_error
	
	predictive_root_mean_squared_error=
     &dsqrt(predictive_mean_squared_error)
	
	write (10000,*) "predictive_root_mean_squared_error=",
     &predictive_root_mean_squared_error
	
	write (10000,*) "alarm level: 15"
	write (10000,*) "LN(alarm level):",dlog(15.D00)
	do tt=n+1,n_plus
		if (y(tt).gt.dlog(15.D00)) then
		write(10000,*),tt,int(tt/24)+1,y(tt),forecasting(tt)
		end if
	end do
	
	do tt=n+1,n_plus
		if (forecasting(tt).gt.dlog(15.D00)) then
		write(10000,*),tt,int(tt/24)+1,y(tt),forecasting(tt)
		end if
	end do
	
	end do	!do STEP_AHEAD=1,6
	
	end	!end of the code