	!**********************************************************
	!**   Periodic Markov Switching Autoregressive Models    **
	!**   for Bayesian Analysis and Forecasting of           **   
	!**   Air Pollution                                      **
	!**         L.Spezia - R.Paroli - P.Dellaportas          **
	!**        Statistical Modelling, n.4 1-20, 2004         **
	!**                                                      **
	!**********************************************************
      !*                                                       **
      !*                   MODEL CHOICE                        **  
	!**********************************************************
	!*                                                       **
      !*                                                       **
      !*      Fortran90 program (using the IMSL library)       **
	!*                                                       **
	!*%%% This program is free software                      **
	!*                                                       **
	!*%%% Users who use this program in published works      **
	!*%%% are asked to acknowledge its use and cite this     **
	!*%%% paper as reference                                 ** 
	!*                                                       **
	!*                                                       **
	!* - This main has to be linked with the following       **
	!*     subroutines                                       **
	!*                                                       **
	!*     PMSAR01 - PMSAR02 - PMSAR03 - PMSAR04             **
      !*     PMSAR05 - PMSAR06 - PMSAR07 - PMSAR08             **
	!*     PMSAR09 - PMSAR10 - PMSAR11 - PMSAR12             **
      !*													     **
      !*                                                       **
	!* - INPUT data from file 'CO.txt'                       **
      !* - OUTPUT file 'output.txt'                            **  
	!*                                                       **
      !*                                                       **
	!*                                                       ** 
	!* ----------------------------------------------------- **
	!*  Author's contact information:                        **
	!*  Roberta Paroli                                       **
	!*  Istituto di Statistica - Universit Cattolica S.C.   ** 
	!*  Largo Gemelli 1 - 20131 Milano (Italy)               **
	!*  E-mail:roberta.paroli@unicatt.it                     **
	!*                                                       **     
	!**********************************************************

	use msimsl
	
	implicit none
	
	real*8 pi,y(30000),prior_gmm(9*9),prior_mu(2),gmm(9,9),
     &sample_mean,mu(9),lambda(9),y_new(30000),gmm_mean(9*9),
     &mu_mean(9),lambda_mean(9),ln_pdf(30000,9),csi1(30000,9),
     &csi2(30000,9),csi3(30000,9),y_ran(30000),summ,prior_lambda(2),
     &prior_phi(2),phi(9,9),phi_mean(9,9),harmonia(30000,22),per(30000),
     &prior_eta(2),eta(22),eta_mean(22),harmoniaH(30000,22),
     &prior_bbeta(2),perH(30000,9),bbeta(9,22),bbeta_mean(9,22),
     &posterior,ppsi(3000),ppsi_star(3000),gmm_star(9,9),mu_star(9),
     &lambda_star(9),phi_star(9,9),eta_star(22),bbeta_star(9,22),
     &ln_margy,sum_data(9),full(9),full_mean,sum_squares(9),mu_phi(9),
     &lambda_phi(9,9),line(9),mu_lambda_phi(9),past(30000,9),
     &pastpast(9,30000),fac_eta(22,22),precision_phi(9,9),
     &covariance_phi(9,9),chol_phi(9,9),mean_phi(9),fac_phi(9,9),rcondd,
     &det1,det2,dett,norm_const_2,a,aa,b,bb,cc,mu_eta(22),
     &lambda_eta(22,22),mu_lambda_eta(22),ainomrah(22,30000),
     &precision_eta(22,22),covariance_eta(22,22),mean_eta(22),
     &mu_bbeta(22),lambda_bbeta(22,22),yy(30000),mu_lambda_bbeta(22),
     &Hhainomrah(22,30000),precision_bbeta(22,22),hyp,
     &covariance_bbeta(22,22),mean_bbeta(22),fac_bbeta(22,22),
     &typhoon(9),monsoon(9),hurricane(30000),cyclone(22),
     &tropical_storm(22),tornado(22),jolly,black_owl,
     &el_nino(30000),
     &silvio_manuel(9)
	real norm_const
	integer n,nn,m,p,i,j,jj,tt,d,h,s,q,arm,armH,missing,perm(9),
     &burn_in,sample,iteration,fact,c,
     &states_couples(9*9),z(30000),sum_states(9),ipvt_phi(9),x(30000),
     &ipvt_eta(22),ipvt_bbeta(22),ten(30000),sumx,counts_couples(9*9),
     &la_gorda(30000)

	open(10000,file='c:\output.txt')	!output file
			
	open(111,file='c:\CO.txt')			!data file
	read(111,*) (yy(tt),tt=1,25536)
	
	do m=1,4
	do p=0,2
			
	n=2*365*24		

	write (10000,*) "n",n
	write (10000,*) "m",m
	write (10000,*) "p",p
	s=365*24/2
	write (10000,*) "s",s
	arm=1	
	write (10000,*) "arm",arm
	q=24/2
	write (10000,*) "q",q
	armH=3	
	write (10000,*) "armH",armH

	pi=3.141592653589793
	
	fact=1
	do i=2,m
	fact=fact*i
	end do
	
		do tt=1,n
		if (yy(tt).eq.0.) then
		yy(tt)=0.1
		end if
		
		if (yy(tt).gt.-998) then
		y(tt)=log(yy(tt))
		else
		y(tt)=-999
		end if
	end do
	
	missing=0
	
	do tt=1,n
		if (y(tt).eq.-999) then
		missing=missing+1
		end if
	end do
	
	nn=n-missing
	
	write (10000,*) "missing",missing
	
	sample_mean=0
	do tt=1,n
		if (y(tt).gt.-998) then
		sample_mean=sample_mean+y(tt)
		end if
	end do
	sample_mean=sample_mean/nn
	
	!*****PRIOR PARAMETERS*****
	
	do i=1,m
		do j=1,m 
			if (i.eq.j) then
			prior_gmm((i-1)*m+j)=m
			else
			prior_gmm((i-1)*m+j)=0.6
			end if
		end do
	end do
	
	hyp=15./2
	prior_mu(1)=dlog(hyp)	
	prior_mu(2)=0.1
				
	prior_lambda(1)=1.
	prior_lambda(2)=1.			
		
	prior_phi(1)=0.
	prior_phi(2)=0.1
	
	prior_eta(1)=0.
	prior_eta(2)=0.1
	
	prior_bbeta(1)=0.
	prior_bbeta(2)=0.1
	
	!*****STARTING VALUES*****
	
	do i=1,m
		do j=1,m
		gmm(i,j)=1./m	
		end do
	end do
	
	do i=1,m
	mu(i)=sample_mean*i/m	
	lambda(i)=1.		
		do j=1,p
		phi(i,j)=0.			
		end do
	end do
		
	do tt=1,n
	per(tt)=0.	
		do i=1,m
		perH(tt,i)=0.
		end do
	end do

	do tt=1,n
		if (y(tt).gt.-999) then
		y_new(tt)=y(tt)
		else
		y_new(tt)=y_new(tt-1)
		end if	
	end do
		
	!*****END STARTING VALUES*****
	
	do tt=1,n
		do j=1,2*arm,2
		harmonia(tt,j)=dcos(pi*(j+1)/2*tt/s)
		harmonia(tt,j+1)=dsin(pi*(j+1)/2*tt/s)
		end do
	end do
	
	do tt=1,n
		do j=1,2*armH,2
		harmoniaH(tt,j)=dcos(pi*(j+1)/2*tt/q)
		harmoniaH(tt,j+1)=dsin(pi*(j+1)/2*tt/q)
		end do
	end do
	
	do i=1,m
		do j=1,m
		states_couples((i-1)*m+j)=10*i+j
		end do
	end do
	
	!**********BLOCK GIBBS SAMPLING**********
	
	burn_in=500*fact
	write (10000,*) "BURN IN",burn_in
	sample=5000*fact
	write (10000,*) "SAMPLE",sample

	do iteration=1,(burn_in+sample)
	
	write (*,*) "iteration",iteration
			
	!LOG OF THE PDF'S
	
	call pdf (y_new,m,n,pi,mu,lambda,p,phi,per,perH,ln_pdf)			!pmsar01.f
	
	!GENERATION OF THE SEQUENCES OF HIDDEN STATES

	!csi1   t+1|t
	!csi2   t|t
	!csi3   t|t+1,t
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	!GENERATION OF THE TRANSITION PROBABILITIES
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	!GENERATION OF THE MU'S
	
	call muh (m,n,x,y_new,lambda,prior_mu,p,phi,per,perH,mu)		!pmsar05.f							
		
	!GENERATION OF THE LAMBDA'S
	
	call lambdah (m,n,x,y_new,mu,prior_lambda,
     &			  p,phi,per,perH,lambda)							!pmsar06.f
					
	!GENERATION OF THE PHI'S
	
	if (p.gt.0) then
	call fi(m,n,p,y_new,x,mu,lambda,prior_phi,per,perH,phi)			!pmsar07.f
	end if
					
	!GENERATION OF THE ETA'S
	
	call etah (n,m,p,y_new,x,prior_eta,arm,
     &		   phi,harmonia,mu,lambda,perH,eta)						!pmsar08.f

	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	if (iteration.gt.burn_in) then
		do j=1,2*arm
		eta_mean(j)=(eta_mean(j)*(iteration-burn_in-1)+
     &	eta(j))/(iteration-burn_in)
		end do
	end if
	
	!GENERATION OF THE BETA'S
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,
     &			phi,harmoniaH,mu,lambda,per,bbeta)					!pmsar09.f

	!SELECTION OF A PERMUTATION
	
	do i=1,m
 740	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 740
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 910
				end if
			end do
 910		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	if (iteration.gt.burn_in) then
		do i=1,m
			do j=1,m
			gmm_mean((i-1)*m+j)=(gmm_mean((i-1)*m+j)*
     &		(iteration-burn_in-1)+gmm(i,j))/(iteration-burn_in)
			end do
		end do
	end if
	
	do i=1,m
	line(i)=mu(i)
	end do
	do i=1,m
	mu(i)=line(perm(i))
	end do
	
	if (iteration.gt.burn_in) then
		do i=1,m
		mu_mean(i)=(mu_mean(i)*(iteration-burn_in-1)+
     &	mu(i))/(iteration-burn_in)
		end do
	end if
		
	do i=1,m
	line(i)=lambda(i)
	end do
	do i=1,m
	lambda(i)=line(perm(i))
	end do
	
	if (iteration.gt.burn_in) then
		do i=1,m
		lambda_mean(i)=(lambda_mean(i)*(iteration-burn_in-1)+
     &	lambda(i))/(iteration-burn_in)
		end do
	end if

	do j=1,p
		do i=1,m
		line(i)=phi(i,j)
		end do
		do i=1,m
		phi(i,j)=line(perm(i))
		end do
	end do
	
	if (iteration.gt.burn_in) then
		do i=1,m
			do j=1,p
			phi_mean(i,j)=(phi_mean(i,j)*(iteration-burn_in-1)+
     &		phi(i,j))/(iteration-burn_in)
			end do
		end do
	end if
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	if (iteration.gt.burn_in) then
		do i=1,m
			do j=1,2*armH
			bbeta_mean(i,j)=(bbeta_mean(i,j)*(iteration-burn_in-1)+
     &		bbeta(i,j))/(iteration-burn_in)
			end do
		end do
	end if
	
	!GENERATION OF THE MISSING DATA
	
	call miss (m,n,x,y,mu,lambda,p,phi,per,perH,y_ran,y_new)		!pmsar10.f	
	
	!POSTERIOR MODE
		
	if (iteration.eq.burn_in+1) then
	
	call post (n,m,p,arm,armH,pi,sample_mean,csi1,y,
     &		   mu,lambda,phi,eta,bbeta,gmm,per,perH,
     &		   prior_gmm,prior_mu,prior_lambda,prior_phi,
     &		   prior_eta,prior_bbeta,posterior)						!pmsar11.f
      
		do i=1,m
			do j=1,m
			ppsi_star((i-1)*m+j)=gmm(i,j)
			end do
		end do
	
		do i=1,m
		ppsi_star(m*m+i)=mu(i)
		ppsi_star(m*m+m+i)=lambda(i)
		end do
	
		do i=1,m
			do j=1,p
			ppsi_star(m*m+2*m+(i-1)*p+j)=phi(i,j)
			end do
		end do
	
		do j=1,2*arm
		ppsi_star(m*m+2*m+m*p+j)=eta(j)
		end do
		
		do i=1,m
			do j=1,2*armH
			ppsi_star(m*m+2*m+m*p+2*arm+(i-1)*2*armH+j)=bbeta(i,j)
			end do
		end do
		ppsi_star(m*m+2*m+m*p+2*arm+m*2*armH+1)=posterior
	
	end if
		
	if (iteration.gt.burn_in+1) then
	call post (n,m,p,arm,armH,pi,sample_mean,csi1,y,
     &		   mu,lambda,phi,eta,bbeta,gmm,per,perH,
     &		   prior_gmm,prior_mu,prior_lambda,prior_phi,
     &		   prior_eta,prior_bbeta,posterior)						!pmsar11.f
	
		do i=1,m
			do j=1,m
			ppsi((i-1)*m+j)=gmm(i,j)
			end do
		end do
	
		do i=1,m
		ppsi(m*m+i)=mu(i)
		ppsi(m*m+m+i)=lambda(i)
		end do
	
		do i=1,m
			do j=1,p
			ppsi(m*m+2*m+(i-1)*p+j)=phi(i,j)
			end do
		end do
	
		do j=1,2*arm
		ppsi(m*m+2*m+m*p+j)=eta(j)
		end do
	
		do i=1,m
			do j=1,2*armH
			ppsi(m*m+2*m+m*p+2*arm+(i-1)*2*armH+j)=bbeta(i,j)
			end do
		end do	
	
			ppsi(m*m+2*m+m*p+2*arm+m*2*armH+1)=posterior
	
		if (ppsi(m*m+2*m+m*p+2*arm+m*2*armH+1).gt.
     &	ppsi_star(m*m+2*m+m*p+2*arm+m*2*armH+1)) then
			do i=1,m*m+2*m+m*p+2*arm+m*2*armH+1
			ppsi_star(i)=ppsi(i)
			end do
		end if
	
	end if
	
	end do !do iteration=1,(burn_in+sample)
	
	!**********ESTIMATES**********
		
	!Gamma's
	
	do i=1,m*m
	write (10000,*) "gmm_mean(i,j)=",gmm_mean(i)
	end do
	
	!Mu's
	
	do i=1,m
	write (10000,*) "mu_mean(i)=",mu_mean(i)
	end do
	
	!Lambda's
	
	do i=1,m
	write (10000,*) "lambda_mean(i)=",lambda_mean(i)
	end do
		
	!Phi's
	
	do i=1,m
		do j=1,p
		write (10000,*) "phi_mean(i,j)=",phi_mean(i,j)
		end do
	end do
	
	!Eta's
	
	do j=1,2*arm
	write (10000,*) "eta_mean(j)=",eta_mean(j)
	end do
	
	!Bbeta's
	
	do i=1,m
		do j=1,2*armH
		write (10000,*) "bbeta_mean(i,j)=",bbeta_mean(i,j)
		end do
	end do
	
	!**********MARGINAL LIKELIHOOD**********
	
	do i=1,m
		do j=1,m
		gmm_star(i,j)=ppsi_star((i-1)*m+j)
		end do
	end do
	
	do i=1,m
	mu_star(i)=ppsi_star(m*m+i)
	lambda_star(i)=ppsi_star(m*m+m+i)
	end do
	
	do i=1,m
		do j=1,p
		phi_star(i,j)=ppsi_star(m*m+2*m+(i-1)*p+j)
		end do
	end do
			
	do j=1,2*arm
	eta_star(j)=ppsi_star(m*m+2*m+m*p+j)
	end do
		
	do i=1,m
		do j=1,2*armH
		bbeta_star(i,j)=ppsi_star(m*m+2*m+m*p+2*arm+(i-1)*m+j)
		end do
	end do
	
	ln_margy=ppsi_star(m*m+2*m+m*p+2*arm+m*2*armH+1)
		
	write (10000,*) "num_ln_margy=",ln_margy
	
	!EXTRA-GIBBS_1
	
	write (10000,*),"extra_1"
	
	do iteration=1,sample/5
	
	write (*,*) "extra_1",iteration
	
	call pdf (y_new,m,n,pi,mu,lambda,p,phi,per,perH,ln_pdf)			!pmsar01.f
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	call muh (m,n,x,y_new,lambda,prior_mu,p,phi,per,perH,mu)		!pmsar05.f							
		
	call lambdah (m,n,x,y_new,mu,prior_lambda,
     &			  p,phi,per,perH,lambda)							!pmsar06.f
					
	if (p.gt.0) then
	call fi(m,n,p,y_new,x,mu,lambda,prior_phi,per,perH,phi)			!pmsar07.f
	end if
					
	call etah (n,m,p,y_new,x,prior_eta,arm,
     &		   phi,harmonia,mu,lambda,perH,eta)						!pmsar08.f

	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,
     &			phi,harmoniaH,mu,lambda,per,bbeta)					!pmsar09.f

	do i=1,m
 741	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 741
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 911
				end if
			end do
 911		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
	line(i)=mu(i)
	end do
	do i=1,m
	mu(i)=line(perm(i))
	end do
	
	do i=1,m
	line(i)=lambda(i)
	end do
	do i=1,m
	lambda(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi(i,j)
		end do
		do i=1,m
		phi(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	do i=1,m
	line(i)=mu_star(i)
	end do
	do i=1,m
	mu_star(i)=line(perm(i))
	end do
	
	call miss (m,n,x,y,mu,lambda,p,phi,per,perH,y_ran,y_new)		!pmsar10.f
	
	do i=1,m
	sum_data(i)=0
	sum_states(i)=0
		do d=1,n/24
			do h=1,24
				if ((d-1)*24+h.gt.p) then
				summ=0
					if (x((d-1)*24+h).eq.i) then
						if (p.gt.0) then
							do j=1,p
							summ=summ+y_new((d-1)*24+h-j)*phi(i,j)
							end do
						end if
					sum_states(i)=sum_states(i)+1
					sum_data(i)=sum_data(i)+y_new((d-1)*24+h)-
     &				summ-per((d-1)*24+h)-perH((d-1)*24+h,i)
					end if
				end	if
			end do
		end do
	end do
	
	do j=1,m
	full(j)=dlog(dsqrt((sum_states(j)*lambda(j)+prior_mu(2))
     &/(2*pi)))-(sum_states(j)*lambda(j)+prior_mu(2))/2*
     &(mu_star(j)-((lambda(j)*sum_data(j)+prior_mu(1)*
     &prior_mu(2))/(sum_states(j)*lambda(j)+prior_mu(2))))**2
	end do
	
	summ=0
	do j=1,m
	summ=summ+full(j)
	end do

	full_mean=(full_mean*(iteration-1)+dexp(summ))/iteration
	
	end do !do iteration=1,sample (extra-gibbs_1)
	
	
	ln_margy=ln_margy-dlog(full_mean)

	write (10000,*) "full_mean",full_mean
	write (10000,*) "ln_margy",ln_margy
	
	!EXTRA-GIBBS_2
	
	write (10000,*),"extra_2"
	
	do iteration=1,sample/5
	
	write (*,*) "extra_2",iteration
		
	call pdf (y_new,m,n,pi,mu_star,lambda,p,phi,per,perH,ln_pdf)	!pmsar01.f
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	call lambdah (m,n,x,y_new,mu_star,prior_lambda,
     &			  p,phi,per,perH,lambda)							!pmsar06.f
					
	if (p.gt.0) then
	call fi(m,n,p,y_new,x,mu_star,lambda,prior_phi,per,perH,phi)	!pmsar07.f
	end if
					
	call etah (n,m,p,y_new,x,prior_eta,arm,phi,
     &		   harmonia,mu_star,lambda,perH,eta)					!pmsar08.f

	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,phi,
     &			harmoniaH,mu_star,lambda,per,bbeta)					!pmsar09.f

	do i=1,m
 742	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 742
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 912
				end if
			end do
 912		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
	line(i)=lambda(i)
	end do
	do i=1,m
	lambda(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi(i,j)
		end do
		do i=1,m
		phi(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	do i=1,m
	line(i)=mu_star(i)
	end do
	do i=1,m
	mu_star(i)=line(perm(i))
	end do
	
	do i=1,m
	line(i)=lambda_star(i)
	end do
	do i=1,m
	lambda_star(i)=line(perm(i))
	end do
	
	call miss (m,n,x,y,mu_star,lambda,p,phi,per,perH,y_ran,y_new)	!pmsar10.f
	
	do i=1,m
	sum_states(i)=0
	sum_squares(i)=0
		do d=1,n/24
			do h=1,24
				if ((d-1)*24+h.gt.p) then
				summ=0
					if (x((d-1)*24+h).eq.i) then
						if (p.gt.0) then
							do j=1,p
							summ=summ+y_new((d-1)*24+h-j)*phi(i,j)
							end do
						end if
					sum_states(i)=sum_states(i)+1
					sum_squares(i)=sum_squares(i)+((y_new((d-1)*24+h)-
     &				mu_star(i)-summ-per((d-1)*24+h)-
     &				perH((d-1)*24+h,i))**2)
					end if
				end if
			end do
		end do
	end do
	
	do j=1,m
	full(j)=((sum_states(j)/2+prior_lambda(1))*
     &log(sum_squares(j)/2+prior_lambda(2)))-
     &(DLNGAM(sum_states(j)/2+prior_lambda(1)))+
     &((sum_states(j)/2+prior_lambda(1)-1)*dlog(lambda_star(j)))-
     &((sum_squares(j)/2+prior_lambda(2))*lambda_star(j))
      end do
	     
      summ=0
	do j=1,m
	summ=summ+full(j)
	end do

	full_mean=(full_mean*(iteration-1)+dexp(summ))/iteration
	
	end do !do iteration=1,sample (extra-gibbs_2)
	
	ln_margy=ln_margy-dlog(full_mean)

	write (10000,*) "full_mean",full_mean
	write (10000,*) "ln_margy",ln_margy
	
	!EXTRA-GIBBS_3
	
	if (p.gt.0) then
	
	write (10000,*),"extra_3"
	
	do iteration=1,sample/5
	
	write (*,*) "extra_3",iteration
		
	call pdf (y_new,m,n,pi,mu_star,lambda_star,
     &		  p,phi,per,perH,ln_pdf)								!pmsar01.f
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	if (p.gt.0) then
	call fi(m,n,p,y_new,x,mu_star,lambda_star,
     &		prior_phi,per,perH,phi)									!pmsar07.f
	end if
					
	call etah (n,m,p,y_new,x,prior_eta,arm,phi,harmonia,
     &		   mu_star,lambda_star,perH,eta)						!pmsar08.f

	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,phi,harmoniaH,
     &			mu_star,lambda_star,per,bbeta)						!pmsar09.f

	do i=1,m
 743	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 743
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 913
				end if
			end do
 913		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi(i,j)
		end do
		do i=1,m
		phi(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	do i=1,m
	line(i)=mu_star(i)
	end do
	do i=1,m
	mu_star(i)=line(perm(i))
	end do
	
	do i=1,m
	line(i)=lambda_star(i)
	end do
	do i=1,m
	lambda_star(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi_star(i,j)
		end do
		do i=1,m
		phi_star(i,j)=line(perm(i))
		end do
	end do
	
	call miss (m,n,x,y,mu_star,lambda_star,
     &	   	   p,phi,per,perH,y_ran,y_new)							!pmsar10.f	
	
	do j=1,p
		mu_phi(j)=prior_phi(1)
		do jj=1,p 
			if (j.eq.jj) then
			lambda_phi(j,jj)=prior_phi(2)
			else
			lambda_phi(j,jj)=0
			end if
		end do
	end do
	
	do j=1,p
		mu_lambda_phi(j)=0
		do jj=1,p 
		mu_lambda_phi(j)=mu_lambda_phi(j)+lambda_phi(j,jj)*mu_phi(jj)
		end do
	end do

	do tt=p+1,n
		do j=1,p
		past(tt,j)=y_new(tt-j)
		end do
	end do
	
	do tt=1,n
		do j=1,p
		pastpast(j,tt)=past(tt,j)
		end do
	end do
		
	do i=1,m !*****
	
	do j=1,p
		do jj=1,p
		precision_phi(j,jj)=0
		end do
	end do
	
	do j=1,p
		do jj=1,p
			summ=0
			do d=1,n/24
				do h=1,24
					if ((d-1)*24+h.gt.p) then
						if (x((d-1)*24+h).eq.i) then
						summ=summ+
     &					pastpast(j,(d-1)*24+h)*past((d-1)*24+h,jj)
						end if
					end if
				end do
			end do
		precision_phi(j,jj)=summ*lambda(i)+lambda_phi(j,jj)
		end do
	end do
	
	if (p.gt.1) then
	call dlinrg(p,precision_phi,9,covariance_phi,9)
	else
	covariance_phi(1,1)=1/precision_phi(1,1)
	end if
	
	do tt=1,n
	el_nino(tt)=0
	end do
	
	do d=1,n/24
		do h=1,24
			if ((d-1)*24+h.gt.p) then
				if (x((d-1)*24+h).eq.i) then
				el_nino((d-1)*24+h)=(y_new((d-1)*24+h)-mu_star(i)-
     &			per((d-1)*24+h)-perH((d-1)*24+h,i))*lambda_star(i)
				end if
			end if
		end do	
	end do	
	
	do j=1,p
		summ=mu_lambda_phi(j)
		do tt=p+1,n
		summ=summ+pastpast(j,tt)*el_nino(tt)
		end do
		silvio_manuel(j)=summ
	end do	
	
	do j=1,p
	summ=0
		do jj=1,p
		summ=summ+covariance_phi(j,jj)*silvio_manuel(jj)
		end do
	mean_phi(j)=summ
	end do
		
	if (p.gt.1) then
	
		call dlfcrg (p,covariance_phi,9,fac_phi,9,ipvt_phi,rcondd)
		
		call dlfdrg (p,fac_phi,9,ipvt_phi,det1,det2)
	
		dett=det1*(10**det2)
	
	else
	dett=covariance_phi(1,1)
	end if
	
	do j=1,p
	typhoon(j)=phi_star(i,j)-mean_phi(j)
	end do
	
	do j=1,p
		summ=0
		do jj=1,p
		summ=summ+typhoon(jj)*precision_phi(jj,j)
		end do
		monsoon(j)=summ
	end do
	
	summ=0
	do j=1,p
	summ=summ+monsoon(j)*typhoon(j)
	end do
	
	if (p.eq.1) then
	a=DNORDF((1-mean_phi(1))*dsqrt(precision_phi(1,1)))-
     &DNORDF((-1-mean_phi(1))*dsqrt(precision_phi(1,1)))
		if(a.lt.aa) then
		a=aa
		end if
	full(i)=-dlog(a)+(-p/2)*dlog(2*pi)-(dlog(dett))/2-summ/2
	end if
	
	if (p.eq.2) then
	call intt (p,mean_phi,covariance_phi,norm_const)			!pmsar12.f
	norm_const_2=norm_const
		if(norm_const_2.lt.aa) then
		norm_const_2=aa
		end if
	full(i)=-dlog(norm_const_2)+(-p/2)*dlog(2*pi)-
     &(dlog(dett))/2-summ/2
	end if	
	
	end do !*****
	     
      summ=0
	do j=1,m
	summ=summ+full(j)
	end do

	
	full_mean=(full_mean*(iteration-1)+dexp(summ))/iteration
	
	end do !do iteration=1,sample (extra-gibbs_3)

	ln_margy=ln_margy-dlog(full_mean)

	write (10000,*) "full_mean",full_mean
	write (10000,*) "ln_margy",ln_margy
	
	end if	!if (p.gt.0)
	
	!EXTRA-GIBBS_4
	
	write (10000,*),"extra_4"
	
	do iteration=1,sample/5
	
	write (*,*) "extra_4",iteration
		
	call pdf (y_new,m,n,pi,mu_star,lambda_star,
     &		  p,phi_star,per,perH,ln_pdf)							!pmsar01.f
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	call etah (n,m,p,y_new,x,prior_eta,arm,phi_star,
     &		   harmonia,mu_star,lambda_star,perH,eta)				!pmsar08.f

	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,phi_star,
     &			 harmoniaH,mu_star,lambda_star,per,bbeta)			!pmsar09.f

	do i=1,m
 744	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 744
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 914
				end if
			end do
 914		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi(i,j)
		end do
		do i=1,m
		phi(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
		
	do i=1,m
	line(i)=mu_star(i)
	end do
	do i=1,m
	mu_star(i)=line(perm(i))
	end do
	
	do i=1,m
	line(i)=lambda_star(i)
	end do
	do i=1,m
	lambda_star(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi_star(i,j)
		end do
		do i=1,m
		phi_star(i,j)=line(perm(i))
		end do
	end do
	
	call miss (m,n,x,y,mu_star,lambda_star,p,
     &	   	   phi_star,per,perH,y_ran,y_new)						!pmsar10.f	
	
	do j=1,2*arm
		mu_eta(j)=prior_eta(1)
		do jj=1,2*arm 
			if (j.eq.jj) then
			lambda_eta(j,jj)=prior_eta(2)
			else
			lambda_eta(j,jj)=0
			end if
		end do
	end do
	
	do j=1,2*arm
		mu_lambda_eta(j)=0
		do jj=1,2*arm 
		mu_lambda_eta(j)=mu_lambda_eta(j)+
     &	lambda_eta(j,jj)*mu_eta(jj)
		end do
	end do
	
	do tt=1,n
		do i=1,m
			if(x(tt).eq.i) then
				do j=1,2*arm
				ainomrah(j,tt)=harmonia(tt,j)*lambda_star(i)	
				end do
			end if
		end do
	end do
	
	do j=1,2*arm
		do jj=1,2*arm
		precision_eta(j,jj)=lambda_eta(j,jj)
		end do
	end do
	
	do j=1,2*arm
		do jj=1,2*arm
			summ=0
			do tt=p+1,n
			summ=summ+ainomrah(j,tt)*harmonia(tt,jj)
			end do
		precision_eta(j,jj)=precision_eta(j,jj)+summ
		end do
	end do
	
	call dlinrg(2*arm,precision_eta,22,covariance_eta,22)
	
	do d=1,n/24
		do h= 1,24
			do i=1,m
				if ((d-1)*24+h.gt.p) then
					summ=0
					if (x((d-1)*24+h).eq.i) then
						if (p.gt.0) then
							do j=1,p
							summ=summ+
     &						y_new((d-1)*24+h-j)*phi_star(i,j)
							end do
						hurricane((d-1)*24+h)=y_new((d-1)*24+h)-
     &					mu_star(i)-summ-perH((d-1)*24+h,i)
						end if
					end if
				end if
			end do
		end do
	end do					
	
	do j=1,2*arm
		summ=mu_lambda_eta(j)
		do tt=p+1,n
		summ=summ+ainomrah(j,tt)*hurricane(tt)
		end do
		cyclone(j)=summ
	end do	
	
	do j=1,2*arm
	summ=0
		do jj=1,2*arm
		summ=summ+covariance_eta(j,jj)*cyclone(jj)
		end do
	mean_eta(j)=summ
	end do
	
	do j=1,2*arm
	tropical_storm(j)=eta_star(j)-mean_eta(j)
	end do
	
	do j=1,2*arm
	summ=0
		do jj=1,2*arm
		summ=summ+tropical_storm(jj)*precision_eta(jj,j)
		end do
	tornado(j)=summ
	end do
	
	summ=0
	do j=1,2*arm
	summ=summ+tornado(j)*tropical_storm(j)
	end do

	call dlfcrg (2*arm,covariance_eta,22,
     &			fac_eta,22,ipvt_eta,rcondd)
		
	call dlfdrg (2*arm,fac_eta,22,ipvt_eta,det1,det2)
	
	dett=det1*(10**det2)

	summ=-arm*dlog(2*pi)-(dlog(dett))/2-summ/2
	
	
	full_mean=(full_mean*(iteration-1)+dexp(summ))/iteration
	
	end do !do iteration=1,sample (extra-gibbs_4)
	
	
	ln_margy=ln_margy-dlog(full_mean)

	write (10000,*) "full_mean",full_mean
	write (10000,*) "ln_margy",ln_margy
	
	!EXTRA-GIBBS_5
	
	write (10000,*),"extra_5"
	
	do tt=1,n
	summ=0
		do j=1,2*arm
		summ=summ+eta_star(j)*harmonia(tt,j)	
		end do
	per(tt)=summ
	end do
	
	do iteration=1,sample/5
	
	write (*,*) "extra_5",iteration
		
	call pdf (y_new,m,n,pi,mu_star,lambda_star,
     &		  p,phi_star,per,perH,ln_pdf)							!pmsar01.f
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	call bbetah	(n,m,p,y_new,x,prior_bbeta,armH,phi_star,
     &			 harmoniaH,mu_star,lambda_star,per,bbeta)			!pmsar09.f

	do i=1,m
 745	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 745
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 915
				end if
			end do
 915		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta(i,j)
		end do
		do i=1,m
		bbeta(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	do i=1,m
	line(i)=mu_star(i)
	end do
	do i=1,m
	mu_star(i)=line(perm(i))
	end do
	
	do i=1,m
	line(i)=lambda_star(i)
	end do
	do i=1,m
	lambda_star(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi_star(i,j)
		end do
		do i=1,m
		phi_star(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta_star(i,j)
		end do
		do i=1,m
		bbeta_star(i,j)=line(perm(i))
		end do
	end do
	
	call miss (m,n,x,y,mu_star,lambda_star,p,
     &	   	   phi_star,per,perH,y_ran,y_new)						!pmsar10.f	
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta_star(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	do j=1,2*armH
		mu_bbeta(j)=prior_bbeta(1)
		do jj=1,2*armH 
			if (j.eq.jj) then
			lambda_bbeta(j,jj)=prior_bbeta(2)
			else
			lambda_bbeta(j,jj)=0
			end if
		end do
	end do
	
	do j=1,2*armH
		mu_lambda_bbeta(j)=0
		do jj=1,2*armH 
		mu_lambda_bbeta(j)=mu_lambda_bbeta(j)+
     &	lambda_bbeta(j,jj)*mu_bbeta(jj)
		end do
	end do
	
	do i=1,m	!*****
	
	do tt=1,n
		if (x(tt).eq.i) then
		la_gorda(tt)=1
		else
		la_gorda(tt)=0
		end if
	end do
	
	do tt=1,n
		do j=1,2*armH
		Hhainomrah(j,tt)=harmoniaH(tt,j)*lambda_star(i)*la_gorda(tt)	
		end do
	end do
	
	do j=1,2*armH
		do jj=1,2*armH
		precision_bbeta(j,jj)=lambda_bbeta(j,jj)
		end do
	end do
	
	do j=1,2*armH
		do jj=1,2*armH
			summ=0
			do tt=p+1,n
			summ=summ+Hhainomrah(j,tt)*harmoniaH(tt,jj)
			end do
		precision_bbeta(j,jj)=precision_bbeta(j,jj)+summ
		end do
	end do
	
	call dlinrg(2*armH,precision_bbeta,22,covariance_bbeta,22)
	
	do d=1,n/24
		do h= 1,24
			if ((d-1)*24+h.gt.p) then
				summ=0
				if (p.gt.0) then
					do j=1,p
					summ=summ+y_new((d-1)*24+h-j)*phi_star(i,j)
					end do
				hurricane((d-1)*24+h)=(y_new((d-1)*24+h)-mu_star(i)-
     &			summ-per((d-1)*24+h))*la_gorda((d-1)*24+h)
				end if
			end if
		end do
	end do					
	
	do j=1,2*armH
		summ=mu_lambda_bbeta(j)
		do tt=p+1,n
		summ=summ+Hhainomrah(j,tt)*hurricane(tt)
		end do
		cyclone(j)=summ
	end do	
	
	do j=1,2*armH
	summ=0
		do jj=1,2*armH
		summ=summ+covariance_bbeta(j,jj)*cyclone(jj)
		end do
	mean_bbeta(j)=summ
	end do
	
	do j=1,2*armH
	tropical_storm(j)=bbeta_star(i,j)-mean_bbeta(j)
	end do
	
	do j=1,2*armH
	summ=0
		do jj=1,2*armH
		summ=summ+tropical_storm(jj)*precision_bbeta(jj,j)
		end do
	tornado(j)=summ
	end do
	
	summ=0
	do j=1,2*armH
	summ=summ+tornado(j)*tropical_storm(j)
	end do
	

	call dlfcrg (2*armH,covariance_bbeta,22,
     &			fac_bbeta,22,ipvt_bbeta,rcondd)
		
	call dlfdrg (2*armH,fac_bbeta,22,ipvt_bbeta,det1,det2)
	
	dett=det1*(10**det2)

	full(i)=-armH*dlog(2*pi)-(dlog(dett))/2-summ/2
	
	end do	!*****

	summ=0
	do i=1,m
	summ=summ+full(i)
	end do
	
	full_mean=(full_mean*(iteration-1)+dexp(summ))/iteration
	
	end do !do iteration=1,sample (extra-gibbs_5)
	
	ln_margy=ln_margy-dlog(full_mean)

	write (10000,*) "full_mean",full_mean
	write (10000,*) "ln_margy",ln_margy
	
	!EXTRA-GIBBS_6
	
	if (m.gt.1) then
	
	write (10000,*),"extra_6"
	
	do iteration=1,sample/5
	
	write (*,*) "extra_6",iteration
		
	call pdf (y_new,m,n,pi,mu_star,lambda_star,
     &		  p,phi_star,per,perH,ln_pdf)							!pmsar01.f
	
	call csi1_2 (m,n,gmm,ln_pdf,csi1,csi2)							!pmsar02.f
	
	call csi_3 (m,n,gmm,csi2,csi3,z)								!pmsar03.f
	
	do d=1,n/24
		do h=1,24
		x((d-1)*24+h)=z(d)
		end do
	end do
	
	call transition (m,n,prior_gmm,states_couples,z,gmm)			!pmsar04.f
	
	do i=1,m
 746	continue
	call rnund(1,m,c)
	perm(i)=c
		if(i.gt.1)then
			do j=1,i-1
				if(perm(i).eq.perm(i-j)) then
				go to 746
				end if
			end do
		end if
	end do	 
		
	do d=1,n/24
		do h=1,24
			do i=1,m
				if(x((d-1)*24+h).eq.i) then
				x((d-1)*24+h)=perm(i)
				go to 916
				end if
			end do
 916		continue
		end do
	end do

	do i=1,m
		do j=1,m
		line(j)=gmm(i,j)
		end do
		do j=1,m
		gmm(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm(i,j)
		end do
		do i=1,m
		gmm(i,j)=line(perm(i))
		end do
	end do
		
	do i=1,m
	line(i)=mu_star(i)
	end do
	do i=1,m
	mu_star(i)=line(perm(i))
	end do
	
	do i=1,m
	line(i)=lambda_star(i)
	end do
	do i=1,m
	lambda_star(i)=line(perm(i))
	end do
	
	do j=1,p
		do i=1,m
		line(i)=phi_star(i,j)
		end do
		do i=1,m
		phi_star(i,j)=line(perm(i))
		end do
	end do
	
	do j=1,2*armH
		do i=1,m
		line(i)=bbeta_star(i,j)
		end do
		do i=1,m
		bbeta_star(i,j)=line(perm(i))
		end do
	end do
	
	do i=1,m
		do tt=1,n
		summ=0
			do j=1,2*armH
			summ=summ+bbeta_star(i,j)*harmoniaH(tt,j)	
			end do
		perH(tt,i)=summ
		end do
	end do
	
	do i=1,m
		do j=1,m
		line(j)=gmm_star(i,j)
		end do
		do j=1,m
		gmm_star(i,j)=line(perm(j))
		end do
	end do
	
	do j=1,m
		do i=1,m
		line(i)=gmm_star(i,j)
		end do
		do i=1,m
		gmm_star(i,j)=line(perm(i))
		end do
	end do
	
	call miss (m,n,x,y,mu_star,lambda_star,p,
     &	   	   phi_star,per,perH,y_ran,y_new)						!pmsar10.f
	
	do d=1,n/24
	ten(d)=z(d)*10+z(d+1)
	end do
	
	do i=1,m*m
		sumx=0
		do d=1,n/24
			if (ten(d).eq.states_couples(i)) then
			sumx=sumx+1
			end if
		end do
	counts_couples(i)=sumx
	end do
		
	black_owl=0
	
	do i=1,m
	
		summ=0
		do j=1,m
		summ=summ+counts_couples((i-1)*m+j)+prior_gmm((i-1)*m+j)
		end do
	
		jolly=DLNGAM(summ)
		
		do j=1,m
		summ=prior_gmm((i-1)*m+j)+counts_couples((i-1)*m+j)
		jolly=jolly-DLNGAM(summ)
		end do
	
		do j=1,m
		jolly=jolly+(prior_gmm((i-1)*m+j)+
     &	counts_couples((i-1)*m+j)-1)*dlog(gmm_star(i,j))
		end do
	
		black_owl=black_owl+jolly
		
	end do
	
	full_mean=(full_mean*(iteration-1)+dexp(black_owl))/iteration
	
	end do !do iteration=1,sample (extra-gibbs_6)
	
	ln_margy=ln_margy-dlog(full_mean)

	write (10000,*) "full_mean",full_mean
	write (10000,*) "ln_margy=",ln_margy
	
	end if	!if (m.gt.1)
	
	end do	!do p=0,2
	end do	!do m=1,4

	end !end of the code
