/* Compile using: gcc -o data_simul data_simul.c -lm  */

#include <time.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "sort2.c"
#include "nrutil.c" 
#include "ran1.c"
#include "weib_mean.c"
#include "indexx.c"
#include "my_sort3.c"
#include "sort.c"
#include "u_lib.h"

#define FREERETURN {free_dvector(inf_time,1,N);\
   free_dvector(rem_time,1,N); free_dvector(inf_period,1,N);\
   free_ivector(an_state,1,N); free_lvector(ord_index,1,N);\
   free_imatrix(test_an_state,1,N,1,no_of_tests);\
   free_ivector(test_I,1,no_of_tests);\
   free_ivector(test_S,1,no_of_tests);}


main()
{

 FILE *output, *test_matrix, *rem_times, *fopen();
 FILE *inf_times;
 long seed;
 unsigned long *ord_index;
 int i,j, k, N, I, S, n_inf, n_rem, *an_state, n_loops = 0;
 int next_event, inf_outp_index, rem_outp_index;
 int *test_I, *test_S, **test_an_state, no_of_tests, test_no;
 double t, next_t, T, *inf_time, *rem_time, *inf_period;
 double beta, nu, lambda, mean_inf_period=0.0, sd_inf_period;
 double ss_inf_period=0.0, sensit, specif, test_interval;
 double exponential_time, mean_exponential_time=0.0, mean_beta;
 double earliest_exponential_time, mean_exponential_time2=0.0;
 double sort_inf_time[1000];
 char test_result, state;

 /***** OPEN INPUT/OUTPUT FILES *****/

 if ( (output=fopen("sim_data.txt", "w"))==NULL ){
     printf("\n Cannot open output sim_data.txt file\n\n");
     exit(1);
 }
 if ( (inf_times=fopen("inf_times.txt", "w"))==NULL ){
     printf("\n Cannot open output inf_times.txt file\n\n");
     exit(1);
 } 
 if ( (rem_times=fopen("rem_times.txt", "w"))==NULL ){
     printf("\n Cannot open output rem_times.txt file\n\n");
     exit(1);
 }
 if ( (test_matrix=fopen("test_matrix.txt", "w"))==NULL ){
     printf("\n Cannot open output test_matrix.txt file\n\n");
     exit(1);
 }
 
 /***** ENTER PARAMETER VALUES *****/
 fprintf(stderr,"\nGive random number generator seed (negative long integer):\n");   
 scanf("%d",&seed);   
 /*seed = -time(NULL);*/            
 /*seed = -989849573; */
 fprintf(output,"\nSeed used in random generator: %ld\n\n", seed);
 fprintf(stderr,"Give population size (N):\n");
 scanf("%d",&N);
 fprintf(output,"Population size: %d\n", N); 
 fprintf(stderr,"Give length of observation period (T):\n");
 scanf("%lf",&T); 
 fprintf(output,"Observation period: %.3lf days\n", T);
 fprintf(stderr,"Give transmission coefficient (beta):\n");
 scanf("%lf",&beta); 
 fprintf(stderr,"Give shape parameter (nu) for Weibull:\n");
 scanf("%lf",&nu); 
 fprintf(stderr,"Give scale parameter (lambda) for Weibull:\n");
 scanf("%lf",&lambda); 
 fprintf(output,"Transmission (contact) coefficient (beta): %lf\n", beta);
 fprintf(output,"Weibull shape (nu) and scale (lambda): %lf  %lf\n", nu,lambda);
 fprintf(stderr,"Give sensitivity of tests:\n");
 scanf("%lf",&sensit); 
 fprintf(stderr,"Give specificity of tests:\n");
 scanf("%lf",&specif); 
 fprintf(output,"Test Sensitivity and Specificity are: %.3lf  %.3lf\n",sensit,specif); 
 fprintf(stderr,"Give time interval between tests (in days):\n");
 scanf("%lf",&test_interval); 
 fprintf(output,"Tests take place every %.3lf days\n",test_interval);
 fprintf(stderr,"\n\n");
 no_of_tests = T/test_interval;

 /***** ASSIGN MEMORY TO ARRAYS *****/
 inf_time = dvector(1,N);
 rem_time = dvector(1,N);
 inf_period = dvector(1,N);
 an_state = ivector(1,N);
 test_an_state = imatrix(1,N,1,no_of_tests);
 ord_index = lvector(1,N);
 test_I = ivector(1,no_of_tests);
 test_S = ivector(1,no_of_tests);

 t = 0.0; next_t = test_interval; n_inf = 1;  n_rem = 0;  test_no = 1;
 I = 1; S = N-1; /* No. of infectives nd susceptibles at time 0 */

 /* Initialise animal state: 
    an_state = 0  for not infected (susceptible)
               1  for removed
               2  for infected, not removed  */
 for (j=1;j<=N;j++){
   an_state[j] = 0;
   for (i=1;i<=no_of_tests;i++) test_an_state[j][i] = 0;
   /* Generate infectious periods: inf_period ~ Weibull (nu,lambda);  */
   inf_period[j] = -log(ran1(&seed))/nu;
   inf_period[j] = pow( (inf_period[j]/lambda),(1/nu) );
   mean_inf_period += inf_period[j]; /* This must be divided by N */
   ss_inf_period += inf_period[j]*inf_period[j];
   /* fprintf(parameters,"inf_period[%d]=%lf\n",j,inf_period[j]); */
 }
 sd_inf_period = sqrt((ss_inf_period-mean_inf_period*mean_inf_period/N)/(N-1));
 fprintf(output,"\nTrue Mean of infectious periods = %lf\n",weib_mean(nu,lambda));
 fprintf(output,"Mean of simulated infectious periods = %lf\n",mean_inf_period/N);
 fprintf(output,"Std.dev of simulated infectious periods= %lf\n\n",sd_inf_period);
 /* Consider animal 1 infected at time zero */
 an_state[1] = 2;
 inf_time[1] = t;
 rem_time[1] = t + inf_period[1];

 while (t < T){
   /* Generate infection times ~ exp(beta*I[t])
      Consider earliest event, output this event
      Calculate I[t], S[t] and start again  */
   if (t < (no_of_tests * test_interval)){
     next_event = 3;  /*if time is less than last test time, next event is test*/
     next_t = test_no * test_interval;
   }
   else{
     next_event = 0; /* no event takes place */
     next_t = T; /* if nothing happens, stop */
   }
   for (j=1;j<=N;j++){
      if (an_state[j] == 0 && I != 0) { /* If animal is susceptible
					   generate ifection time */
	exponential_time = -log(ran1(&seed))/(beta);
	inf_time[j] = t + exponential_time/I;
	rem_time[j] = inf_time[j] + inf_period[j];
	if (inf_time[j] < next_t){ /* Obtain min infection time */
	  next_t = inf_time[j];
	  next_event = 2; /* next event is infection */
          earliest_exponential_time = exponential_time;
          inf_outp_index = j; /* Keep track of animal to output */
	}
      }
      if (an_state[j] == 2){ /* If animal is infected
				obtain min removal time */
	if (rem_time[j] < next_t) {
	  next_t = rem_time[j];
	  next_event = 1; /* next event is removal */
	  rem_outp_index = j;
	}
      }
   }
   if (next_event == 2){
     /* If next event is infection change animal state,
	update I, S, n_inf */
     an_state[inf_outp_index] = 2;
     mean_exponential_time += earliest_exponential_time;
     I++; n_inf++;
     S--;
   }
   else if (next_event == 1){
     an_state[rem_outp_index] = 1;
     I--; n_rem++; 
   }
   else if (next_event == 3){
     for (j=1;j<=N;j++){
       if (an_state[j] == 0 && ran1(&seed)<(1-specif)){
	 test_an_state[j][test_no] = 2;
	 /* fprintf(output,"Wrong test result for uninfected j=%d at test:%d\n",*/
	 /*     	 j,test_no);*/
	 test_I[test_no]++;  test_S[test_no]--;
       }
       if (an_state[j] == 1 ){
	 test_an_state[j][test_no] = 1;
	 test_I[test_no]--;
       }
       if (an_state[j] == 2 ){
	 if (ran1(&seed)<(1-sensit)){
	   test_an_state[j][test_no] = 0;
	   /*fprintf(output,"Wrong test result for infected j=%d at test:%d\n",*/
	   /*	   j,test_no);*/
	   test_I[test_no]--;  test_S[test_no]++;
	 }
	 else{
	   test_an_state[j][test_no] = 2;
	   test_I[test_no]++;  test_S[test_no]--;
	 }
       }
     }
     if (test_no < no_of_tests) test_no++;
   }
   t = next_t;
   n_loops++;
   /*if (next_t != T) next_t = test_no * test_interval;*/
   /*fprintf(stderr,"At loop:%d  next_event=%d  t=%lf  next_t=%lf\n", */
   /*      n_loops,next_event,t,next_t); */
   /* fprintf(stderr,"\nloop:  %d\n", n_loops); */
   /* fprintf(stderr,"\nAn[j] State   Inf. time   Rem. time\n"); */
   /* for (j=1;j<=N;j++){ */
   /*   fprintf(stderr," %d      %d       %.3lf      %.3lf\n",  */
   /* 	   j,an_state[j],inf_time[j],rem_time[j]); */
   /* } */
 }

 /*fprintf(stderr,"no_of_tests=%d\n",no_of_tests);*/
 /*for (i=1;i<=no_of_tests;i++){*/
 /*    if (i==1) fprintf(output,"\nAn[j]");*/
 /*    fprintf(output,"  Test[%d]",i);*/
 /*}*/


 fprintf(stderr,"\n");
 fprintf(output,"\n");

 /* Sort output in ascending order of removal time
    and rearrange animal index, removal times and
    animal state. Output only infected cases      */
 fprintf(output,"\n\nSIMULATED INFECTION AND REMOVAL TIMES (in ascending order of removal time):\n");
 fprintf(output,"(Column 'State' indicates state of individual at the end of the observation period)\n");
 my_sort3(N,ord_index,rem_time,inf_time,an_state);
 fprintf(output,"\nIndividual[j] State   Inf. time   Rem. time\n");
 fprintf(test_matrix,"%d \n",no_of_tests);
 fprintf(test_matrix,"%lf  %lf\n",sensit,specif); 
 for (i=1;i<=no_of_tests;i++)  fprintf(test_matrix,"%lf  ", test_interval*i);
 fprintf(test_matrix,"\n");
 fprintf(inf_times,"%d\n",n_inf);
 fprintf(inf_times,"%lf %lf\n",T,floor(mean_inf_period/N));
 fprintf(rem_times,"%d\n",N);
 fprintf(rem_times,"%d\n",n_rem);

 for (j=1;j<=N;j++){
   if (an_state[j] == 1){
     state = 'r';
     fprintf(output," %11u %4c %12.3lf %11.3lf\n", 
	   ord_index[j],state,inf_time[j],rem_time[j]);
   }
   else if (an_state[j] == 2){
     state = '+';
     fprintf(output," %11u %4c %12.3lf %11.3lf   *NOT REMOVED AT TIME T*\n", 
	   ord_index[j],state,inf_time[j],rem_time[j]);
   }
   if (an_state[j] == 2 || an_state[j] == 1){
   for (i=1;i<=no_of_tests;i++)
      fprintf(test_matrix,"%3d",test_an_state[ord_index[j]][i]);
   fprintf(test_matrix,"\n");
   fprintf(rem_times,"%lf\n",rem_time[j]);
   /* fprintf(inf_times,"%lf  %d\n", */
   /*	   (inf_time[j]-floor(mean_inf_period/N)),an_state[j]); */
   fprintf(inf_times,"%lf  %d\n",inf_time[j],an_state[j]); 
   }
 }
 fprintf(output,"\n No. of infections: %d  No. of removals: %d\n",
	 n_inf,n_rem);
 fprintf(stderr,"\n No. of infections: %d  No. of removals: %d\n",
	 n_inf,n_rem);
 /* fprintf(output,"\n Observation time ends at T=%.3lf days\n", T); */
 fprintf(output," No. of infectives at time T: %d",I);
 if (I == 0) fprintf(output,"    ***EPIDEMIC COMPLETED***\n\n");
 else fprintf(output,"    ***EPIDEMIC STILL IN PROGRESS***\n\n");
 fprintf(stderr," No. of infectives at time T: %d",I);
 if (I == 0) fprintf(stderr,"    ***EPIDEMIC COMPLETED***\n\n");
 else fprintf(stderr,"    ***EPIDEMIC STILL IN PROGRESS***\n\n");

 /* fprintf(stderr,"\n No. of loops: %d\n", n_loops);  */

 fprintf(stderr,"\n");
 fprintf(output,"\n");

 fprintf(output,"\nTEST RESULTS ('r' denotes removal of individual):");

 for (j=1;j<=N;j++){
   fprintf(output,"\n\nIndividual[%d]:\n",j);
   for (i=1;i<=no_of_tests;i++){
     if (test_an_state[j][i]==0) test_result = '-';
     else if (test_an_state[j][i]==2) test_result = '+';
     else if (test_an_state[j][i]==1) test_result = 'r';
     /*if (i==1) fprintf(output,"\n%3d %7c",j,test_result);*/
     /*else fprintf(output,"%9c",test_result);*/
     /*if (i==1) fprintf(output,"\n%3d %7d",j,test_an_state[j][i]);*/
     /*else fprintf(output,"%9d",test_an_state[j][i]);*/
     if (i%12==1) fprintf(output,"\n%3d(%1c)",i,test_result);
     else fprintf(output,"%3d(%1c)",i,test_result);
   }
 }

 fprintf(stderr,"\n");
 fprintf(output,"\n");

 fclose(output); fclose(test_matrix);
 fclose(rem_times); fclose(inf_times);
 FREERETURN
 #undef FREERETURN
}


          
