/**********************************************************************/
/* Modified funtion. Simulates from a Gamma(a,1) density where a can  */
/* take any positive value                                            */
/**********************************************************************/

#include <math.h>
/*#include "gasdev.c"*/

double my_gamdev(double ia, long *idum)
{
	double ran1(long *idum);
	void nrerror(char error_text[]);
	int j;
	double am,e,s,v1,v2,x,y;

        if (ia < 0.0) nrerror("Gamma density not defined for a<0.0");
        /* if a=0.5 use Z**2/2 where Z is N(0,1) */
        if (ia == 0.5) x = pow(gasdev(idum),2)/2;
        /* if 0<a<1 use Johnk's generator (Devroye p.118) */
        else if (ia>0.0 && ia<1.0){
             do{
               v1 = pow(ran1(idum),(1/ia));
               v2 = pow(ran1(idum),(1/(1-ia)));
             }while(v1+v2 > 1);
             e = -log(ran1(idum));
             x = (e*v1)/(v1+v2);
        }
        /* if a>1 use Ahren's algorithm (modified from num. recipies) */
        else if (ia >= 1.0){                	
          if (ia==1.0 || ia==2.0 || ia==3.0 || ia==4.0 || ia==5.0 || ia==6.0) {
		   /*fprintf(stderr,"alpha is integer\n");*/
	    	   x=1.0;
		   for (j=1;j<=ia;j++) x *= ran1(idum);
		   x = -log(x);
	  } 
                   else {
		        do {
			   do {
				 do {
					 v1=ran1(idum);
				  	 v2=2.0*ran1(idum)-1.0;
			   	 } while (v1*v1+v2*v2 > 1.0);
				y=v2/v1;
				am=ia-1;
				s=sqrt(2.0*am+1.0);
				x=s*y+am;
			      }while (x <= 0.0);
			   e=(1.0+y*y)*exp(am*log(x/am)-s*y);
		           } while (ran1(idum) > e);
		   }
        }
	return x;
}
