#include <math.h>

double post_nu(double nu,int it,int nrem,double xi,int N_indiv,double **s,
	       double *r,double T,double lambda,double fi,int  **ir_ind)
{
  int i;
  double nusum_1=0.0,nusum_2=0.0,nuprod=1.0,post_nu;

  for (i=1;i<=N_indiv;i++){
    if (ir_ind[i][it] == 1){
      nusum_1 += pow((r[i]-s[i][it]),nu);
      nuprod *= pow((r[i]-s[i][it]),(nu-1));
    }
    else if (ir_ind[i][it] == 2){
      nusum_2 += pow((T-s[i][it]),nu);
    }  
  }

  post_nu = pow(nu,(nrem+xi-1)) * nuprod * 
    exp(-lambda*(nusum_1+ nusum_2)-fi*nu);

  return post_nu;
}



/*double log_post_nu(double nu,int it,int nrem,double xi,int N_indiv, */
/*   double **s,double *r,double T,double lambda,double fi,int **ir_ind) */
double neglog_post_nu(double nu)
{
  extern double xi,**s,*r,T,*lambda,fi;
  extern int  it,nrem,N_indiv,**ir_ind;

  int i;
  double nusum_1=0.0,nusum_2=0.0,logsum=0.0,log_post_nu;

  for (i=1;i<=N_indiv;i++){
    if (ir_ind[i][it] == 1){
      logsum += log(r[i]-s[i][it]);
      nusum_1 += pow((r[i]-s[i][it]),nu);
    }
    else if (ir_ind[i][it] == 2){
      nusum_2 += pow((T-s[i][it]),nu);
    }  
  }
 
  log_post_nu = (nrem+xi-1) * log(nu) + (nu-1) * logsum -
    lambda[it] * (nusum_1+ nusum_2) - fi*nu;

  return(-log_post_nu);
}


double secderiv_logpost_nu(double nu,int it,int nrem,double xi,int N_indiv,
     double **s,double *r,double T,double lambda,double fi,int **ir_ind)
{
  int i;
  double sum_1=0.0,sum_2=0.0,secderiv;

  for (i=1;i<=N_indiv;i++){
    if (ir_ind[i][it] == 1){
      sum_1 += log(r[i]-s[i][it])*log(r[i]-s[i][it])*pow((r[i]-s[i][it]),nu);
    }
    else if (ir_ind[i][it] == 2){
      sum_2 += log(T-s[i][it])*log(T-s[i][it])*pow((T-s[i][it]),nu);
    }  
  }

  secderiv = -(nrem+xi-1)/(nu*nu) - lambda*(sum_1+sum_2);

  return secderiv;
}

