/******************************************************************/
/* The function puts simulated values in a file (sample.out:      */
/* index and single value per row) and creates the indicator file */
/* "sample.ind" as required for the analysis by CODA software.    */
/* INPUT: The no. of MC simulations "NSIM", the values for the    */
/* chain burn-in and thinning and the arrays of the simulated     */
/* values "beta", "nu" and "lambda".                              */
/******************************************************************/


#include<stdio.h>
#include<math.h>
#include<stdlib.h>

/*#define THINNING 10*/
/*#define BURN_IN 10000*/

void sample(long NSIM,int THINNING,int BURN_IN,double *beta,double *nu,
         double *lambda)
{
  FILE *sample_ind,*sample_out,*outf,*fopen();
  int it,t, eff_N;

  if ( (sample_ind=fopen("sample.ind", "w"))==NULL ){
      printf("\n Cannot open output sample.ind\n\n");
      exit(1);
  }
  if ( (sample_out=fopen("sample.out", "w"))==NULL ){
      printf("\n Cannot open output sample.out\n\n");
      exit(1);
  }
  if ( (outf=fopen("monit_mean", "w"))==NULL ){
      printf("\n Cannot open output monit_mean\n\n");
      exit(1);
  }

  eff_N = (NSIM-BURN_IN)/THINNING;
  if ( ((NSIM-BURN_IN)-eff_N*THINNING) != 0) eff_N++;
  t = 1;
  for (it=BURN_IN+1;it<=NSIM;it+=THINNING){
      fprintf(sample_out,"%6d %.15lf\n",t,beta[it]);
      t++;
      /*printf("it=%d\n",it);*/
  }
  t = 1;
  for (it=BURN_IN+1;it<=NSIM;it+=THINNING){
      fprintf(sample_out,"%6d %.15lf\n",t,nu[it]);
      t++;
  }
  t = 1;
  for (it=BURN_IN+1;it<=NSIM;it+=THINNING){
      fprintf(sample_out,"%6d %.15lf\n",t,lambda[it]);
      t++;
  }
  fprintf(sample_ind,"beta  %6d  %6d\n",1,eff_N);
  fprintf(sample_ind,"nu  %6d  %6d\n",(eff_N+1),(2*eff_N) );
  fprintf(sample_ind,"lambda  %6d  %6d\n",(2*eff_N+1),(3*eff_N) );

  fclose(sample_ind);
  fclose(sample_out);
  fclose(outf);
}
