/******************************************************************/
/* The function puts simulated values in a file (sample_2.out:    */
/* index and single value per row) and creates the indicator file */
/* "sample_2.ind" as required for the analysis by CODA software.  */
/* INPUT: The no. of MC simulations "NSIM", the values for the    */
/* chain burn-in and thinning and the arrays of the simulated     */
/* values "beta", "nu" and "lambda".                              */
/******************************************************************/

/* This modification returns the simulated values for beta and the 
   mean (mu) and standard deviation (sigma) of the Weibull distribution 
   as functions of nu and lambda */

#include<stdio.h>
#include<math.h>
#include<stdlib.h>

#include "gammln.c"
/*#define THINNING 10*/
/*#define BURN_IN 10000*/

void sample_2(long NSIM,int THINNING,int BURN_IN,double *beta,double *nu,
         double *lambda)
{
  FILE *sample_ind,*sample_out,*outf,*fopen();
  int it,t, eff_N;
  double gamma1, gamma2,*mean,var,*sd;

  if ( (sample_ind=fopen("sample_2.ind", "w"))==NULL ){
      printf("\n Cannot open output sample_2.ind\n\n");
      exit(1);
  }
  if ( (sample_out=fopen("sample_2.out", "w"))==NULL ){
      printf("\n Cannot open output sample_2.out\n\n");
      exit(1);
  }
  if ( (outf=fopen("monit_mean_2", "w"))==NULL ){
      printf("\n Cannot open output monit_mean_2\n\n");
      exit(1);
  }

  mean = dvector(1,NSIM);
  sd = dvector(1,NSIM);
 
  for (it=1;it<=NSIM;it++){
      gamma1 = exp(gammln(1+1/nu[it]));
      gamma2 = exp(gammln(1+2/nu[it]));
      mean[it] = pow(lambda[it],(-1/nu[it])) * gamma1;
      var = pow(lambda[it],(-2/nu[it])) * (gamma2-(gamma1*gamma1));
      sd[it] = sqrt(var); 
  }

  eff_N = (NSIM-BURN_IN)/THINNING;
  if ( ((NSIM-BURN_IN)-eff_N*THINNING) != 0) eff_N++;
  t = 1;
  for (it=BURN_IN+1;it<=NSIM;it+=THINNING){
      fprintf(sample_out,"%6d %.15lf\n",t,beta[it]);
      t++;
      /*printf("it=%d\n",it);*/
  }
  t = 1;
  for (it=BURN_IN+1;it<=NSIM;it+=THINNING){
      fprintf(sample_out,"%6d %.15lf\n",t,mean[it]);
      t++;
  }
  t = 1;
  for (it=BURN_IN+1;it<=NSIM;it+=THINNING){
      fprintf(sample_out,"%6d %.15lf\n",t,sd[it]);
      t++;
  }
  fprintf(sample_ind,"beta  %6d  %6d\n",1,eff_N);
  fprintf(sample_ind,"mean  %6d  %6d\n",(eff_N+1),(2*eff_N) );
  fprintf(sample_ind,"sd  %6d  %6d\n",(2*eff_N+1),(3*eff_N) );

  free(mean); free(sd);  

  fclose(sample_ind);
  fclose(sample_out);
  fclose(outf);
}
