/* Compile using:    gcc -o sir_mcmc sir_mcmc.c -lm    */


#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>

#include "nrutil.c" 
#include "ran1.c"
#include "gasdev.c" 
#include "my_gamdev.c"
#include "gamdev.c"
#include "sort2.c"
#include "sw_likel.c"
#include "sw_SI_count.c"
#include "mnbrak.c"
#include "golden.c"
#include "post_nu.c"
#include "sample.c"
#include "sample_2.c"
#include "sw_test_adjust.c"
#include "hist_heights.c"
#include "u_lib.h"


#define MAXNAME 40
#define tol  1.0E-8
#define INFINITE_INF 1.0E+7
#define FREERETURN {free_dmatrix(s,1,N_indiv,0,NSIM);\
     free_dvector(r,1,N_indiv);\
     free_dvector(beta,0,NSIM); free_dvector(nu,0,NSIM);\
     free_dvector(lambda,0,NSIM); free_dvector(times,1,nevents);\
     free_dvector(times_ir_ind,1,nevents);free_ivector(S,1,nevents);\
     free_ivector(I,1,nevents); free_ivector(N,1,nevents);\
     free_imatrix(ir_ind,1,N_indiv,0,NSIM);free_ivector(ninf,0,NSIM);\
     free_ivector(n_rem_inf,0,NSIM);\
     free_dmatrix(s_tmp,1,N_indiv,0,N_s_updates);\
     free_imatrix(ir_ind_tmp,1,N_indiv,0,N_s_updates);\
     free_ivector(ninf_tmp,0,N_s_updates);\
     free_ivector(n_rem_inf_tmp,0,N_s_updates);\
     free_dvector(test_time,1,no_of_tests);\
     free_imatrix(test_result,1,N_indiv,1,no_of_tests);\
     free_dvector(test_adjust_k_old,1,N_indiv);\
     free_ivector(tests_in_use,1,no_of_tests);\
     free_dvector(all_test_time,1,no_of_all_tests);\
     free_imatrix(all_test_result,1,N_indiv,1,no_of_all_tests);}    

double xi,**s,*r,T,*lambda,fi;
int  it,nrem,N_indiv;
int  **ir_ind;

main()
{
 FILE *in_data, *in_start, *in_start_param, *in_test, *in_prior_param;
 FILE *out_heights, *fopen();
 int i, j,jmin=1,*N, *ninf, rint, nevents, *n_rem_inf, *S, *I;
 int *ninf_tmp, *n_rem_inf_tmp;
 int k,k2,old_it,ninf_start,N_total;
 int THINNING, BURN_IN, it_s, N_s_updates;
 int no_of_tests;
 int no_of_all_tests, *tests_in_use;
 int first_test=1, last_test, test_in_use_index=1, test_thinning=1;
 int n_bins, *beta_heights,*lambda_heights,*nu_heights;
 int **all_test_result,**test_result;
 int **ir_ind_tmp;
 long NSIM, seed;
 double  *beta, *nu, temp_inf;
 double unif1, a, b, c, d;
 double *times,*times_ir_ind,lik_new,lik_old,postbsum,postbsum_new,acc_prob;
 double s_accept_count=0.0,s_accept_rate,postb_shape,postb_scale;
 double postlsum_1,postlsum_1_new,postlsum_2,postlsum_2_new;
 double postnuprod,postnuprod_new,postl_shape,postl_scale;
 double ax,bx,cx,fa,fb,fc,xnu_mode;
 double postvar_nu, ratio_prop_nu,prop_shape,prop_scale,prop_mu,prop_sig2; 
 double nu_accept_count=0.0,**s_tmp,r_tmp,start_time;
 double *test_time, sensit, specif;
 double test_adjust_new, test_adjust_old=1.0, test_adjust_k_new, *test_adjust_k_old;
 double inf_lb, *all_test_time;
 double beta_min, beta_max, lambda_min, lambda_max, nu_min, nu_max; 
 char prop_choice='g',model='w',start_file[MAXNAME]="inf_times.txt";
 char data_file[MAXNAME]="rem_times.txt", inf_no_known='n';
 /* char test_file[MAXNAME]="test_matrix85.txt";*/
 char test_file[MAXNAME], prior_file[MAXNAME]="prior_parameters.txt";
 char start_param_file[MAXNAME]="param_start_values.txt";
 char use_histograms='n';


 
 /******* GIVE PARAMETER VALUES ***********************************/
 seed = -time(NULL); 
 /*seed = -991937456;*/
 /*fprintf(stderr,"Give seed\n");  */
 /*scanf("%d",&seed);  */
 fprintf(stderr,"\nseed=%d\n",seed);
 fprintf(stderr,"\n\n");
 /*fprintf(stderr,"Give data (removals) filename:\n");*/
 /*scanf("%s",data_file);*/
 /*fprintf(stderr,"Give starting values filename:\n");*/
 /*scanf("%s",start_file);*/
 fprintf(stderr,"Give test matrix filename:\n");
 scanf("%s",test_file);
 /*fprintf(stderr,"Give prior parameters filename:\n");*/
 /*scanf("%s",prior_file);*/
 /*fprintf(stderr,"Exponential (e) or Weibull (w) model?\n");*/
 /*fflush(stdin);*/
 /*model = getchar();*/
 if (model == 'w'){
   ax = 0.1;
   bx = 0.9;
   /*fprintf(stderr,"Normal (n), Gamma (g) or LN (l) proposal for nu?\n");*/
   /*fflush(stdin);*/
   /*prop_choice = getchar();*/
 }
 else xi=fi=0.1;
 fprintf(stderr,"Give no. of MCMC iterations:\n");
 scanf("%d",&NSIM);
 fprintf(stderr,
 "Give no. of infection updates per cycle: (enter zero for 'known' infection times)\n");  
 scanf("%d",&N_s_updates);
 fprintf(stderr,"How many iterations for MCMC BURN_IN? (MUST BE >= 2)\n");
 scanf("%d",&BURN_IN);
 fprintf(stderr,"How many iterations for MCMC sample THINNING?\n");
 scanf("%d",&THINNING);
 if (use_histograms == 'y'){
   fprintf(stderr,"Give number of bins for histograms:\n");
   scanf("%d",&n_bins);
 }
 else n_bins = 20;
 if (N_s_updates == 0) no_of_tests=0;
 else{
   fprintf(stderr,
   "Give number of tests to be used: (must be <= no. of tests given in input file test_matrix.txt)\n");
   scanf("%d",&no_of_tests);
 }


 /* OPEN INPUT/OUTPUT FILES */
 if ( (in_data=fopen(data_file, "r"))==NULL ){
     printf("\n Cannot open input file: rem_times.txt\n\n");
     exit(1);
 }
 if ( (in_test=fopen(test_file, "r"))==NULL ){
     printf("\n Cannot open input file: test_matrix.txt\n\n");
     exit(1);
 }
 if ( (in_prior_param=fopen(prior_file, "r"))==NULL ){
     printf("\n Cannot open input file: prior_parameters.txt\n\n");
     exit(1);
 }
 if ( (in_start=fopen(start_file, "r"))==NULL ){
     printf("\n Cannot open input file:  infection_times.txt\n\n");
     exit(1);
 }
 if ( (in_start_param=fopen(start_param_file, "r"))==NULL ){
     printf("\n Cannot open input file: param_start_values.txt\n\n");
     exit(1);
 }


 /* READ SOME PARAMETER VALUES FROM FILE */
 fscanf(in_data,"%d\n", &N_total); 
 fscanf(in_data,"%d\n", &nrem); 
 fscanf(in_start,"%d\n", &N_indiv);
 nevents = 2*N_indiv+1;
 fscanf(in_start,"%lf %lf\n", &T,&inf_lb);
 fscanf(in_test,"%d\n", &no_of_all_tests); 


 /******* ASSIGN MEMORY TO ARRAYS **********************************/
 s = dmatrix(1,N_indiv,0,NSIM);
 ir_ind = imatrix(1,N_indiv,0,NSIM);
 /*ir_ind = malloc((N_indiv+1)*sizeof(int *)); 
 s = malloc((N_indiv+1)*sizeof(double *)); 
 for (i=1; i <= N_indiv; i++) {
   s[i] = malloc((NSIM+1)*sizeof(double));
   ir_ind[i] = malloc((NSIM+1)*sizeof(int)); 
 }*/
 r = dvector(1,N_indiv);
 beta = dvector(0,NSIM);
 nu = dvector(0,NSIM); 
 lambda = dvector(0,NSIM);
 /*beta = malloc((NSIM+1)*sizeof(double));
  nu = malloc((NSIM+1)*sizeof(double));
  lambda = malloc((NSIM+1)*sizeof(double));*/
 times = dvector(1,nevents);
 times_ir_ind = dvector(1,nevents);
 S = ivector(1,nevents);
 I = ivector(1,nevents);
 N = ivector(1,nevents);
 ninf = ivector(0,NSIM);
 n_rem_inf = ivector(0,NSIM);
 /*ninf = malloc((NSIM+1)*sizeof(int));
  n_rem_inf = malloc((NSIM+1)*sizeof(int));*/
 s_tmp = dmatrix(1,N_indiv,0,N_s_updates);
 ir_ind_tmp = imatrix(1,N_indiv,0,N_s_updates);
 ninf_tmp = ivector(0,N_s_updates);
 n_rem_inf_tmp = ivector(0,N_s_updates);
 test_time = dvector(1,no_of_tests);
 test_result = imatrix(1,N_indiv,1,no_of_tests);
 test_adjust_k_old = dvector(1,N_indiv);
 tests_in_use = ivector(1,no_of_tests);
 all_test_time = dvector(1,no_of_all_tests);
 all_test_result = imatrix(1,N_indiv,1,no_of_all_tests);
 beta_heights = ivector(1,n_bins);
 nu_heights = ivector(1,n_bins);
 lambda_heights = ivector(1,n_bins);


 /******* READ REMOVAL DATA ****************************************/
 for (j=1;j<=N_indiv;j++) fscanf(in_data,"%lf\n", &r[j]); 
     
 /******* READ TEST DATA *******************************************/
 fscanf(in_test,"%lf %lf\n", &sensit, &specif); 
 for (i=1;i<=no_of_all_tests;i++) fscanf(in_test,"%lf", &all_test_time[i]);
 for (j=1;j<=N_indiv;j++){
   for (i=1;i<=no_of_all_tests;i++){
     fscanf(in_test,"%d", &all_test_result[j][i]);
   }
 }

 if (no_of_tests != no_of_all_tests && no_of_tests != 0){
   fprintf(stderr,"Give days between successive tests (enter 999 for all tests specified next):\n");
   scanf("%d", &test_thinning);
   if (test_thinning != 999){
     for (i=1;i<=no_of_all_tests;i+=test_thinning){
       tests_in_use[test_in_use_index] = i;
       test_in_use_index++;
     }
   }
   else{
     while (test_in_use_index <= no_of_tests) {
       fprintf(stderr,"Give range of tests to be used (separated by space or enter):\n");
       scanf("%d %d",&first_test,&last_test);
       for (i=first_test;i<=last_test;i++){
	 tests_in_use[test_in_use_index] = i;
	 test_in_use_index++;
       }
     }
   }
   for (i=1;i<=no_of_tests;i++){
      test_time[i] = all_test_time[tests_in_use[i]];
   }
   for (j=1;j<=N_indiv;j++){
     for (i=1;i<=no_of_tests;i++)
       test_result[j][i] = all_test_result[j][tests_in_use[i]];
   }
 }
 else{
   for (i=1;i<=no_of_tests;i++)  test_time[i] = all_test_time[i];
   for (j=1;j<=N_indiv;j++){
     for (i=1;i<=no_of_tests;i++) test_result[j][i] = all_test_result[j][i];
   }
 }
 fprintf(stderr,"\n");  


 /* READ PRIOR PARAMETER VALUES FROM FILE prior_parameters.txt */
 fscanf(in_prior_param,"%lf %lf %lf %lf %lf %lf", &a,&b,&xi,&fi,&c,&d);


 /******* MCMC STARTING VALUES *************************************/
 for (j=1;j<=N_indiv;j++){
     fscanf(in_start,"%lf  %d\n", &s_tmp[j][0],&ir_ind_tmp[j][0]);
     test_adjust_k_old[j] = sw_test_adjust(no_of_tests,test_time,sensit,specif,
				       test_result[j],s_tmp[j][0]);
 }
 /*fprintf(stderr,"\n\nStarting test_adjust_old = %e\n\n",test_adjust_old);*/
 /* start_time = 0.0;  /* ALWAYS make sure that first infection takes place at t=0 */
 start_time = 0.0 - inf_lb;
 fscanf(in_start_param,"%lf %lf %lf", &beta[0],&nu[0],&lambda[0]);
 ninf_start = N_indiv;
 ninf_tmp[0] = ninf_start;
 n_rem_inf_tmp[0] = nrem + ninf_tmp[0] ;
 S[1] = N_total;
 I[1] = 0;
 sw_SI_count(0,ir_ind_tmp,ninf_tmp,n_rem_inf_tmp,s_tmp,N_indiv,times,times_ir_ind,S,I,r);
 lik_old = sw_likel(0,N_indiv,ir_ind_tmp,beta[0],S,I,
     times_ir_ind,n_rem_inf_tmp,times,nu[0],lambda[0],s_tmp,r,T,&postbsum,&postlsum_1,
		    &postlsum_2,&postnuprod);
 postbsum_new = postbsum;
 postlsum_1_new = postlsum_1;
 postlsum_2_new = postlsum_2;
 postnuprod_new = postnuprod;


 /******************* MCMC ITERATION *******************************/
 for (it=1;it<=NSIM;it++){ 

  /*********  UPDATE INFECTION TIMES  ***********/
  for (it_s=1;it_s<=N_s_updates;it_s++){ 
   sw_SI_count(it_s-1,ir_ind_tmp,ninf_tmp,n_rem_inf_tmp,s_tmp,N_indiv,
               times,times_ir_ind,S,I,r);
   lik_old = sw_likel(it_s-1,N_indiv,ir_ind_tmp,beta[it-1],S,I,
	   times_ir_ind,n_rem_inf_tmp,times,nu[it-1],lambda[it-1],s_tmp,r,T,
	   &postbsum,&postlsum_1,&postlsum_2,&postnuprod);	
   postbsum_new = postbsum;
   postlsum_1_new = postlsum_1;
   postlsum_2_new = postlsum_2;
   postnuprod_new = postnuprod;
   
   k = (ceil(ran1(&seed) * N_indiv)); 
   if (ir_ind_tmp[k][it_s-1] == 0){  /* Not infected */
     /*printf("ADD\n");*/
     s_tmp[k][it_s] = start_time + (T-start_time)*ran1(&seed);
     ir_ind_tmp[k][it_s] = 2; /* Infected, not removed */
     for (j=1;j<=N_indiv;j++){
       if (j !=k) {
	 s_tmp[j][it_s]=s_tmp[j][it_s-1];
	 ir_ind_tmp[j][it_s] = ir_ind_tmp[j][it_s-1];
       }
     }
     ninf_tmp[it_s] = ninf_tmp[it_s-1]+1;
     n_rem_inf_tmp[it_s] = n_rem_inf_tmp[it_s-1]+1;
     sw_SI_count(it_s,ir_ind_tmp,ninf_tmp,n_rem_inf_tmp,s_tmp,N_indiv,times,
                 times_ir_ind,S,I,r);
     lik_new = sw_likel(it_s,N_indiv,ir_ind_tmp,beta[it-1],S,I,
	   times_ir_ind,n_rem_inf_tmp,times,nu[it-1],lambda[it-1],s_tmp,r,T,
			&postbsum,&postlsum_1,&postlsum_2,&postnuprod);
     test_adjust_k_new = sw_test_adjust(no_of_tests,test_time,
			 sensit,specif,test_result[k],s_tmp[k][it_s]);	
     test_adjust_new =  test_adjust_k_new/test_adjust_k_old[k];
     lik_new *= test_adjust_new;
     acc_prob = (lik_new/lik_old)*((T-start_time)/2);
     if (ran1(&seed) <= acc_prob) {
       /*printf("ACCEPT\n");*/
       postbsum_new = postbsum;
       postlsum_1_new = postlsum_1;
       postlsum_2_new = postlsum_2;
       postnuprod_new = postnuprod;
       test_adjust_k_old[k] = test_adjust_k_new;
       test_adjust_old =  test_adjust_new;
       s_accept_count++;
     }
     else{
       /*printf("DO NOT ACCEPT\n");*/
       s_tmp[k][it_s] = s_tmp[k][it_s-1];
       ir_ind_tmp[k][it_s] = ir_ind_tmp[k][it_s-1];
       ninf_tmp[it_s] = ninf_tmp[it_s-1];
       n_rem_inf_tmp[it_s] = n_rem_inf_tmp[it_s-1];
     }

   }
   else if (ir_ind_tmp[k][it_s-1] == 1){  /* Removed */
      /*printf("MOVE\n");*/
      s_tmp[k][it_s] = start_time + (r[k]-start_time)*ran1(&seed);
      for (j=1;j<=N_indiv;j++){
	if (j !=k) s_tmp[j][it_s]=s_tmp[j][it_s-1];
	ir_ind_tmp[j][it_s] = ir_ind_tmp[j][it_s-1];	
      }
      ninf_tmp[it_s] = ninf_tmp[it_s-1];
      n_rem_inf_tmp[it_s] = n_rem_inf_tmp[it_s-1];
      sw_SI_count(it_s,ir_ind_tmp,ninf_tmp,n_rem_inf_tmp,s_tmp,N_indiv,
                  times,times_ir_ind,S,I,r);
      lik_new = sw_likel(it_s,N_indiv,ir_ind_tmp,beta[it-1],S,I,
	   times_ir_ind,n_rem_inf_tmp,times,nu[it-1],lambda[it-1],s_tmp,r,T,
			 &postbsum,&postlsum_1,&postlsum_2,&postnuprod);
      test_adjust_k_new = sw_test_adjust(no_of_tests,test_time,
			 sensit,specif,test_result[k],s_tmp[k][it_s]);	
      test_adjust_new =  test_adjust_k_new/test_adjust_k_old[k];
      lik_new *= test_adjust_new;
      acc_prob =(lik_new/lik_old);
      if (ran1(&seed) <= acc_prob) {
	/*printf("ACCEPT\n");*/
	postbsum_new = postbsum;
	postlsum_1_new = postlsum_1;
	postlsum_2_new = postlsum_2;
	postnuprod_new = postnuprod;
        test_adjust_k_old[k] = test_adjust_k_new;
        test_adjust_old =  test_adjust_new;
	s_accept_count++;
      }
      else{
	/*printf("DO NOT ACCEPT\n");*/
	s_tmp[k][it_s] = s_tmp[k][it_s-1];
      }

   }
   else {  /* Infected-NOT-removed */
     if ((inf_no_known =='n') && (ran1(&seed) <= 0.5)){ 
       /*printf("REMOVE\n");*/
       s_tmp[k][it_s] = INFINITE_INF;
       ir_ind_tmp[k][it_s] = 0; /* Not Infected */
       for (j=1;j<=N_indiv;j++){
	 if (j !=k) {
	   s_tmp[j][it_s]=s_tmp[j][it_s-1];
	   ir_ind_tmp[j][it_s] = ir_ind_tmp[j][it_s-1];
	 }
       }
       ninf_tmp[it_s] = ninf_tmp[it_s-1]-1;
       n_rem_inf_tmp[it_s] = n_rem_inf_tmp[it_s-1]-1;
       sw_SI_count(it_s,ir_ind_tmp,ninf_tmp,n_rem_inf_tmp,s_tmp,N_indiv,times,
                   times_ir_ind,S,I,r);
       lik_new = sw_likel(it_s,N_indiv,ir_ind_tmp,beta[it-1],S,I,
	   times_ir_ind,n_rem_inf_tmp,times,nu[it-1],lambda[it-1],s_tmp,r,T,
			  &postbsum,&postlsum_1,&postlsum_2,&postnuprod); 
       test_adjust_k_new = sw_test_adjust(no_of_tests,test_time,
			 sensit,specif,test_result[k],s_tmp[k][it_s]);
       test_adjust_new =  test_adjust_k_new/test_adjust_k_old[k];
       lik_new *= test_adjust_new;
       acc_prob = (lik_new/lik_old)*(1/(2*(T-start_time)));
       if (ran1(&seed) <= acc_prob) {
	 /*printf("ACCEPT\n");*/
	 postbsum_new = postbsum;
	 postlsum_1_new = postlsum_1;
	 postlsum_2_new = postlsum_2;
	 postnuprod_new = postnuprod;
         test_adjust_k_old[k] = test_adjust_k_new;
         test_adjust_old =  test_adjust_new;
	 s_accept_count++;
       }
       else{
	 /*printf("DO NOT ACCEPT\n");*/
	 s_tmp[k][it_s] = s_tmp[k][it_s-1];
	 ir_ind_tmp[k][it_s] = ir_ind_tmp[k][it_s-1];
	 ninf_tmp[it_s] = ninf_tmp[it_s-1];
	 n_rem_inf_tmp[it_s] = n_rem_inf_tmp[it_s-1];
       }
     }
     else{ 
       /*printf("MOVE\n");*/
       /*if (inf_no_known == 'y') s[k][it] = s[1][0] + (r[k]-s[1][0])*ran1(&seed);*/
       /*else */
       s_tmp[k][it_s] = start_time + (T-start_time)*ran1(&seed);
       for (j=1;j<=N_indiv;j++){
	 if (j !=k) s_tmp[j][it_s]=s_tmp[j][it_s-1];
	 ir_ind_tmp[j][it_s] = ir_ind_tmp[j][it_s-1];	
       }
       ninf_tmp[it_s] = ninf_tmp[it_s-1];
       n_rem_inf_tmp[it_s] = n_rem_inf_tmp[it_s-1];
       sw_SI_count(it_s,ir_ind_tmp,ninf_tmp,n_rem_inf_tmp,s_tmp,N_indiv,times,
                   times_ir_ind,S,I,r);
       lik_new = sw_likel(it_s,N_indiv,ir_ind_tmp,beta[it-1],S,I,
	   times_ir_ind,n_rem_inf_tmp,times,nu[it-1],lambda[it-1],s_tmp,r,T,
			  &postbsum,&postlsum_1,&postlsum_2,&postnuprod);
       test_adjust_k_new = sw_test_adjust(no_of_tests,test_time,
			 sensit,specif,test_result[k],s_tmp[k][it_s]);	
       test_adjust_new =  test_adjust_k_new/test_adjust_k_old[k];
       lik_new *= test_adjust_new;
       acc_prob =(lik_new/lik_old);
       if (ran1(&seed) <= acc_prob) {
	 /*printf("ACCEPT\n");*/
	 postbsum_new = postbsum;
	 postlsum_1_new = postlsum_1;
	 postlsum_2_new = postlsum_2;
	 postnuprod_new = postnuprod; 
         test_adjust_k_old[k] = test_adjust_k_new;
         test_adjust_old =  test_adjust_new;
	 s_accept_count++;
       }
       else{
	 /*printf("DO NOT ACCEPT\n");*/
	 s_tmp[k][it_s] = s_tmp[k][it_s-1];
       }
     }
   }
  }    
  for (j=1;j<=N_indiv;j++){
    s[j][it]=s_tmp[j][N_s_updates];
    s_tmp[j][0]=s_tmp[j][N_s_updates];
    ir_ind[j][it] = ir_ind_tmp[j][N_s_updates];	
    ir_ind_tmp[j][0] = ir_ind_tmp[j][N_s_updates];	
  }
  ninf[it] = ninf_tmp[N_s_updates];
  ninf_tmp[0] = ninf_tmp[N_s_updates];
  n_rem_inf[it] = n_rem_inf_tmp[N_s_updates];
  n_rem_inf_tmp[0] = n_rem_inf_tmp[N_s_updates];

  if (N_s_updates == 0){
    sw_SI_count(it,ir_ind,ninf,n_rem_inf,s,N_indiv,times,times_ir_ind,S,I,r);
    lik_old = sw_likel(it,N_indiv,ir_ind,beta[it-1],S,I,times_ir_ind,n_rem_inf,times,
              nu[it-1],lambda[it-1],s,r,T,&postbsum,&postlsum_1,&postlsum_2,&postnuprod);
    postbsum_new = postbsum;
    postlsum_1_new = postlsum_1;
    postlsum_2_new = postlsum_2;
    postnuprod_new = postnuprod;
  }
 

   /*********  UPDATE BETA PARAMETER  ***********/
   postb_shape = ninf[it] + a -1;
   postb_scale = b + postbsum_new;
   beta[it] = my_gamdev(postb_shape,&seed);
   beta[it] = beta[it]/postb_scale;


   /*********  UPDATE LAMBDA PARAMETER  ***********/
   postl_shape = nrem +c;
   postl_scale = postlsum_1_new +postlsum_2_new +d;
   lambda[it] = my_gamdev(postl_shape,&seed);
   lambda[it] = lambda[it]/postl_scale;
   

   /*********  UPDATE NU PARAMETER  ***********/
   if (model == 'e'){
     nu[it]=1.0;
   }
   else {
   mnbrak(&ax,&bx,&cx,&fa,&fb,&fc,neglog_post_nu);
   golden(ax,bx,cx,neglog_post_nu,tol,&xnu_mode);
   postvar_nu = secderiv_logpost_nu(xnu_mode,it,nrem,xi,N_indiv,
     s,r,T,lambda[it],fi,ir_ind);
   postvar_nu = -(1/postvar_nu);
   if (prop_choice == 'n'){
     nu[it] = xnu_mode + sqrt(postvar_nu)*gasdev(&seed);
     ratio_prop_nu =  exp(-((nu[it-1]-xnu_mode)*(nu[it-1]-xnu_mode)-
		   (nu[it]-xnu_mode)*(nu[it]-xnu_mode)) / (2*postvar_nu));
   
   }
   else if (prop_choice == 'g'){
     prop_shape = (xnu_mode*xnu_mode)/postvar_nu;
     prop_scale = xnu_mode/postvar_nu;
     nu[it] = my_gamdev(prop_shape,&seed)/prop_scale;
     ratio_prop_nu = pow((nu[it-1]/nu[it]),(prop_shape-1))*
       exp(-(prop_scale*(nu[it-1]-nu[it])));
   }
   else {
     prop_sig2 = log(1+(postvar_nu/(xnu_mode*xnu_mode)));
     prop_mu = log(xnu_mode)-(prop_sig2/2);
     nu[it] = prop_mu + sqrt(prop_sig2)*gasdev(&seed);
     nu[it] = exp(nu[it]);
      ratio_prop_nu = (nu[it]/nu[it-1]) * 
       exp(-((log(nu[it-1])-prop_mu)*(log(nu[it-1])-prop_mu)-
       (log(nu[it])-prop_mu)*(log(nu[it])-prop_mu)) / (2*prop_sig2));
   }
   acc_prob = post_nu(nu[it],it,nrem,xi,N_indiv,s,r,T,lambda[it],fi,ir_ind)/
     post_nu(nu[it-1],it,nrem,xi,N_indiv,s,r,T,lambda[it],fi,ir_ind) * ratio_prop_nu;
   if (ran1(&seed) <= acc_prob ) {
     /*printf("ACCEPT NU\n");*/
     ax = xnu_mode - 2*sqrt(postvar_nu);
     bx = xnu_mode + 2*sqrt(postvar_nu);
     nu_accept_count++;
   }
   else{
     /*printf("DO NOT ACCEPT NU\n");*/
     nu[it] = nu[it-1];
   }
   /*printf("\n nu[%d]=%E\n", it,nu[it]);*/
   }
 
 if (use_histograms == 'y'){
   if (it > (BURN_IN/3) && it <= BURN_IN){
     if (it == (BURN_IN/3)+1) {
       beta_min = beta[it]; beta_max = beta[it];
       lambda_min = lambda[it]; lambda_max = lambda[it];
       nu_min = nu[it]; nu_max = nu[it];
     }
     if (beta[it] < beta_min) beta_min = beta[it];
     if (beta[it] > beta_max) beta_max = beta[it];
     if (lambda[it] < lambda_min) lambda_min = lambda[it];
     if (lambda[it] > lambda_max) lambda_max = lambda[it];
     if (nu[it] < nu_min) nu_min = nu[it];
     if (nu[it] > nu_max) nu_max = nu[it];
   }
   if (it > BURN_IN){
     hist_heights(n_bins, beta[it], beta_min, beta_max, beta_heights);
     hist_heights(n_bins, lambda[it], lambda_min, lambda_max, lambda_heights);
     hist_heights(n_bins, nu[it], nu_min, nu_max, nu_heights);
   }
 }
 
 if (it % 1000 == 0) printf("it=%2d\n",it);
 }

 if (use_histograms == 'y'){
   if ( (out_heights=fopen("hist_heights.txt", "w"))==NULL ){
     printf("\n Cannot open output hist_heights.txt\n\n");
     exit(1);
   }
   for (i=1;i<=n_bins;i++)
     fprintf(out_heights,"%d  %d  %d\n",beta_heights[i],lambda_heights[i],nu_heights[i]);
   fclose(out_heights);
 }


 sample(NSIM,THINNING,BURN_IN,beta,nu,lambda);
 sample_2(NSIM,THINNING,BURN_IN,beta,nu,lambda);


 printf("\n");
 printf("sensit = %lf  specif = %lf\n",sensit,specif);
 printf("no_of_tests = %d\n",no_of_tests);  
 printf("Test times are:\n");
 for (i=1;i<=no_of_tests;i++) printf("%lf  ",test_time[i]);
 printf("\n");

 printf("\nAcceptance rate for s is: %4.2f (%.0lf accepted values)\n",
	 (s_accept_count/(NSIM*N_s_updates)),s_accept_count);
 printf("Acceptance rate for nu is: %4.2f \n",(nu_accept_count/NSIM));
 printf("\n");

 /******************************************************************/

 FREERETURN
 #undef FREERETURN
   free(s); free(ir_ind); free(beta); free(nu); free(lambda);
   free(ninf); free(n_rem_inf);

 fclose(in_data); fclose(in_start); fclose(in_test); fclose(in_prior_param);
} 
