	subroutine empty(link,mxlist,free)
	implicit integer(a-z)
	dimension link(mxlist)

	free = 1
	do il = 1,mxlist-1
	    link(il) = il+1
	end do
	link(mxlist) = 0

	return
	end

c************************************************************

	subroutine addv(a,ptr)

c.. add item a to list pointed to by ptr, maintaining numerical order
c   (typically used when a is a vertex)

	include "decl2.f"
	integer iv1,iv2,a,ptr,new

	iv1 = 0
	iv2 = ptr
	do while(iv2.ne.0)
	    if(list(iv2).gt.a) go to 1
	    iv1 = iv2
	    iv2 = link(iv2)
	end do
1	if(free.eq.0) stop 112
	new = free
	free = link(free)
	if(iv1.ne.0) then
	    link(iv1) = new
	else
	    ptr = new
	end if
	link(new) = iv2
	list(new) = a
	return

	end

c************************************************************

	subroutine dropv(a,ptr)

c.. drop item a from list pointed to by ptr, maintaining numerical order
c   (typically used when a is a vertex)

	include "decl2.f"
	integer a,ptr,iv1,iv2

	iv1 = 0
	iv2 = ptr
	do while(iv2.ne.0)
	    if(list(iv2).eq.a) go to 1
	    iv1 = iv2
	    iv2 = link(iv2)
	end do
	stop 205
1	if(iv1.ne.0) then
	    link(iv1) = link(iv2)
	else
	    ptr = link(iv2)
	end if
	link(iv2) = free
	free = iv2
	return

	end

c************************************************************

	subroutine add(a,first)

c.. add item a to beginning of list pointed to by first
c   (typically used when a is a clique or separator)

	include "decl2.f"
	integer a,first,iv,new

	iv = first
	if(free.eq.0) stop 113
	new = free
	free = link(free)
	first = new
	link(new) = iv
	list(new) = a
	return

	end

c************************************************************

	subroutine drop(neigh,sep,cliq)

c.. drop items neigh and sep from parallel lists pointed to by
c   firstn(cliq) and firsts(cliq)
c   (typically used when neigh is a clique and sep is a separator)

	include "decl2.f"
	integer neigh,sep,cliq,iv1,iv2,iw1,iw2

	iv1 = 0
	iv2 = firstn(cliq)
	iw1 = 0
	iw2 = firsts(cliq)
	do while(iv2.ne.0)
	    if(list(iv2).eq.neigh) go to 1
	    iv1 = iv2
	    iv2 = link(iv2)
	    iw1 = iw2
	    iw2 = link(iw2)
	end do
	stop 206
1	if(list(iw2).ne.sep) stop 207
	if(iv1.ne.0) then
	    link(iv1) = link(iv2)
	    link(iw1) = link(iw2)
	else
	    firstn(cliq) = link(iv2)
	    firsts(cliq) = link(iw2)
	end if
	link(iw2) = free
	link(iv2) = iw2
	free = iv2
	return

	end

c************************************************************

        subroutine addedge(cliqa,cliqb,sepnew)

	include "decl2.f"
	integer cliqa,cliqb,sepnew

	call add(cliqa,firstn(cliqb))
	call add(cliqb,firstn(cliqa))
	call add(sepnew,firsts(cliqb))
	call add(sepnew,firsts(cliqa))
	return
	end

c************************************************************

        subroutine dropedge(cliqa,cliqb,sepnew)

	include "decl2.f"
	integer cliqa,cliqb,sepnew

	call drop(cliqa,sepnew,cliqb)
	call drop(cliqb,sepnew,cliqa)
	return
	end

c************************************************************

	logical function findv(a,ptr)

c.. try to find item a in list pointed to by ptr, maintained
c   in numerical order (typically used when a is a vertex)

	include "decl2.f"
	integer a,ptr,lv

	findv = .false.

	lv = ptr
	do while(lv.ne.0)
	    if(list(lv).eq.a) then
		findv = .true.
		return
	    else if(list(lv).gt.a) then
		return
	    end if
	    lv = link(lv)
	end do

	return

	end

c************************************************************

	logical function same(ptr1,ptr2)

	include "decl2.f"
	integer ptr1,ptr2,lv,lw

	same = .false.

	lv = ptr1
	lw = ptr2
	do while(lv.ne.0.and.lw.ne.0)
	    if(list(lv).ne.list(lw)) return
	    lv = link(lv)
	    lw = link(lw)
	end do

	if(lw.ne.0.or.lv.ne.0) return
	same = .true.
	return

	end

c************************************************************

	subroutine getc(cliq)

	include "decl2.f"
	integer cliq

	if(freec.eq.0) stop 114
	cliq = freec
	freec = linkc(freec)
	linkc(cliq) = firstc
	firstc = cliq

	return
	end

c************************************************************

	subroutine putc(cliq)

	include "decl2.f"
	integer cliq,iv1,iv2

	iv1 = 0
	iv2 = firstc
	do while(iv2.ne.0)
	    if(iv2.eq.cliq) go to 1
	    iv1 = iv2
	    iv2 = linkc(iv2)
	end do
	stop 208
1	if(iv1.ne.0) then
	    linkc(iv1) = linkc(iv2)
	else
	    firstc = linkc(iv2)
	end if
	linkc(cliq) = freec
	freec = cliq

	call putvs(fvc(cliq))

	return

	end

c************************************************************

	subroutine putvs(ptr)

	include "decl2.f"
	integer ptr,lv1,lv2

	lv1 = 0
	lv2 = ptr
	do while(lv2.ne.0)
	    lv1 = lv2
	    lv2 = link(lv2)
	end do

	if(ptr.ne.0) then
		link(lv1) = free
		free = ptr
	end if

	return

	end

c************************************************************

	subroutine puts(sep)

	include "decl2.f"
	integer sep

	links(sep) = frees
	frees = sep

	call putvs(fvs(sep))

	return

	end

c************************************************************

	subroutine printcliqs

	include "decl2.f"
	integer sep,a,b,cliq,lv,is,i,ln,v

	do sep = 1,mxcliq
	    st2(sep) = 0
	end do

	write(70,'("----------")')

	do b = 2,nv
	write(70,'(20l1)') (adj(a,b),a=1,b-1)
	end do

	cliq = firstc
	do while(cliq.ne.0)
	    lv = fvc(cliq)
	    is = 0
	    do while(lv.ne.0)
		is = is+1
		st1(is) = list(lv)
		lv = link(lv)
	    end do
	    write(70,'("cliq.:",i4," (leng=",i3,"), ver:",
     &		10i4/(29x,10i4))')cliq,leng(cliq),(st1(i),i=1,is)

	    ln = firstn(cliq)
	    is = 0
	    do while(ln.ne.0)
		is = is+1
		st1(is) = list(ln)
		ln = link(ln)
	    end do
	    write(70,'("... linked to cliques:",10i4/(29x,10i4))')
     &		(st1(i),i=1,is)

	    ln = firsts(cliq)
	    is = 0
	    do while(ln.ne.0)
		is = is+1
		st1(is) = list(ln)
		sep = list(ln)
		st2(sep) = 1
		ln = link(ln)
	    end do
	    write(70,'("....... by separators:",10i4/(29x,10i4))')
     &		(st1(i),i=1,is)

	    cliq = linkc(cliq)
	end do

	do sep = 1,mxcliq
	if(st2(sep).eq.1) then
	    lv = fvs(sep)
	    is = 0
	    do while(lv.ne.0)
		is = is+1
		st1(is) = list(lv)
		lv = link(lv)
	    end do
	    write(70,'("sep.:",i4," with ver:",10i4/(29x,10i4))')
     &		sep,(st1(i),i=1,is)
	end if
	end do

	write(70,'("acliq:",15i4)') (acliq(v),v=1,nv)

cla	call countlist

	write(70,'("----------")')

	return
	end

c************************************************************

	subroutine countlist

	include "decl2.f"
	integer sep,cliq,lv,ln,lengs,nused,nfree,ntotal

	do sep = 1,mxcliq
	    st2(sep) = 0
	end do

	nfree = 0
	lv = free
	do while(lv.ne.0)
	    nfree = nfree+1
	    lv = link(lv)
	end do

	nused = 0
	cliq = firstc
	do while(cliq.ne.0)
	    nused = nused+leng(cliq)
	    ln = firsts(cliq)
	    do while(ln.ne.0)
		sep = list(ln)
		st2(sep) = 1
		ln = link(ln)
	    end do
	    cliq = linkc(cliq)
	end do

	do sep = 1,mxcliq
	if(st2(sep).eq.1) then
	    lv = fvs(sep)
	    lengs = 0
	    do while(lv.ne.0)
		lengs = lengs+1
		lv = link(lv)
	    end do
	    nused = nused+4+lengs
	end if
	end do

	ntotal = nfree+nused
	write(*,'("link/list: free:",i5,", used:",i5,", total:",i5)')
     &	    nfree,nused,ntotal

	return
	end
	
         
  
