function xxx=globmin

% These programs were used for the calculations in our paper. 
% They are now made available without any form of warranty 

randn('state',sum(100*clock)) % reset randon number generator
b=0.001;%b* neighbourhood strength - smaller = stronger%
all=1;% *b    overall variance (temporal)%

B=2;  % Height factor
obs=1^2;% observational variance
Cvar=10;% overall initial variance
weight=0.001; % level to slope ratio
sims=1000; % number of simulations
times=8;  % number of time points


Wstruc=zeros(25*64,25*64);  % empty update matrix
dd=zeros(25*64,25*64);   % empty distance matrix
for i=1:25*64    % calculate distances
    for j=1:25*64
        x1=floor((i-1)/25)*10+(rem(ceil(i/5)-1,5)+1);
        x2=floor((j-1)/25)*10+(rem(ceil(j/5)-1,5)+1);
        y1=B*(rem(i-1,5)+1);
        y2=B*(rem(j-1,5)+1);
        d=sqrt((min(abs(x1-x2),640-abs(x1-x2)))^2+(y1-y2)^2);
        dd(i,j)=d;
        Wstruc(i,j)=exp(-b*d);
    end
    if rem(i,100)==0; disp(i); end;
end    

[eVecWS,eValWS]=(eig(Wstruc)); % eigen structure of W
for i=1:size(eValWS)   % check for negative eigenvalues
    if 0~=abs(eValWS(i,i))-eValWS(i,i);
        eValWS(i,i)=0;
    end
end
ecorW1=real(eVecWS)*sqrt(eValWS*all);   % update level simulator
ecorW2=real(eVecWS)*sqrt(eValWS*all*weight); % update slope simulator
ecorC0=real(eVecWS)*sqrt(eValWS*Cvar);   % Prior simulation

save ecorW1.mat ecorW1
save ecorW2.mat ecorW2
save ecorC0.mat ecorC0
save obs.mat obs

mins=zeros(64*times,sims); % empty simulation results matrix
minsa=zeros(64*times,sims); % empty simulation results matrix with obs noise
for sim=1:sims  % simulate data
    truedata=zeros(size(ecorC0,2),times+1);
    trueslope=zeros(size(ecorC0,2),times+1);
    simdata=zeros(size(ecorC0,2),times+1);
    truedata(:,1)=ecorC0*randn(size(ecorC0,2),1);
    simdata(:,1)=truedata(:,1)+randn(size(ecorC0,2),1)*obs;
    
    for t=1:times
        trueslope(:,t+1)=trueslope(:,t)+ecorW2*randn(size(ecorW1,2),1);
        truedata(:,t+1)=truedata(:,t)+ecorW1*randn(size(ecorW1,2),1)+trueslope(:,t+1);
        simdata(:,t+1)=truedata(:,t+1)+randn(size(ecorW1,1),1)*obs;
    end
    
    for t=1:times % calculate regional minima
        for i=1:64
            mins(64*(t-1)+i,sim)=min(simdata(25*(i-1)+1:25*i,t));
            minsa(64*(t-1)+i,sim)=min(truedata(25*(i-1)+1:25*i,t));
        end
    end
    if rem(sim,100)==0; disp(sim); end;
end
cc=cov([mins',minsa']); 

end



scheme=[1,7,14]; % general scheme through time, base 16
tt=[1,4,7]; % inspection times
orig=[0:16:48];
for i=1:times
    glob(i,:)=[min(minsa(64*(i-1)+1:64*i,:))];  % true global minimum
end

aaaa=zeros(length(orig)*length(tt),size(minsa,2));
for i=1:length(tt)
    aaaa((i-1)*length(orig)+1:i*length(orig),:)=[mins((tt(i)-1)*64+scheme(i)+orig,:)]; % observed points
end
ccaa=[aaaa; glob];
covccaa=cov(ccaa'); % covariance between true global minimum and observed regional minimums 
bb=[1:length(orig)*length(tt)]; % observed data
aa=[length(orig)*length(tt)+1:length(orig)*length(tt)+8];% global minimums
varD=covccaa(bb,bb); % part of cov matrix relating to data 
covXD=covccaa(bb,aa)';% part of cov matrix relating data to global minima 
varX=covccaa(aa,aa);% part of cov matrix relating to global minima 
varDX=blvarDX(varX,covXD,varD);% Bayes linear variance update

% ordering observed minima
aaaa2=zeros(length(orig)*length(tt),size(minsa,2));
for i=1:length(tt)
    aaaa2((i-1)*length(orig)+1:i*length(orig),:)=[sort(mins((tt(i)-1)*64+scheme(i)+orig,:))];  % observed points
end
ccaa2=[aaaa2; glob];
covccaa2=cov(ccaa2');% covariance between true global minimum and observed regional minimums 
bb=[1:length(orig)*length(tt)];% observed data
aa=[length(orig)*length(tt)+1:length(orig)*length(tt)+8];% global minimums
varD=covccaa2(bb,bb); % part of cov matrix relating to data
covXD=covccaa2(bb,aa)';% part of cov matrix relating to global minima 
varX=covccaa2(aa,aa);% part of cov matrix relating to global minima 
varDX2=blvarDX(varX,covXD,varD);% Bayes linear variance update


%%%% consider multiple schemes
schemes=ones(13*7,3); %List candidate schemes 
k=1;
for i=1:14
    for j=i+1:14
        schemes(k,:)=[1,i,j];
        k=k+1;
    end
end
for i=1:times % true temporal minimums
    glob(i,:)=[min(minsa(64*(i-1)+1:64*i,:))];
end

for k=1:size(schemes,1); % run through all candidate schemes
    scheme=schemes(k,:)
    %%% do sequentially
    for t=1:8
        aaaa=[];
        aaaa2=[];
        for i=1:length(tt)
              if tt(i)<=t
          aaaa=[aaaa;mins((tt(i)-1)*64+scheme(i)+orig,:)]; % actual minima
          aaaa2=[aaaa2;sort(mins((tt(i)-1)*64+scheme(i)+orig,:))]; % sortd actual minima
           end
        end
        ccaa=[aaaa; glob];  
        covccaa=cov(ccaa');% covariance between true global minimum and observed regional minimums 
        ccaa2=[aaaa2; glob];
        covccaa2=cov(ccaa2');% covariance between true global minimum and ordered observed regional minimums 

        bb=[1:size(aaaa,1)];  % relating to regional minima
        aa=[size(aaaa,1)+1:size(aaaa,1)+8]; % relating to global minima
        varD=covccaa(bb,bb); % regional minima varaince
        covXD=covccaa(bb,aa)'; % covariance between regional and global
        varX=covccaa(aa,aa);  % global minima variance
        varDX=blvarDX(varX,covXD,varD);
        
        bb=[1:size(aaaa2,1)]; % relating to regional minima
        aa=[size(aaaa2,1)+1:size(aaaa2,1)+8]; % relating to global minima
        varD=covccaa2(bb,bb);% regional minima varaince
        covXD=covccaa2(bb,aa)';% covariance between regional and global
        varX=covccaa2(aa,aa); % global minima variance
        varDX2=blvarDX(varX,covXD,varD);
        
      
        aa2=[diag(varDX),diag(varDX2),diag(varX)];  % key variances
        res(t,:)=[aa2(t,1)./aa2(t,3),aa2(t,2)./aa2(t,3),(aa2(t,1)./aa2(t,3))./(aa2(t,2)./aa2(t,3))]; % calculate proportions
    end
     resul(k,:)=[scheme,res(8,:)]; %Summary of results
end

resul
