function minser(corr2)
% These programs were used for the calculations in our paper. 
% They are now made available without any form of warranty 

%load corr6e.mat corr2
meas=[16,8,4,2,1];  % number of regional observations
missing=[1,3,5,7];
for mea=1:5
    points=64;
    measures=meas(mea);
    ahead=3; % number of step ahead considered when finding best scheme
    light=1; %consider only every n^th
    time=8; % number of time points
    
    [points,measures,ahead,light]
    
    if measures==1; orig=[0]; end % setup measurement spacing
    if measures==2; orig=[0,32]; end
    if measures==4; orig=[0:16:48]; end
    if measures==8; orig=[0:8:56]; end
    if measures==16; orig=[0:4:60]; end
    ser=zeros((points/measures/light)^ahead,ahead+3,4);
    t=1; 
    for i=1:(points/measures/light)^ahead; % set up candidate schemes
        for j=1:ahead;
            ser(i,j+1,t)=(rem(ceil(i/((points/measures/light)^(j-1)))-1,(points/measures/light))+1)*light;
        end
    end
    ser(:,:,2)=ser(:,:,1);  % candidate schemes for time 2
    ser(:,:,3)=ser(:,:,1);% candidate schemes for time 3
    ser(:,:,4)=ser(:,:,1);% candidate schemes for time 4+
    for t=1:time
        for a=1:ahead %Restrict candidate schemes for times 1 to 3
            if a+1==3-t
                for i=1:(points/measures/light)^ahead;     
                    if (ser(i,3-t,t)<floor(points/measures/3) | ser(i,3-t,t)>ceil(points/measures/2)) 
                        ser(i,1,t)=-1;
                    end
                end
            end
            if a+1==4-t
                for i=1:(points/measures/light)^ahead;     
                    if ser(i,4-t,t)<floor(2*points/measures/3)
                        ser(i,1,t)=-1;
                    end
                end
            end
            if a+1==5-t
                for i=1:(points/measures/light)^ahead;     
                    if ser(i,5-t,t)>ceil(points/measures/2);
                        ser(i,1,t)=-1;
                    end
                end
            end
        end
    end
    
    
    base=orig+1;
    for tt=1:time-ahead % step through time
        for s=1:(points/measures/light)^ahead % and candidate schemes
            if ser(s,1,min(tt,4))>=0 % exclude those previously rejected
                kkf=base;  % inspection locations
                bb=zeros(1,ahead); % a store for summaries 
                bbb=bb;
                for t=1:ahead
                    kkf=[kkf,(t-1+tt)*points+ser(s,t+1,min(tt,4))+orig];  
                    xx=(t+tt)*points+1:(t+tt+1)*points;  % global minimums
                    varD=corr2(kkf,kkf);
                    covXD=corr2(kkf,xx)';
                    varX=corr2(xx,xx);
                    varDX=blvarDX(varX,covXD,varD);  % Bayes Linear update
                    bb(1,t)=max(diag(varDX));  %Summary of results
                    bbb(1,t)=mean(diag(varDX));  %Summary of results   
                end 
                ser(s,:,min(tt,4))=[ser(s,1:ahead+1,min(tt,4)),mean(bb),mean(bbb)];
            end
            if rem(s,1000)==0; disp(s); end
        end
        sss=sortrows(ser(:,:,min(tt,4)),1); % sort
        sss2=sss(-sum(sss(:,1))+1:end,:);
        [mina,minb]=min(sss2(:,ahead+2)); % value and location
        base=[base,orig+sss2(minb,2)+points*tt];  % new inspection regime
        a=rem(base-1,points/measures)+1;
        [a(1:measures:end),mina]
    end
    for i=2:ahead  % add points calculatedin kstep look ahead
        base=[base,orig+ sss2(minb,i+1)+points*(tt+i-1)];
    end
    oldmina=mina; % reset minimum value
    %  check if local minimum
    best=base;
    bits=3; %points around original - 3,5,7,...
    for its=1:15
        ser=zeros(bits^(time-1), measures*(time)+3);
        for i=1:size(ser,1);  % list local alternatives
            ser(i,2:measures+1)=best(1:measures);
            for j=2:time;
                ser(i,measures*(j-1)+2:measures*j+1)=rem(ceil(i/(bits^(j-2)))-1,bits)-floor(bits/2)+best((j-1)*measures+1:j*measures);
                if min(ser(i,measures*(j-1)+2:measures*j+1))<=points*(j-1) | max(ser(i,measures*(j-1)+2:measures*j+1))>points*j
                    ser(i,1)=-1;
                end
            end
        end
        
        for s=1:size(ser,1)
            if ser(s,1)>=0
                kkf=ser(s,2:1+measures);
                bb=zeros(1,time-1);
                bbb=bb;
                for t=1:time-1
                    kkf=[kkf,ser(s,t*measures+2:(t+1)*measures+1)];  
                    xx=(t+1)*points+1:(t+2)*points;  % global minimums
                    varD=corr2(kkf,kkf);
                    covXD=corr2(kkf,xx)';
                    varX=corr2(xx,xx);
                    varDX=blvarDX(varX,covXD,varD);  % BL update
                    bb(1,t)=max(diag(varDX)); % summary
                    bbb(1,t)=mean(diag(varDX));     
                end 
                ser(s,:)=[ser(s,1:(time)*measures+1),mean(bb),mean(bbb)];
            end
            %     if rem(s,400)==0; disp([s,size(ser,1)]); end
        end
        sss=sortrows(ser(:,:),1);
        sss2=sss(-sum(sss(:,1))+1:end,:);
        [mina,minb]=min(sss2(:,(time)*measures+2));
        %    sss2(minb,:)
        beststor=sss2(minb,2:(time)*measures+1);
        a=rem(beststor-1,points/measures)+1;
        disp(its)
        [a(1:measures:end),mina]
        
        if best==beststor%oldmina<=1.001*mina
            break
        end
        oldmina=mina;
        best=beststor;
    end
end
