

  function [llkd,grad,livec] = cqs16(par,np,iwr)

% minus log-likd fn for CQS model (q integrated out by trapezium rule) 

% special case: my1 normal y-vars, my2 binary y-vars  

% inputs: par=[psi(1...mx); alpha(1...my1+my2), beta(1...my1+my2), sig(1...my1)] 

% output: llkd=minus log-likd fn, grad=gradient vector, livec=likd contributions   

% dmx(1:n,1:m) is data matrix; x-columns in dmx are jx(1),...,jx(mx); 

% y1-columns are jy1(1),...,jy1(my1); y2-columns are jy2(1),...,jy2(my2); 

  global dmx n m mx jx my1 my2 jy1 jy2 ifn 

  my=my1+my2; jy=[jy1,jy2]; %preliminaries 

  %h=0.01; kmin0=50; tol=1e-8; %trapezium rule: increment size and tolerance 

  %mgauss=20; [rts,wts]=GHquad0(mgauss); %GH-quadrature: roots and weights 

  rt2=1.4142136; rtpi=1.7724538; rt2pi=2.50662827; 

  if iwr>1 

     fprintf('\n cqs16: n,m,mx,my1,my2,np %d %d %d %d %d %d',n,m,mx,my1,my2,np); 

     mxout1(jx,1,mx,1,'jx-vec',10,1); mxout1(jy,1,my,1,'jy-vec',10,1); 

     mxout1(par,1,np,1,'par-vec',10,3); end; 

  [psi,alf,bet,gam,sig]=cqs11a(par,mx,my1,my2,0,0); sig=exp(sig); %parameters 

  params(1)=mx; params(2)=my1; params(3)=my2; my=my1+my2; 

  params(4:3+mx+2*my+my1)=par(1:np); params(5+np+my)=0; 

% compute log-likd, gradient vector and likd contributions 

  llkd=0; grad(1:np)=0; livec(1:n)=0; 

  for ic=1:n xi=dmx(ic,jx); yi=dmx(ic,jy); 

      if iwr>2 fprintf('\n case ic= %d',ic); 

         mxout1(xi,1,mx,1,'xi-vec',10,3); mxout1(yi,1,my,1,'yi-vec',10,3); end; 

      xb=xi*psi'; y1=yi(1:max(1,my1)); y2=yi(my1+1:my1+max(1,my2)); 

      params(4+np)=xb; 

      params(5+np:4+np+my1)=y1(1:my1); params(5+np+my1:4+np+my)=y2(1:my2); 

      %params(6+np+my)=0; [int1]=GHquad1('cqs16a',mgauss,rts,wts,params,1); 

      [z0,zd,zlo,zhi,peakval]=GHzrange(my1,y1,xb,alf,bet,sig,rt2,rt2pi,eps,0);  

      %zm=max(abs([zlo,zhi])); kmin=2*max(kmin0,1+fix(zm/h)); 

      %params(6+np+my)=0; [int2,k]=GHintgl2('cqs16a',h,kmin,tol,params,1); 

      params(6+np+my)=1; zlo=z0-zd; zhi=z0+zd; 

      [int3,istg,n2,ifail]=qint1('cqs16a',zlo,zhi,params,1,1e-6,5,10,0); %pause; 

      %if abs(int2-int3)>1e-10 fprintf('\n case %d, int2,int3',ic,int2,int3); pause; end; 

      li=log(max(int3/rtpi,1e-50));  llkd=llkd-li; livec(ic)=li; 

  end; 

  if iwr>0 fprintf('\n cqs16: ifn=%d, llkd %10.8f',ifn,llkd); end; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



  function [psi,alf,bet,gam,sig]=cqs11a(par,mx,my1,my2,igam,iwr) 

% set up parameters: psi for p(q|x), (alf,bet,gam,sig) for p(y1|q),p(y2|q)   

  my=my1+my2; psi=par(1:mx); 

  alf=par(mx+1:mx+my); bet=par(mx+my+1:mx+2*my); sig(1:max(1,my1))=0; 

  if my1>0 sig=par(mx+2*my+1:mx+2*my+my1); end; 

  gam=bet(1:my1); if igam==1 gam=sig; sig=par(mx+3*my+1:mx+4*my); end; 

  if iwr>0 fprintf('\n cqs11a: mx,my1,my2 %d %d %d',mx,my1,my2); 

     mxout1(psi,1,mx,1,'psi-vec',10,3); 

     mxout1(alf,1,my,1,'alf-vec',10,3); 

     mxout1(bet,1,my,1,'bet-vec',10,3); 

     if my1>0 mxout1(sig,1,my1,1,'sig-vec',10,3); end; end; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



  function [z0,zd,zlo,zhi,peakval]=GHzrange(my1,y1,xb,alf,bet,sig,rt2,rt2pi,eps,iwr) 

% z-range for GHintegral/normal y-vars 

% integrand=exp(-z*z)*prod{phi(z;alfj+betj*xb,sigj)}, where phi is normal density 

% integrand=eps*peakval at (zlo,zhi)=(z0+-zd)  

  if iwr>0 fprintf('\n GHzrange: my1,xb,eps %d %g %g',my1,xb,eps); end; 

  s1=0; s2=0; s3=0; z0=0; zd=-1; zlo=0; zhi=0; d1=1; 

  for j=1:my1 uj=(y1(j)-alf(j)-bet(j)*xb)/sig(j); bj=bet(j)/sig(j); 

      s1=s1+bj*bj; s2=s2+bj*uj/rt2; s3=s3+uj*uj/2; d1=d1*sig(j)*rt2pi; end; 

  zd=(-log(eps)-(s3-s2*s2/(1+s1)))/(1+s1); zd=sqrt(max(0,zd)); 

  z0=s2/(1+s1); zlo=z0-zd; zhi=z0+zd; peakval=1/d1; 

  if iwr>0 

     fprintf('\n z0,zd,zlo,zhi,peakval %g %g %g %g %g',z0,zd,zlo,zhi,peakval); end; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



  function [area,istg,n2,ifail]=qint1(func,xlo,xhi,params,intvl,tol,minst,maxst,iwr)

% Numerical Recipes Chap 4: adaptive trapezium rule for

% numerical integration of func(x) over range (xlo,xhi)

% input intvl=1 (closed interval), or intvl=0 (open interval) 

%       and e.g. tol=1e-4; minst=5; maxst=10; 

% equal intervals assumed 

% function values returned by [fx]=func(x,params) 

  ifail=1; n1=1; a1=0; 

  if iwr>1 fprintf('\n qint1: intvl,xlo,xhi,tol,minst,maxst %d %g %g %g %d %d',...

                       intvl,xlo,xhi,tol,minst,maxst); end; 

  for istg=1:maxst  

      if intvl==1 [n2,a2]=trpzd1(func,xlo,xhi,params,istg,n1,a1,iwr-2); end; 

      if intvl==0 [n2,a2]=midpnt(func,xlo,xhi,params,istg,n1,a1,iwr-2); end; 

      if iwr>2 fprintf('\n istg,n1,n2,a1,a2 %d %d %d %g %g',...

                           istg,n1,n2,a1,a2); end; 

      if istg>minst & abs(a2-a1)<tol*(tol+abs(a1)) ifail=0; break; end; 

      n1=n2; a1=a2; end;  area=a2; 

  if iwr>0 

     fprintf('\n qint1: ifail,intvl,istg,n2,area %d %d %d %d %10.8f',...

                 ifail,intvl,istg,n2,area); end; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

