function [nlhat,Gr] = sml1(that)

% Declare global vars
global H idcol resp fdata rdata betastart omegastart 

% Formatting data structure and initial parameter estimates 
% Level 2 id 
b = size(idcol); if b(2)~=1; disp 'No. of columns in idcol.txt is NOT one!'; pause; end;
if b(1)==1; idcol=idcol'; end
% Calculate the number of level 2 units 
idftable = tabulate(idcol);
idftable(find(idftable(:,2)==0),:) = [];
% Initial param values 
b=size(betastart); if b(2)==1; betastart=betastart'; end;
b=size(omegastart); if b(2)==1; omegastart=omegastart'; end;
% Store size of data of the fixed and random parts  
Nf=size(fdata,2);  % no. of fixed effect covariates (incl. constant) 
Nr=size(rdata,2);

% Assign initial values 
J = length(unique(idcol)); % no. of level-2 units 
I = idftable(:,2); % no. of level-1 units per level-2 unit
cumi = cumsum(I);
ci = 0;
omegacur = zeros(Nr); 

% Generate the index matrix (one(s) at chosen positions; everywhere else zeros) for calculating the 1st derivatives of the random effects 
l=0;
idm = zeros(Nr); 
for ii = 1:Nr;
    for jj = ii:Nr;
        if ii==jj;
            l = l+1; 
            idm(ii,jj,l)=1; 
        elseif ii~=jj;
            l = l+1; 
            idm(ii,jj,l)=1;
            idm(jj,ii,l)=1;
        end;
    end; 
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% substitutions for speed  
dos = det(omegastart);
ios = inv(omegastart);
% extract random part of 'that' into varcov matrix, omegacur
l=0; 
for ii=1:Nr; 
    for jj=ii:Nr; 
        l=l+1; 
        omegacur(jj,ii)=that(Nf+l); 
        omegacur(ii,jj)=omegacur(jj,ii); 
    end; 
end; % 'omegacur' is current (updated) var-cov matrix of random part 
doc = det(omegacur);
ioc = inv(omegacur); 
t2 = log(dos./doc);
t3 = ios-ioc;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set seed
initseed;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate log-likelihood and 1st derivatives analytically
for j = 1:J
    y = resp((ci+1):cumi(j),1); % extract the response values for use 
    n = resp((ci+1):cumi(j),2);
    U = mvnrnd(zeros(Nr,1),omegastart,H)'; % simulated multinormal random variates 

    % Initialise storage vars 
    C0=0;
    C1f=zeros(1,Nf);
    C1r=zeros(1,Nr*(Nr+1)/2); % 2nd argument in brackets give the no. of unique elements in omega 
    pDni=zeros(1,I(j));
    
    for h = 1:H 
        A = 1 + exp([fdata((ci+1):cumi(j),:), rdata((ci+1):cumi(j),:)] * [that(1:Nf), U(:,h)']');
        D = exp( -n.*log(A) + y.*log(A-1) );   
        pD = prod(D);
        w = exp(0.5.*( t2 + U(:,h)'*t3*U(:,h) ));
        
        %%%%%%%%%%  
        % 1st derivates 
        %%%%%%%%%%  
        C0 = C0 + w.*pD; 

        % Fixed effects 
        tD=D;
        for i=1:I(j)
            b=tD(i); tD(i)=1; pDni(i)=prod(tD); tD(i)=b;
        end;
        t1 = (-n.*(A.^-1)+y.*((A-1).^-1)) .* pDni'; 
 
        for nf=1:Nf;
            C1f(nf) = C1f(nf) + w.*sum( D.* ( (A-1).* fdata((ci+1):cumi(j),nf) .* t1 ) );    
        end;
        
        % Random effects                
        l=0;
        for ii = 1:Nr;
            for jj = ii:Nr;
                l = l+1; 
                C1r(l) = C1r(l) + -0.5.*w.*pD.*sum( sum(diag(ioc*idm(:,:,l))) - U(:,h)'*ioc*idm(:,:,l)*ioc*U(:,h) );
            end;
        end;
    end; % End of h-th loop 
    
    ci = cumi(j); % save current cumulative sum of I for use in next loop 
    dlf(j,:)= C1f./C0; 
    dlr(j,:)= C1r./C0;
    llik(j) = -log(H) + log(C0);
end;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Estimates of the 1st derivatives and log likelihood  
Gr = [sum(dlf) sum(dlr)];
lhat = sum(llik);

% Show output 
disp('current estimates')
that
disp('current Gradients of estimates')
Gr = -Gr
disp('current (neg) log likelihood value')
nlhat = -lhat