%%% use_sml1_bang.m %%% 
% --------------------------------------------------------------------
%  This example demonstrates the use of Simulated Maximum Likelihood
%  method to fit a two-level model with binary response using 2nd-order PQL 
%  estimates as initial values. The model has random intercept and allows 
%  random effect for 'urban'. 
%  See the manuscript for a description of the BANG data. The bias corrected 
%  parameter estimates along with their standard errors and an estimate of 
%  the log-likelihood are shown in Table 3 of the manuscript. 
%
%  Note that the data have to be sorted on the level 2 identifier prior to 
%  using the Matlab codes in "sml1.m". 
% --------------------------------------------------------------------
clear
clc

% Declare global variables 
global H idcol resp fdata rdata betastart omegastart

% Load and arrange data
load bang.txt;
idcol=bang(:,1); resp=bang(:,3:4); fdata=bang(:,5:10); rdata=bang(:,5:6);

% Initial parameter values 
betastart=[-1.713 0.816 -0.026 1.135 1.360 1.357]; 
omegastart=[0.396 -0.414; -0.414  0.686];

% vectorize the variance-covariance matrix 
omegastartvec=omegastart(find(tril(omegastart)));

% putting together all of the initial parameter values into a vector 
that=[betastart omegastartvec']; 

% specify the no. of of draw from the importance density
H=3000; 

options=optimset('LargeScale','on','GradObj','on','Hessian','off','DerivativeCheck','off','Diagnostics','on','TolFun',1e-8,'TolX',1e-8,'MaxIter',25) ;

tic 
[x,fval,exitflag,output,grad,hessian] = fminunc(@sml1,that,options)
toc

disp('The bias-corrected parameter estimates are:');
x'
disp(' '); disp('SE of the bias-corrected parameter estimates');
sqrt(diag(inv(hessian)))
disp(' '); disp('Estimate of the log-likelihood:');
-fval
