#	Comparing nonparametric surfaces
#       The ozone data

source("sm-library.r")
source("surfplot.r")
source("surfdiffplot.r")
source("sigma2.r")

air <- read.table("air.dat")
names(air) <- c("ozone", "temperature", "wind", "group", "radiation")
attach(air)
x         <- cbind(wind, temperature)
y         <- ozone
group     <- (radiation >= 200)
h         <- h.select(x, y, group = group, method = "aicc")

par(mfrow=c(1,2))
sm.ancova(x[,1], y, group, h[1], xlab = "Wind",        ylab = "Ozone")
sm.ancova(x[,2], y, group, h[2], xlab = "Temperature", ylab = "Ozone")
par(mfrow = c(1,1))

sm.options(verbose = 1)
sm.options(list(xlab = "Wind"))
sm.options(list(ylab = "Temperature"))
sm.options(list(zlab = "Ozone"))
sm.options(list(zlim =  c(1.8, 5.2)))
sm.options(list(theta = 45, phi = 30))
sm.options(list(ngrid = 20))

par(mfrow=c(1,2))
sm.regression(x[!group,], y[!group], h, model = "linear")
sm.regression(x[ group,], y[ group], h, model = "linear")
par(mfrow = c(1,1))

par(mfrow=c(1,2))
sm.surfplot(x[!group,], y[!group], h, display = "se")
sm.surfplot(x[ group,], y[ group], h, display = "se")
par(mfrow = c(1,1))

sm.ancova(x, y, group, h, model = "equal")
sm.ancova(x, y, group, h, model = "parallel")

for (df in seq(6, 14, by = 2)) {
   h.sens     <- h.select(x, y, group = group, df = df)
   p.equal    <- sm.ancova(x, y, group, h.sens, model = "equal")$p
   p.parallel <- sm.ancova(x, y, group, h.sens, model = "parallel")$p
   }

par(mfrow=c(1,2))
sm.surfdiffplot(x, y, group, h = h)
par(mfrow = c(1,1))

par(mfrow=c(1,2))
sm.surfdiffplot(x, y, group, h = h, shift = TRUE)
par(mfrow = c(1,1))

