sm.sigma2 <- function(x, y, stand = "local", cross = F, ci = F,
			simple = F, model = "none", h = NA, strip = F,
			display = "none") {

  n  <- length(y)
  x1 <- x[,1]
  x2 <- x[,2]
  if (any(is.na(x1+x2+y))) stop("Missing data not allowed in sm.sigma2")
  
  if (strip) {
    ch <- chull(x1, x2, onbdy=T)
    x1 <- x1[-ch]
    x2 <- x2[-ch]
    y  <-  y[-ch]
    }
  X  <- cbind(x1,x2)

  if (simple) {
    S <- sm.weight2.nn(cbind(x1,x2), cross=cross)
    }
  else {
    d  <- matrix(rep(x1,n),ncol=n)
    D  <- (d-t(d))^2
    d  <- matrix(rep(x2,n),ncol=n)
    D  <- sqrt(D / var(x1) + ((d-t(d))^2) / var(x2))
    nn <- function(x) {sort(x)[5]}
    hw <- apply(D, 1, nn)/2
    h  <- c(sqrt(var(x1)), sqrt(var(x2)))
    S  <- sm.weight2(X, X, h, cross=cross, options=list(h.weights=hw)) 
    }

  A <- (diag(n)-S)

  if (model=="constant") {

    if (any(is.na(h))) stop("Smoothing parameter missing")
    
    P          <- sqrt(diag(1/diag(A %*% t(A)))) %*% A
    pseudo.res <- P %*% y
    svcomp     <- sqrt(abs(pseudo.res))

    S  <- sm.weight2(X, X, h, option = list())
    S  <- diag(n) - S
    S  <- t(S) %*% S
    L  <- matrix(1/n, ncol = n, nrow=n)
    r0 <- as.numeric(t(svcomp) %*% (diag(n) - L) %*% svcomp)
    r1 <- as.numeric(t(svcomp) %*% S %*% svcomp)
    ts <- (r0 - r1)/r1
    P  <- (P %*% t(P))^2
    diag(P) <- 0
    P  <- 5.545063 * ((1-P) * hyperg(P) - 1)
    diag(P) <- 1
    p  <- p.quad.moment(diag(n) - L - (1 + ts) * S, P, ts, 0)
    cat(paste("Test of constant variance:  significance = ", round(p, 3),
    		"\n"))

    if (!(display == "none")) {
      surface <- sm.regression(X, svcomp, h, display = "none")
      contour(surface$eval.points[,1], surface$eval.points[,2],
    			surface$estimate)
      }

     }  
  else {
    pseudo.res <- NA
    p          <- NA
    }

  if (stand=="local") {
     A   <- t(A) %*% diag(1/diag(A %*% t(A))) %*% A
     adf <- n
     }
  else {
     A   <- t(A) %*% A
     adf <- sum(diag(A))
     }
  sigmahat <- as.numeric(sqrt((t(y) %*% A %*% y) / adf))

#	Confidence interval

ie <- NA
if (ci) {
  B  <- A / adf
  k1 <- sum(diag(B))
  C  <- B %*% B
  k2 <- 2 * sum(diag(C))
  k3 <- 8 * sum(diag(C %*% B))
  aa <- abs(k3/(4 * k2))
  bb <- (8 * k2^3)/k3^2
  cc <- k1 - aa * bb
  q  <- qchisq(c(0.025,0.975), bb)
  ie <- rev(sigmahat/sqrt(cc + q*aa))
  }

  result <- list(estimate=sigmahat, ci = ie, qmat = A/adf, adf = adf,
		 pseudo.res = pseudo.res, p = p,
		 psmat = sqrt(diag(1/diag(A %*% t(A)))) %*% A)
  invisible(result)

  }

sm.sigma2.compare <- function(x1, y1, x2, y2) {

  n1   <- length(y1)
  sig  <- sm.sigma2(x1,y1)
  est1 <- sig$estimate
  A1   <- sig$qmat

  n2   <- length(y2)
  sig  <- sm.sigma2(x2,y2)
  est2 <- sig$estimate
  A2   <- sig$qmat

  Fobs <- est1^2 / est2^2
  Fobs <- max(Fobs, 1/Fobs)
  Al <- rbind(A1, matrix(0, nrow=n2, ncol=n1))
  Ar <- rbind(matrix(0, nrow=n1, ncol=n2), -Fobs * A2)
  A  <- cbind(Al, Ar)
  p  <- 2 * p.quad.moment(A, diag(n1 + n2), 0, 0)
  cat(paste("Test of equality of variances: p =", round(p, 3), "\n"))

  invisible(p)
  }

