#	Display the difference between two surfaces in se's

sm.surfdiffplot <- function(x, y, g, h, covar = NA,
		       display = "persp",  ngrid = 20, shift = FALSE,
		       print.file1 = NA, print.file2 = NA,
		       colour = TRUE, ...) {

  opt <- sm.options(list(...))
  x.name <- deparse(substitute(x))
  y.name <- deparse(substitute(y))
  dimn <- dimnames(x)[[2]]
  name.comp <- if (!is.null(dimn) & !all(dimn == ""))
      dimn
  else {
      if (!is.null(attributes(x)$names))
         attributes(x)$names
      else outer(x.name, c("[1]", "[2]"), paste, sep = "")
      }
  replace.na(opt, xlab, name.comp[1])
  replace.na(opt, ylab, name.comp[2])
  replace.na(opt, zlab, y.name)
  # replace.na(opt, ngrid, 20)
  replace.na(opt, zlim, range(y))
  
  g    <- as.factor(g)
  if (length(levels(g)) > 2) stop("Number of groups cannot be > 2.")

  ind1 <- (g == levels(g)[1])
  ind2 <- (g == levels(g)[2])
  x1   <- x[ind1,]
  x2   <- x[ind2,]
  y1   <- y[ind1]
  y2   <- y[ind2]
  n1   <- length(y1)
  n2   <- length(y2)

  surf  <- sm.regression(x, y, h = h, display = "none")
  z1    <- surf$eval.points[,1]
  z2    <- surf$eval.points[,2]
  evp   <- cbind(rep(z1, ngrid), rep(z2, rep(ngrid, ngrid)))
  surf1 <- sm.regression(x1, y1, h = h, eval.points = evp,
                         eval.grid = FALSE)
  surf2 <- sm.regression(x2, y2, h = h, eval.points = evp,
                         eval.grid = FALSE)
  mask0 <- surf$estimate / surf$estimate
  ind   <- 1:(ngrid-1)
  z1    <- (z1[ind] + z1[1+ind]) / 2
  z2    <- (z2[ind] + z2[1+ind]) / 2
  ng1   <- ngrid - 1
  evp   <- cbind(rep(z1, ng1), rep(z2, rep(ng1, ng1)))
  mask  <- surf$estimate / surf$estimate
  mask[is.na(mask)] <- 0
  mask  <- (mask[ind, ind]   + mask[1+ind, ind] +
            mask[ind, 1+ind] + mask[1+ind, 1+ind])
  mask[mask <= 2] <- NA
  mask[mask >  2] <- 1

  W1   <- sm.weight2(x1, evp, h, options = list())
  est1 <- as.vector(W1 %*% y1) * as.vector(mask)
  W2   <- sm.weight2(x2, evp, h, options = list())
  est2 <- as.vector(W2 %*% y2) * as.vector(mask)

  if (all(is.na(covar))) {
     sig1   <- sm.sigma2(x1, y1)$estimate
     sig2   <- sm.sigma2(x2, y2)$estimate
     sig    <- (sig1^2 * n1 + sig2^2 * n2) / (n1 + n2)
     covar <- diag(sig, nrow = n1 + n2, ncol = n1 + n2)
     }
  W <- matrix(0, nrow = nrow(evp), ncol = n1 + n2)
  W[, ind1] <-  W1
  W[, ind2] <- -W2
  if (shift) {
    D <- matrix(0, ncol = 1, n1 + n2)
    D[ind2,]  <- 1
    Q <- diag(n1 + n2) - sm.weight2(x, x, h, options=list())
    Q <- solve(t(D) %*% t(Q) %*% Q %*% D) %*% t(D) %*% t(Q) %*% Q
    alphahat <- as.vector(Q %*% y)
    W <- W +  matrix(as.vector(Q), nrow=nrow(W), ncol = n1+n2, byrow =TRUE)
    }
  else alphahat <- 0
  se <- sqrt(diag(W %*% covar %*% t(W)))


  sdiff <- matrix((est1 - est2 + alphahat) / se, ncol = ng1)
  
  # persp(z1, z2, sdiff * mask, ...)

  if ((display == "persp") | (display == "all")) {
     # se.col.1 <- rep("green", ng1^2)
     # se.col.2 <- rep("green", ng1^2)
     # se.col.1[(est1 - est2 + alphahat)/se >=  2] <- "red"
     # se.col.1[(est1 - est2 + alphahat)/se <= -2] <- "blue"
     # se.col.2[(est2 - est1 - alphahat)/se >=  2] <- "red"
     # se.col.2[(est2 - est1 - alphahat)/se <= -2] <- "blue"
     break.low  <- min(-3.5, min(sdiff, -sdiff, na.rm = TRUE) - 1)
     break.high <- max( 3.5, max(sdiff, -sdiff, na.rm = TRUE) + 1)
     if (colour) {
        se.col.1   <- matrix(cut(as.vector(sdiff),
                     breaks = c(break.low, seq(-3,-0.5,by=0.5),
     	     	        seq(0.5,3,by=0.5), break.high),
                     labels = rainbow(13, start = 0/6, end = 4/6)[13:1]),
     	     ncol = ng1)
        se.col.2   <- matrix(cut(as.vector(-sdiff), 13,
                     breaks = c(break.low, seq(-3,-0.5,by=0.5),
     	     	        seq(0.5,3,by=0.5), break.high),
                     labels = rainbow(13, start = 0/6, end = 4/6)[13:1]),
     	     ncol = ng1)
	}
     else {
        se.col.1 <- matrix(cut(as.vector(sdiff),
                           breaks = c(break.low, c(-3,-2,2,3), break.high),
                           labels = grey(1:5/6)),
		       ncol = ng1)
        se.col.2 <- matrix(cut(as.vector(-sdiff),
                           breaks = c(break.low, c(-3,-2,2,3), break.high),
                           labels = grey(1:5/6)),
		       ncol = ng1)
        }

     if (!is.na(print.file1))
           postscript(print.file1, horizontal = FALSE,
		width = 6, height = 6, onefile = FALSE, paper = "special")
     persp(surf$eval.points[,1], surf$eval.points[,2],
                matrix(surf1$estimate, ncol = ngrid) * mask0,
		xlab = opt$xlab, ylab = opt$ylab, zlab = opt$zlab,
		zlim = opt$zlim, ticktype = "detailed", d = 5,
		theta = opt$theta, phi = opt$phi,
	        col = se.col.1, ...)
     if (!is.na(print.file1)) dev.off()

     if (!is.na(print.file2))
           postscript(print.file2, horizontal = FALSE,
		width = 6, height = 6, onefile = FALSE, paper = "special")
     persp(surf$eval.points[,1], surf$eval.points[,2],
                matrix(surf2$estimate, ncol = ngrid) * mask0,
		xlab = opt$xlab, ylab = opt$ylab, zlab = opt$zlab,
		zlim = opt$zlim, ticktype = "detailed", d = 5,
		theta = opt$theta, phi = opt$phi,
	        col = se.col.2, ...)
     if (!is.na(print.file2)) dev.off()
     }
  if ((display == "contour") | (display == "all"))
  	contour(z1, z2, sdiff * mask)

  invisible(list(evp1 = z1, evp2 = z2, sdiff = sdiff,
  		 se.col.1 = se.col.1, se.col.2 = se.col.2))

  }
