sm.surfplot <- function(x, y, h, model = "none", ngrid = 20,
			display = "none", covar = NA, 
			print.file = NA, colour = TRUE, ...) {

   opt    <- sm.options(list(...))
   x.name <- deparse(substitute(x))
   y.name <- deparse(substitute(y))
   dimn   <- dimnames(x)[[2]]
   name.comp <- if (!is.null(dimn) & !all(dimn == ""))
      dimn
   else {
      if (!is.null(attributes(x)$names))
         attributes(x)$names
      else outer(x.name, c("[1]", "[2]"), paste, sep = "")
      }
   replace.na(opt, xlab, name.comp[1])
   replace.na(opt, ylab, name.comp[2])
   replace.na(opt, zlab, y.name)
   # replace.na(opt, ngrid, 20)
   replace.na(opt, zlim, range(y))

   n      <- length(y)
   surf   <- sm.regression(x, y, h, ngrid = ngrid, display = "none",
   			options = opt)
   x1g    <- surf$eval.points[,1]
   x2g    <- surf$eval.points[,2]
   ind    <- 1:(ngrid-1)
   x1g    <- (x1g[ind] + x1g[1+ind]) / 2
   x2g    <- (x2g[ind] + x2g[1+ind]) / 2
   ng1    <- ngrid - 1
   eval.points <- cbind(rep(x1g, ng1), rep(x2g, rep(ng1, ng1)))
   if (any(is.na(covar))) {
     sig    <- sm.sigma2(x, y)$estimate
     covar <- diag(rep(sig^2, n))
     }
   S      <- sm.weight2(x, eval.points, h = h)
   mask   <- surf$estimate / surf$estimate
   mask[is.na(mask)] <- 0
   mask   <- (mask[ind, ind]   + mask[1+ind, ind] +
              mask[ind, 1+ind] + mask[1+ind, 1+ind])
   mask[mask <= 2] <- NA
   mask[mask >  2] <- 1
   est    <- matrix(S %*% y, ncol = ng1) * mask
   se     <- NA
   if (colour) se.col <- matrix("green",   nrow = ng1, ng1)
          else se.col <- matrix(grey(0.5), nrow = ng1, ng1)

   if (!(model == "none")) {
   
     display <- "none"

     if (model == "no effect") {
         X <- matrix(rep(1, n), ncol = 1)
         Z <- matrix(rep(1, ng1^2), ncol = 1)
         }
      if (model == "linear") {
         X <- cbind(rep(1,n), x[,1] - mean(x[,1]), x[,2] - mean(x[,2]))
         Z <- cbind(rep(1, ng1 * ng1), eval.points[,1] - mean(x[,1]),
                      eval.points[,2] - mean(x[,2]))
         }

      X.theta <- solve(t(X) %*% X) %*% t(X)
      model.y <- matrix(as.vector(Z %*% X.theta %*% y), ncol = ng1)

      IH  <- diag(n) - X %*% X.theta
      se  <- matrix(sqrt(diag(S %*% IH %*% covar %*% IH %*% t(S))), 
                              ncol = ng1) * mask
      sdiff  <- (est - model.y) / se
      break.low  <- min(-3.5, min(sdiff, na.rm = TRUE) - 1)
      break.high <- max( 3.5, max(sdiff, na.rm = TRUE) + 1)
      if (colour)
         se.col <- matrix(cut(as.vector(sdiff),
                     breaks = c(break.low, seq(-3,-0.5,by=0.5),
		     	        seq(0.5,3,by=0.5), break.high),
                     labels = rainbow(13, start = 0/6, end = 4/6)[13:1]),
  		      ncol = ng1)
      else
         se.col <- matrix(cut(as.vector(sdiff),
                           breaks = c(break.low, c(-2,2), break.high),
                           labels = grey(1:3/4)),
		       ncol = ng1)
      }

   if (display == "se") {
      se     <- matrix(sqrt(diag(S %*% covar %*% t(S))), ncol = ng1) * mask
      if (colour)
         se.col <- matrix(cut(as.vector(se), 7,
                     labels = rainbow(13, start = 0/6, end = 4/6)[7:1]),
		     ncol = ng1)
      else
         se.col <- matrix(cut(as.vector(se), 7,
                     labels = grey((6:0)/6)),
		     ncol = ng1)
      }

   if (!is.na(print.file))
      postscript(print.file, horizontal = FALSE,
		width = 6, height = 6, onefile = FALSE, paper = "special")

   persp(surf$eval.points[,1], surf$eval.points[,2], surf$estimate,
   		col = as.vector(se.col), 
		xlab = opt$xlab, ylab = opt$ylab, zlab = opt$zlab,
		zlim = opt$zlim, ticktype = "detailed", d = 5,
		theta = opt$theta, phi = opt$phi,
		...)
		
   if (!is.na(print.file)) dev.off()

   invisible(list(estimate = est, se = se))
   }
