library(mvtnorm)
library(MASS)
library(MCMCpack)
dyn.load(".../area.dll")
library(fOptions)
######################################
# Program to calculate the probabilities of each sequence of emergence;

r2mvnorm<-function (n, mean = rep(0, nrow(sigma)), sigma = diag(length(mean))) 
{
    if (nrow(sigma) != ncol(sigma)) {
        stop("sigma must be a square matrix")
    }
    if (length(mean) != nrow(sigma)) {
        stop("mean and sigma have non-conforming size")
    }
    ev <- eigen(sigma, sym = TRUE)$values
    if (!all(ev >= -sqrt(.Machine$double.eps) * abs(ev[1]))) 
        warning("sigma is numerically not positive definite")
    sigsvd <- svd(sigma)
    retval <- t(sigsvd$v %*% (t(sigsvd$u) * sqrt(sigsvd$d)))
    retval <- rnorm.halton(n,ncol(sigma))%*% retval
    retval <- sweep(retval, 2, mean, "+")
    retval
}


#Input: 
#Posterior Variance-Covariance Matrix M corresponding to a specific Gender-DMF combination
#mu: posterior mean of emergence of the corresponding Gender-DMF combination;
# simnr: number of monte carlo simulations;
Probs<-function(M,mu,simnr)
covg=matrix(0,7,7);
mu=rep(0,7);
 for(i in 1:7){
  for(j in 1:7) {
  covg[i,j]=COVG[[i]][j] }
               }
               
for(i in 1:7){
  mug[i]=MG[i,1]
             }
 
k<-7
r<-seq(1,7)
mu<-mug
sigma<-covg
muw<-rep(0,k)
sigmaw<-matrix(0,k,k)
nperm<-factorial(k)
a<-matrix(0,nperm,k)
probg<-rep(0,factorial(k))
for(i in 1:nperm){
    foo <- .Fortran("permut",
        l=as.integer(i),
        n=as.integer(k),
        r=as.integer(r))
        
    a[i,]<-foo$r

       
 for(j in 1:k){
       muw[j]<-mu[a[i,j]]
        for(k in 1:k){
           sigmaw[j,k]<-sigma[a[i,j],a[i,k]]
                      }
               }
        
   nmonte<-simnr
    z<-r2mvnorm(nmonte,muw,sigmaw)
    count<-0
    for(j in 1:nmonte){
        if(z[j,1]<z[j,2] && z[j,2]<z[j,3] && z[j,3]<z[j,4] && z[j,4]<z[j,5] && z[j,5]<z[j,6] && z[j,6]<z[j,7])
       count<-count+1
    }
    probg[i]<-count/nmonte
    
}
