/**************************************************************/
/* Author: Cecere Silvia                                      */
/* mailto: silvia.cecere@med.kuleuven.be                      */
/* Date: DEC05                                                */
/* tandmob.exe should be created                              */
/* Required: Scythe Library;                                  */
/* downloadable from http://scythe.wustl.edu                  */
/* Functions below should be added to Scythe_LA.cc            */
/**************************************************************/
 
 //Function to delete kth row and rth column from a given matrix with more than 1 column;
 template <class T>
      Matrix<T>
      delrcol(const Matrix<T> &A, const int &k, const int &r)
      {
      
      int newrowsize = (A.rows() - 1)*(A.cols() - 1);
      //int newcolsize = A.cols() - 1;
       Matrix<T> temp = Matrix<T>(newrowsize,1,false);
       int  k0 = 0;
        for(int i = 0 ; i < A.rows(); ++i){
          if(i!=k-1)
          for(int j = 0 ; j < A.cols(); ++j){
            if (j != r-1) {
            
              temp(k0,0)=A(i,j);
              k0 = k0 + 1;             
              }
           
         }
          }
      temp=reshape(temp,(A.rows() - 1),(A.cols() - 1));                          
      return  temp;
   }//end delrcol
  
  
  
  /* ONLY VALID FOR COLUMN MATRICES*/
    template <class T>
           Matrix<T>
           delr(const Matrix<T> &A, const int &k)
           {  
           
           int newrowsize = (A.rows() - 1);
           
            Matrix<T> temp = Matrix<T>(newrowsize,1,false);
            int  k0 = 0;
             for(int i = 0 ; i < A.rows(); ++i){
               if(i!=k-1)
                for(int j = 0 ; j < A.cols(); ++j){
                                
                   temp(k0,0)=A(i,j);
                   k0 = k0 + 1;             
                   }
                   
              
              }
             return  temp;              
               }//end
/*************************************************************/

//Pgm starts here;

#include <iostream>
#include <ctime>
#include ".../Scythe/src/include/Scythe_Error.h"
#include ".../Scythe/src/include/Scythe_Matrix.h"
#include ".../Scythe/src/include/Scythe_Stat.h"
#include ".../Scythe/src/include/Scythe_Math.h"
#include ".../Scythe/src/include/Scythe_IDE.h"
#include ".../Scythe/src/include/Scythe_LA.h"
#include ".../Scythe/src/include/Scythe_Optimize.h"
#include ".../Scythe/src/include/Scythe_Simulate.h"

using namespace SCYTHE;
using namespace std;


void outMat(const Matrix<double> & A, const char* fname)
{
  ofstream out_File(fname,ios::app);
  

 const int nrows = A.rows();
 const int ncols = A.cols();
 
  for(int i = 0; i<nrows;++i)
     for(int j = 0; j<ncols;++j)
     out_File << setw(7)<< A(i,j)<<" "  ;
     out_File <<endl;
      
  
}



void outVect(const double* alpha, const int l,  const char* fname)
{
  ofstream out_File(fname,ios::app);
  

 const int nrows = l;
 /*const int ncols = A.cols();*/
 
  for(int i = 0; i<nrows;++i)
     out_File << setw(7)<< alpha[i]<<" "  ;
     out_File <<endl;
      
  
}

/*Function to compute  T matrices*/

Matrix<double> HH(Matrix<double> & H,  double* theta,  const double &x, const double &y)
{
	  int cnt = -1;
	      
	      for(int i = 0; i < 7; ++i){
		      for(int j = 0; j < 7; ++j){
			      if( j < i ) {
				      H(i,j) = theta[++cnt] + theta[++cnt]*x + theta[++cnt]*y; 
				      H(i,j) = - H(i,j);
				      }
			      
			  
			  }
	      
      }
	return(H);
}




/*Function to compute D matrices*/

Matrix<double> DD(Matrix<double> & D,  double* alpha,  const double &x, const double &y)
{
	  int cnt = -1;
	      
	      for(int i = 0; i < 7; ++i){
		      
			D(i,i) = std:: exp(alpha[++cnt] + alpha[++cnt]*x + alpha[++cnt]*y); 
			
			      
			  
			  }
	      
   
	return(D);
}



/*Function to calculate log(det(D))*/

double dd(double* alpha,  const double &x, const double &y)
{
	  int cnt = -1;
	  double dd=0.0;
	      
	      for(int i = 0; i < 7; ++i){
		      
			dd += alpha[++cnt] + alpha[++cnt]*x + alpha[++cnt]*y; 
			
			      
			  
			  }
	      
   
	return(dd);
}



/*Compute the full conditional for ALPHA*/
double logfull(double* alpha, double* theta, const Matrix<double> *Epsiarr,Matrix<double> &gender,Matrix<double> &dmft) 
  			    {
	    
int Mk = 7; 
int Mp = 21;


int Mn = 4351; 
double ldet = 0.0;   
                 
        
        Matrix<double> VAR_Prior_Alpha  = eye<double>(Mp);      
                       VAR_Prior_Alpha  = 1000*VAR_Prior_Alpha;  
        Matrix<double> MEAN_Prior_Alpha = Matrix<double>(Mp, 1, 0.0);     
        Matrix<double> AL(Mp,1,alpha);
       
       double term = lndmvn(AL,MEAN_Prior_Alpha,VAR_Prior_Alpha);

      


// the logfull 
     double loglike = 0.0;
     
     Matrix<double> T  = eye<double>(7);
     Matrix<double> D  = eye<double>(7);
   
for (int i=0; i< Mn; ++i){

       
        Matrix<double>  Tarr = HH(T,theta,gender[i],dmft[i]) ;
       	Matrix<double>  Darr = DD(D,alpha,gender[i],dmft[i]);
        Matrix<double>     A = t(Tarr) * invpd(Darr) * Tarr;
           
               
               loglike += 0.5*(t(Epsiarr[i]) * A * Epsiarr[i])(0,0) ;
                  ldet += dd(alpha,gender[i],dmft[i]);
                                           
                              }
        
       
        
           
loglike = loglike + 0.5 * ldet;
       
       loglike= - loglike + term;
                 
       return (loglike);
       
                         }//end logfull;

int
main (int, char *[])
   {
  time_t start,end;
  time(&start);
   int Mn = 4351; // number of individuals
   int Mp = 21; // total number of covariates
   int Mk = 7; // number of observations per subject
   //int Mt = Mk*Mn; //total number of observations
  
  int Mgibbs = 70000;  // MCMC length 
/* Reading data                                       */
   Matrix<double> MY(".../datc.txt");
   Matrix<double> MX(".../design.txt");
   
/*Rows Z-matrices */

   Matrix<double> MZarr_1(".../Zrow1.txt");
   
   Matrix<double> MZarr_21(".../Zrow21.txt");
   Matrix<double> MZarr_22(".../Zrow22.txt");

   Matrix<double> MZarr_31(".../Zrow31.txt");
   Matrix<double> MZarr_32(".../Zrow32.txt");
   Matrix<double> MZarr_33(".../Zrow33.txt");

   Matrix<double> MZarr_41(".../Zrow41.txt");
   Matrix<double> MZarr_42(".../Zrow42.txt");  
   Matrix<double> MZarr_43(".../Zrow43.txt");
   Matrix<double> MZarr_44(".../Zrow44.txt");

   Matrix<double> MZarr_51(".../Zrow51.txt");
   Matrix<double> MZarr_52(".../Zrow52.txt");
   Matrix<double> MZarr_53(".../Zrow53.txt");
   Matrix<double> MZarr_54(".../Zrow54.txt");
   Matrix<double> MZarr_55(".../Zrow55.txt");
   
   Matrix<double> MZarr_61(".../Zrow61.txt");
   Matrix<double> MZarr_62(".../Zrow62.txt");
   Matrix<double> MZarr_63(".../Zrow63.txt");
   Matrix<double> MZarr_64(".../Zrow64.txt");
   Matrix<double> MZarr_65(".../Zrow65.txt");
   Matrix<double> MZarr_66(".../Zrow66.txt");

   Matrix<double> Alpha(".../alphas.txt");
   Matrix<double> Theta(".../theta.txt");
                  
   Matrix<double> Sigma_Alpha(".../varalpha.txt");
   
   
    Matrix<double> low1(".../l1.txt");
    Matrix<double> low2(".../l2.txt");
    Matrix<double> low3(".../l3.txt");
    Matrix<double> low4(".../l4.txt");
    Matrix<double> low5(".../l5.txt");
    Matrix<double> low6(".../l6.txt");
    Matrix<double> low7(".../l7.txt");
   
    Matrix<double> upper1(".../r1.txt");
    Matrix<double> upper2(".../r2.txt");
    Matrix<double> upper3(".../r3.txt");
    Matrix<double> upper4(".../r4.txt");
    Matrix<double> upper5(".../r5.txt");
    Matrix<double> upper6(".../r6.txt");
    Matrix<double> upper7(".../r7.txt");
    
    
    
    Matrix<double> gender(".../gender.txt");
    Matrix<double> dmft(".../dmf.txt");

   
  //Prior Specification
     
     Matrix<double> Mean_Prior_Beta = Matrix<double>(Mp, 1, 0.0);
     Matrix<double> Prec_Prior_Beta  = eye<double>(Mp);  
                    Prec_Prior_Beta  = 0.000001*Prec_Prior_Beta;  
     
     
     
     Matrix<double> Mean_Prior_Theta = Matrix<double>(63, 1, 0.0);
     Matrix<double> Prec_Prior_Theta = eye<double>(63);      
                    Prec_Prior_Theta  = 0.000001*Prec_Prior_Theta;  
                    
                    
    
     double count_acc = 0;
   
      
     double* alpha = new double[21];
     double* theta = new double[63];
     
          
       
       
//Holding Data;

Matrix<double>* Yarr = new Matrix<double>[Mn];
     for(int i = 0; i < Mn; ++i) {
     
      Yarr[i] = Matrix<double>(Mk,1);
       int start=i*Mk;
        for(int j = 0; j < Mk; ++j) {
         Yarr[i](j,0) = MY( start + j,0);
                                    }
                                  }       

   
/*Design Matrix*/  

 Matrix<double>* Xarr = new Matrix<double>[Mn];
     for(int i = 0; i < Mn; ++i) {
        Xarr[i] = Matrix<double>(Mk, Mp, 0.0);
        int start = i * Mk;
         for(int l=0; l<  Mk; ++l) {
           for(int m=0; m < Mp; ++m) {
              Xarr[i](l,m) = MX(start + l, m);
                                     }
                                       }
                                     }

           

/*Individual Variance-Covariance Matrices*/
Matrix<double>* Sigarr = new Matrix<double>[Mn];
         for(int i = 0; i < Mn; ++i)
            Sigarr[i] =  eye<double>(7);  
       
         
// Holding Predicted Values;

Matrix<double>* hatYarr = new Matrix<double>[Mn];
         for(int i = 0; i < Mn; ++i)
            hatYarr[i] = Matrix<double>(Mk, 1, 0.0); 
            
            
            
// Holding Residuals;                                    
 
Matrix<double>* Epsiarr = new Matrix<double>[Mn];
     for(int i = 0; i < Mn; ++i)
            Epsiarr[i] = Matrix<double>(Mk, 1, 0.0);  
       
                        
  /*Design matrices for the dependence parameters: entries of T's*/       
  
 Matrix<double>* Zarr = new Matrix<double>[Mn];
        for(int i = 0; i < Mn; ++i)
            Zarr[i] = Matrix<double>(Mk, 63, 0.0);  
   

 
 
   Matrix<double> FrowZ(1,63,0.0);        
        
 	         
/*Variance-Covariance Matrix*/
            
Matrix<double>  beta_sim(Mp,1,false);
Matrix<double>  theta_sim(Mp,1,false);


/*Matrices to store the last imputed data ; */
Matrix<double> MYlast(Mk*Mn,1,0.0);  
Matrix<double> A(Mn,Mk,0.0);
                      


// GIBBS SAMPLER ;                                       
                                        
for (int iter = 0; iter < Mgibbs ; ++iter) {

//Step 1: Sampling Beta;

Matrix<double> beta_var_sum(Mp,Mp);
Matrix<double> beta_mean_sum(Mp,1);



 //Variance-Covariance and Mean of the posterior;
 for(int i = 0; i < Mn; ++i){
             Matrix<double> T = eye<double>(7);
             Matrix<double> D = eye<double>(7);
             Matrix<double> Tarr = HH(T, theta, gender[i], dmft[i]) ;
	     Matrix<double> Darr = DD(D, alpha, gender[i], dmft[i]);
   
              Matrix<double> InvSigarr     = t(Tarr) * invpd(Darr) * Tarr;
                             beta_var_sum  = beta_var_sum   + t(Xarr[i]) * InvSigarr * Xarr[i];
                             beta_mean_sum = beta_mean_sum  + t(Xarr[i]) * InvSigarr * Yarr[i];
        
                                 }
          
           beta_var_sum = beta_var_sum + Prec_Prior_Beta;                                    

      Matrix<double> beta_sim_var  = invpd(beta_var_sum );      
      Matrix<double> beta_sim_mean = beta_sim_var * beta_mean_sum;
    
Matrix<double> beta_sim = rmvnorm(beta_sim_mean, beta_sim_var);



outMat(beta_sim,".../bet1.txt");


/*END STEP 1= BETA */

// Residuals and  Predicted Values;

 for (int i = 0; i < Mn; ++i){
     	hatYarr[i] = Xarr[i] * beta_sim;
     	Epsiarr[i] = Yarr[i] - hatYarr[i];}
     	
     	
//Step 2: Sampling Theta;  
 
   for (int i = 0; i < Mn; ++i){
           
  Matrix<double> F_1_arr = (Epsiarr[i](0,0))*MZarr_1(i,_); 
  
  Matrix<double> Zarr1=rbind(FrowZ,F_1_arr);
  
  Matrix<double> F_2_arr = (Epsiarr[i](0,0))*MZarr_21(i,_) + (Epsiarr[i](1,0))* MZarr_22(i,_);
  
  Matrix<double> Zarr2=rbind(Zarr1,F_2_arr);
  
  Matrix<double> F_3_arr = (Epsiarr[i](0,0))* MZarr_31(i,_) + (Epsiarr[i](1,0))*MZarr_32(i,_) + (Epsiarr[i](2,0))*MZarr_33(i,_);
  
  Matrix<double> Zarr3=rbind(Zarr2,F_3_arr);
  
  
Matrix<double>   F_4_arr = (Epsiarr[i](0,0))*MZarr_41(i,_)+ (Epsiarr[i](1,0))* MZarr_42(i,_) + (Epsiarr[i](2,0))*MZarr_43(i,_) + (Epsiarr[i](3,0))*MZarr_44(i,_);
  Matrix<double> Zarr4=rbind(Zarr3,F_4_arr);
  
Matrix<double> F_5_arr = (Epsiarr[i](0,0))*MZarr_51(i,_) + (Epsiarr[i](1,0))*MZarr_52(i,_) + (Epsiarr[i](2,0))*MZarr_53(i,_) + (Epsiarr[i](3,0))*MZarr_54(i,_) + (Epsiarr[i](4,0))*MZarr_55(i,_);
    
  Matrix<double> Zarr5=rbind(Zarr4,F_5_arr);
    
 
Matrix<double> F_6_arr = (Epsiarr[i](0,0))*MZarr_61(i,_) + (Epsiarr[i](1,0))*MZarr_62(i,_) + (Epsiarr[i](2,0))*MZarr_63(i,_)+ (Epsiarr[i](3,0))*MZarr_64(i,_) + (Epsiarr[i](4,0))*MZarr_65(i,_) + (Epsiarr[i](5,0))*MZarr_66(i,_);
    
     Zarr[i]=rbind(Zarr5,F_6_arr);
  
                       }             
         

Matrix<double> theta_var_sum(63,63);
Matrix<double> theta_mean_sum(63,1);

 

 for(int i = 0; i < Mn; ++i){
          Matrix<double> D= eye<double>(7);
          Matrix<double> Darr = DD(D, alpha, gender[i], dmft[i]);
          Matrix<double> InvD = invpd(Darr);
          theta_var_sum  =  theta_var_sum   + t(Zarr[i]) * InvD * Zarr[i]; 
          theta_mean_sum =  theta_mean_sum  + t(Zarr[i]) * InvD * Epsiarr[i];
          
                                 }
          

 theta_var_sum  = theta_var_sum  + Prec_Prior_Theta;   

      
Matrix<double> theta_sim_var  = invpd(theta_var_sum);
      
Matrix<double> theta_sim_mean = theta_sim_var * theta_mean_sum;
   
Matrix<double> theta_sim = rmvnorm(theta_sim_mean, theta_sim_var);

      
   for(int i = 0;i < 63; ++i){
         theta[i] = theta_sim(i,0);
                               }
                               
  outVect(theta,63,".../thet.txt");
  
  
  
         
// STEP 3: Calculating full-conditional at the current value of alpha's;

double logfull_alpha_1=0.0;

logfull_alpha_1 =logfull(alpha,theta,Epsiarr ,gender, dmft); 



//Random Walk;
Matrix<double> Mat_Alpha(Mp,1,alpha); //current value;

Matrix<double> Can_Alpha=rmvnorm(Mat_Alpha, Sigma_Alpha);   //candidate;

double alpha_aux[21]={0.0};


for(int i = 0;i < Mp;++i)
   alpha_aux[i] = Can_Alpha(i,0);
   
double logfull_can = 0.0;
logfull_can  = logfull(alpha_aux,theta,Epsiarr,gender, dmft);


 
double ratio =  logfull_can -logfull_alpha_1 ;

double aprob =  std :: min(0.0,ratio);

   //MH-step
      double accept[1]={0.0};

   
   
  if (std ::log(runif()) < aprob ){

       
     for(int j=0; j < Mp; ++j)
         alpha[j] = alpha_aux[j];

   	accept[0]= 1;
   	++count_acc;
   	//logfull_alpha_1 = logfull_can;
   	      
   	      }

             
outVect(alpha,21,".../alph.txt"); 
outVect(accept,1,".../rate.txt"); 
                       	
   
//END D;


for(int i = 0; i < Mn; ++i){
 Matrix<double> D = eye<double>(7);
 Matrix<double> T = eye<double>(7);

 Matrix<double> Darr=DD(D,alpha,gender[i],dmft[i]);
 Matrix<double> Tarr=HH(T,theta,gender[i],dmft[i]);
 Sigarr[i] = inv(Tarr) * Darr * t(inv(Tarr));
                           }
 

//Data Augmentation; 

double mu  = 0.0;
double tau = 0.0; 

/*Y_1*/

 for(int i = 0; i < Mn; ++i){
 
Matrix<double> Muarr = Sigarr[i](0,1,0,6) * invpd(delrcol(Sigarr[i],1,1)) * (delr(Yarr[i],1)- delr(hatYarr[i],1));                   
Matrix<double> Mvarr = Sigarr[i](0,1,0,6) * invpd(delrcol(Sigarr[i],1,1)) * t(Sigarr[i](0,1,0,6)); 
  	
  mu           =  Muarr(0,0) + hatYarr[i](0,0);  
  tau          =  Sigarr[i](0,0)- Mvarr(0,0);
  Yarr[i](0,0) =  rtnorm(mu,tau,low1[i],upper1[i]);
   
                           }
          
/*Y_2*/
mu  = 0;
tau = 0;
Matrix<double> RSig2(6,1,false);

 for(int i = 0; i < Mn; ++i){
Matrix<double> RSig2 = delr(t(Sigarr[i](1,0,1,6)),2);

Matrix<double> Muarr = t(RSig2) * invpd(delrcol(Sigarr[i],2,2)) * (delr(Yarr[i],2)- delr(hatYarr[i],2));                   
Matrix<double> Mvarr = t(RSig2) * invpd(delrcol(Sigarr[i],2,2)) * RSig2; 
  	
  mu   =  Muarr(0,0) + hatYarr[i](1,0);  
  tau  =  Sigarr[i](1,1)- Mvarr(0,0);
  Yarr[i](1,0)=  rtnorm(mu,tau,low2[i],upper2[i]); 
  
 
          }
          
/* Y_3 */
mu = 0;
tau = 0;
for(int i = 0; i < Mn; ++i){
 Matrix<double> RSig2 = delr(t(Sigarr[i](2,0,2,6)),3);

Matrix<double> Muarr = t(RSig2) * invpd(delrcol(Sigarr[i],3,3)) * (delr(Yarr[i],3)- delr(hatYarr[i],3));                   
Matrix<double> Mvarr = t(RSig2) * invpd(delrcol(Sigarr[i],3,3)) * RSig2; 
  	
  mu   =  Muarr(0,0) + hatYarr[i](2,0);  
  tau  =  Sigarr[i](2,2)- Mvarr(0,0);
 Yarr[i](2,0)=  rtnorm(mu,tau,low3[i],upper3[i]); 
  
 
          }

/*Y_4*/
mu = 0;
tau = 0;

for(int i = 0; i < Mn; ++i){
 Matrix<double> RSig2 = delr(t(Sigarr[i](3,0,3,6)),4);

Matrix<double> Muarr = t(RSig2) * invpd(delrcol(Sigarr[i],4,4)) * (delr(Yarr[i],4)- delr(hatYarr[i],4));                   
Matrix<double> Mvarr = t(RSig2) * invpd(delrcol(Sigarr[i],4,4)) * RSig2; 
  	
  mu         =  Muarr(0,0) + hatYarr[i](3,0);  
  tau        =  Sigarr[i](3,3)- Mvarr(0,0);
 Yarr[i](3,0)=  rtnorm(mu,tau,low4[i],upper4[i]); 
  
 
          }
          
/*Y_5*/
mu = 0;
tau = 0;
for(int i = 0; i < Mn; ++i){
Matrix<double> RSig2 = delr(t(Sigarr[i](4,0,4,6)),5);
Matrix<double> Muarr = t(RSig2) * invpd(delrcol(Sigarr[i],5,5)) * (delr(Yarr[i],5)- delr(hatYarr[i],5));                   
Matrix<double> Mvarr = t(RSig2) * invpd(delrcol(Sigarr[i],5,5)) * RSig2; 
  	
  mu         =  Muarr(0,0) + hatYarr[i](4,0);  
  tau        =  Sigarr[i](4,4)- Mvarr(0,0);
 Yarr[i](4,0)=  rtnorm(mu,tau,low5[i],upper5[i]); 
 
 
          }

/*Y_6*/
mu = 0;
tau = 0;
for(int i = 0; i < Mn; ++i){
Matrix<double> RSig2 = delr(t(Sigarr[i](5,0,5,6)),6);
Matrix<double> Muarr = t(RSig2) * invpd(delrcol(Sigarr[i],6,6)) * (delr(Yarr[i],6)- delr(hatYarr[i],6));                   
Matrix<double> Mvarr = t(RSig2) * invpd(delrcol(Sigarr[i],6,6)) * RSig2; 
  	
  mu         =  Muarr(0,0) + hatYarr[i](5,0);  
  tau        =  Sigarr[i](5,5)- Mvarr(0,0);
 Yarr[i](5,0)=  rtnorm(mu,tau,low6[i],upper6[i]); 
  
 
          }

/*Y_7*/
mu = 0;
tau = 0;

for(int i = 0; i < Mn; ++i){

Matrix<double> RSig2 = delr(t(Sigarr[i](6,0,6,6)),7);
Matrix<double> Muarr = t(RSig2) * invpd(delrcol(Sigarr[i],7,7)) * (delr(Yarr[i],7)- delr(hatYarr[i],7));                   
Matrix<double> Mvarr = t(RSig2) * invpd(delrcol(Sigarr[i],7,7)) * RSig2; 
  	
  mu         =  Muarr(0,0) + hatYarr[i](6,0);  
  tau        =  Sigarr[i](6,6)- Mvarr(0,0);
 Yarr[i](6,0)=  rtnorm(mu,tau,low7[i],upper7[i]); 
  
 
          }



if(iter==Mgibbs-1){
  for(int i = 0; i < Mn; ++i) {
          for(int j = 0; j < Mk; ++j) {
          MYlast[j+Mk*i]=Yarr[i][j];
                                      }
                               } 
      A=reshape(MYlast,Mn,Mk);
      
       A.save(".../datlast.txt",'o', false);
                    
                } //end storing last data set;

             }  //END GIBBS;
      
        delete [] Xarr; 
        delete [] Yarr; 
        delete [] Epsiarr;   
        delete [] hatYarr;
        delete [] Sigarr;
        delete [] Zarr;
        delete [] alpha ;        
        delete [] theta ;
  return 0;
  
}    //END MAIN;
