# =============================================================#
# Multinomial-Poisson models subject to inequality constraints #
#              Manuela Cazzaro & Roberto Colombi               #
#                                                              #
# Example 1: TRAFFIC ACCIDENT DATA [Lang, JASA 2005]           #
#                          TABLE 1                             #
# =============================================================#


library(hmmm)

# the numbering is
# var1: injury status (5 lev.); var2: restraint used (2 lev.); var3: year (5 lev.)

y<-
c(158080, 13289, 8296, 3460, 157,
   16491,  2719, 3395, 2112, 370,
  169617, 13872, 9173, 3453, 152,
   14944,  2492, 3208, 1864, 362, 
  169660, 14569, 9462, 3423, 161,
   13894,  2520, 3264, 1839, 362,
  159748, 13545, 8853, 3176, 186,
   12483,  2412, 2944, 1721, 345, 
  168902, 14443, 9337, 3322, 172,
   11918,  2299, 2824, 1730, 345)

y<-c(y)

marglist<-marg.list(c("m-m-l","m-l-l","g-l-l"),mflag="m")

# ************************************************


inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,2,3)),types=c("g","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:17,34:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 simple] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)


# ************************************************


inelist<-list(marg=c(1,2,3),int=list(c(1,3),c(1,2,3)),types=c("g","l","l"))

XX<-diag(1,49)

coma<-list(0,0,matrix(c(
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
0,1,0,0,0,
0,0,1,0,0,
0,0,0,1,0,
0,0,0,0,1)
,8,5))

D1<-kronecker(matrix(1,2,1),diag(1,16))

DD1<-rbind(diag(0,16),diag(1,16))

D1<-cbind(D1,DD1)

ID<-D1

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID,cocacontr=coma)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(18:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_2 simple] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)


# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,3),c(1,2,3)),types=c("g","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)

de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 & H_2 simple] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,2,3)),types=c("c","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:17,34:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 uniform] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,3),c(1,2,3)),types=c("c","l","l"))

XX<-diag(1,49)

coma<-list(0,0,matrix(c(
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
0,1,0,0,0,
0,0,1,0,0,
0,0,0,1,0,
0,0,0,0,1)
,8,5))

D1<-kronecker(matrix(1,2,1),diag(1,16))

DD1<-rbind(diag(0,16),diag(1,16))

D1<-cbind(D1,DD1)

ID<-D1

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID,cocacontr=coma)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(18:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_2 uniform] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,3),c(1,2,3)),types=c("c","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 & H_2 uniform] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,2,3)),types=c("rc","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:17,34:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y


# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 reverse uniform] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,3),c(1,2,3)),types=c("rc","l","l"))

XX<-diag(1,49)

coma<-list(0,0,matrix(c(
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
0,1,0,0,0,
0,0,1,0,0,
0,0,0,1,0,
0,0,0,0,1)
,8,5))

D1<-kronecker(matrix(1,2,1),diag(1,16))

DD1<-rbind(diag(0,16),diag(1,16))

D1<-cbind(D1,DD1)

ID<-D1

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID,cocacontr=coma)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(18:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_2 reverse uniform] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,3),c(1,2,3)),types=c("rc","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 & H_2 reverse uniform] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,2,3)),types=c("l","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:17,34:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 likelihood ratio] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,3),c(1,2,3)),types=c("l","l","l"))

XX<-diag(1,49)

coma<-list(0,0,matrix(c(
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
1,0,0,0,0,
0,1,0,0,0,
0,0,1,0,0,
0,0,0,1,0,
0,0,0,0,1)
,8,5))

D1<-kronecker(matrix(1,2,1),diag(1,16))

DD1<-rbind(diag(0,16),diag(1,16))

D1<-cbind(D1,DD1)

ID<-D1

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID,cocacontr=coma)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(18:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX,D=ID)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_2 likelihood ratio] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************

inelist<-list(marg=c(1,2,3),int=list(c(1,2),c(1,3),c(1,2,3)),types=c("l","l","l"))

XX<-diag(1,49)

model<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)
de<-hmmm.model.summary(model)

modnoineq<-hmmm.mlfit(y,model,noineq=TRUE)
de<-hmmm.model.summary(model,modnoineq)

modineq<-hmmm.mlfit(y,model,noineq=FALSE)
de<-hmmm.model.summary(model,modineq)

sel<-c(14:49)

XX<-XX[,-sel]

modeli<-hmmm.model(marg=marglist,lev=c(5,2,5),dismarg=list(inelist),X=XX)

modin<-hmmm.mlfit(y,modeli)
de<-hmmm.model.summary(modeli,modin)

modin$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(modin model) vs H1=(modineq model)

#     testB --> H0=(modineq model) vs H1=(modnoineq model)
#               that is: [H_1 & H_2 likelihood ratio] vs [no ineq. model]

p<-hmmm.chibar(model, nullfit=modin, disfit=modineq, satfit=modnoineq, repli = 6000)

chibar.summary(p)

# ************************************************