# =============================================================#
# Multinomial-Poisson models subject to inequality constraints #
#              Manuela Cazzaro & Roberto Colombi               #
#                                                              #
# Example 2: MADSEN DATA [Madsen, Scand. Journal of Stat. 1976]#
#                          TABLE 3                             #
# =============================================================#


library(hmmm)


#var1 = Influence on apartament management (low, medium, high) --> B
#var2 = Satisfaction (low, medium, high) --> A
#var3 = Contact with other residents (low, high) --> X1
#var4 = Housing type (blocks, apartments, atrium houses, terraced houses) --> X2


#the lower the variable number is the faster the variable sub-script changes in the vectorized table


y<-
c(21, 34, 10, 21, 22, 11, 28, 36, 36,
  61, 43, 26, 23, 35, 18, 17, 40, 54,
  13,  8,  6,  9,  8,  7, 10, 12,  9,
  18, 15,  7,  6, 13,  5,  7, 13, 11,
  14 ,17,  3, 19, 23,  5, 37, 40, 23,
  78, 48, 15, 46, 45, 25, 43, 86, 62,
  20, 10,  7, 23, 22, 10, 20, 24, 21,
  57, 31,  5, 23, 21,  6, 13, 13, 13) 

y<-array(y,c(3,3,4,2))

y<-aperm(y,c(1,2,4,3))

y<-c(y)

# ===========================================

marginals<-c("m-m-l-l","g-m-l-l","m-g-l-l","l-l-l-l")
marginals<-marg.list(marginals,mflag="m")


model<-hmmm.model(marg=marginals,lev=c(3,3,2,4))

marg234ineq<-list(marg=c(2,3,4),int=list(c(2,4)),types=c("marg","g","l","l"))

marg134ineq<-list(marg=c(1,3,4),int=list(c(1,3)),types=c("g","marg","l","l"))

ineq=list(marg234ineq,marg134ineq)

sel<-c(18:23,34:39)

selnull<-c(10:11,18:23,28:33,34:39)

XX<-diag(1,71)

XX0<-XX[,-selnull]

XX<-XX[,-sel]

model<-hmmm.model(marg=marginals,lev=c(3,3,2,4),dismarg=ineq,X=XX,D=diag(-1,8))

model0<-hmmm.model(marg=marginals,lev=c(3,3,2,4),dismarg=ineq,X=XX0)

d<-hmmm.model.summary(model)

modineq<-hmmm.mlfit(y,model,y.eps=0.5,noineq=FALSE,maxit=3000)

descrfit<-hmmm.model.summary(model,modineq,aname="mod.fit")

mod<-hmmm.mlfit(y,model,maxit=3000)

descrfit<-hmmm.model.summary(model,mod,aname="mod.fit.noineq")

mod0<-hmmm.mlfit(y,model0,maxit=3000)

descrfit<-hmmm.model.summary(model0,mod0,aname="mod.fit.null")

# ===========================================


# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(mod0 model) vs H1=(modineq model)
#               that is: [(H_3 & H_4)equal.] vs [H_3 & H_4]
  
#     testB --> H0=(modineq model) vs H1=(mod model)
#               that is: [H_3 & H_4] vs [H_3]

p<-hmmm.chibar(model, nullfit=mod0, disfit=modineq, satfit=mod, repli = 6000)

chibar.summary(p)


# ===========================================

marginals<-c("g-m","m-g","g-g")

marginals<-marg.list(marginals,mflag="m")

model<-hmmm.model(marg=marginals,lev=c(3,3),strata=8)

al<-list(
"~-1+f_0*Ho+f_0*Co",
"~-1+f_0*Ho+f_0*Co",
"~-1+f_0*Co*Ho"
)

modelsat<-create.XMAT(model,Formula=al,strata=c(2,4),fnames=c("Co","Ho"))

# -------------------
#  hypotheses tested
# -------------------

# [H_3] vs [saturated model]
  
mods<-hmmm.mlfit(y,modelsat,maxit=2000,mup=1,step=1,m.initial=y)

mph.summary(mods)



