# =============================================================#
# Multinomial-Poisson models subject to inequality constraints #
#              Manuela Cazzaro & Roberto Colombi               #
#                                                              #
# Example 3: NHS DATA                                          # 
#                          TABLE 5                             #
# =============================================================#


library(hmmm)


#Var4 - EDUCATION; Var3 - AGE; Var2 - COMFORT; Var1 - TIME 

y<-
c(6,10, 4,37,48,31,19,21,12,
  5, 2, 1,20,23,12,15,17, 8,
  2, 3, 3,11,25, 7,17,11, 8,
  6, 2, 3,11,20,12,20,10, 7,
  2, 3, 2,17,24, 8,20,17, 6,
  2, 3, 1,18,22,14,28,24, 9,
  1, 4, 2,13,13, 3,14,16, 5,
  1, 1, 1, 9,17, 5,23,10, 8,
 11, 9, 4,49,66,38,83,78,27)

m<-array(y,dim=c(3,3,3,3))

mm<-aperm(m,perm=c(3,4,2,1))

yy<-c(mm)

marginal1<-list(marg=c(1),int=list(1),types=c("l","marg"))

marginal2<-list(marg=c(2),int=list(2),types=c("marg","l"))

# bivariate marginals

marginal12<-list(marg=c(1,2),int=list(c(1,2)),types=c("l","l"))

marginal12dis<-list(marg=c(1,2),int=list(c(1,2)),types=c("c","l"))
marginal12bis<-list(marg=c(1,2),int=list(c(1,2)),types=c("l","c"))
marginali<-list(marginal1,marginal2,marginal12)


# INEQUALITIES: list of the marginals involved

dism<-list(marginal12dis, marginal12bis)

XX<-kronecker(diag(1,9),block.fct(diag(1,4),diag(1,4)))

XX0<-kronecker(diag(1,9),rbind(diag(1,4),matrix(0,4,4)))


# remove redundant constraints (continuation-local + local-continuation case (Cazzaro Colombi, SMA 2006))

D<-diag(1,8)
D<-kronecker(diag(1,9),D[-c(3,4,6),])



models<-hmmm.model(marg=marginali,dismarg=dism,lev=c(3,3),strata=9,X=XX,D=D)


# estimation

# SATURATED model

asat<-hmmm.mlfit(yy,models)

ou<-hmmm.model.summary(models,asat)


# model with just INEQUALITIES on continuation-local & local-continuation o.r.
# NB: no equality constraints on univariate marginal logits

a <- hmmm.mlfit(yy,models,noineq=FALSE,norm.diff.conv = 1e-09,norm.score.conv=1e-09,maxit=6000)

oud<-hmmm.model.summary(models,a)

# model with just INEQUALITIES transformed in EQUALITIES on continuation-local & local-continuation o.r.
# NB: no equality constraints on univariate marginal logits (stochastic independence model)

models0<-hmmm.model(marg=marginali,lev=c(3,3),strata=9,X=XX0)

anull <- hmmm.mlfit(yy,models0)

ouu<-hmmm.model.summary(models0,anull)

salvam<-anull$m

anull$m<-y

# -------------------
#  hypotheses tested
# -------------------

# NB: testA --> H0=(anull model) vs H1=(a model)
#     testB --> H0=(a model) vs H1=(asat model)

# chibar with raw counts y

P<-hmmm.chibar(model=models,nullfit=anull,disfit=a,satfit=asat,repli=6000)

chibar.summary(P)

anull$m<-salvam


