###################################################################
# R codes for manuscript: Urn sampling, interval censoring and  
# proportional hazard models: tests and relationships
# Owner: Summer Lu Zheng
# date: 7/13/2003
###################################################################

#  Descriptions:

#  Subfunction used in calculation of midranks 
#  x: intervals of specific observation; 
#  L.b: lower bounds of all observation; 
#  U.b: upper bounds of all observation; 
#  md: midrank (returned value); 
#  op: numbers of observations inside the interval, including overlapping intervals.

# Function midrank.f calculates the midrank of the $i^{th}$ observation.
# Input parameters include $x.i$, a vector of $(L_i, R_i)$ of the $i^{th}$ 
# observation, $L.b$ and $U.b$ the interval limits of all the observations. 
# The function also returns $n_i - 1$, where $n_i$ is the number of 
# observations whose intervals overlap with the interval associated with 
# the $i^{th}$ ordered observation.  

midrank<-function(x,L.b, U.b){
 md<-(sum(x[1]>U.b)+sum(x[2]>=L.b)+1)/2
 op<-sum((x[1]<L.b)*(L.b<x[2]))
 return(c(md,op))
}

# Function score.f calculates the score statistics $S$ in equation 2.1.
# The input parameter $x$ is a matrix with 3 columns: censoring 
# indicator, covariate and midranks. 

score.f<-function(x){
x.m<-apply(as.matrix(x[,3]),1,sum.f,x)
t<-apply(as.matrix(unique(x[,3])),1,len,x[,3])
m.ind<-match(unique(x[,3]),x[,3])
x<-cbind(x[,c(1,3)][m.ind,],x.m[m.ind],t)
m.i<-apply(x,1,mean.f,x[,2:4])
return(sum((x[,1]>0)*(x[,3]-m.i)))
}

sum.f<-function(y,x){
return(sum(x[,2][x[,3]==y]))
}

len<-function(y,x){
return(length(x[x==y]))
}

mean.f<-function(y.,x.){
return(y.[4]*sum(x.[,2][x.[,1]>=y.[2]])/sum(x.[,3][x.[,1]>=y.[2]]))
}


# functions for corrected ep

tie.f<-function(xn,x){
return(length(x[x==xn]))
}

rank.t<-function(y){
r<-y[1]
n<-y[2]
return((r*n-n*(n-1)/2)/n)
}

rep.f<-function(y){
r<-y[1]
n<-y[2]
return(rep(r,n))
}

ep.f<-function(x){
x<-sort(x)
x.n<-apply(as.matrix(unique(rank(x))),1,tie.f,rank(x))
x.r<-apply(cbind(unique(rank(x)),x.n),1,rank.t)
y.rank<-as.vector(unlist(apply(cbind(x.r,x.n),1,rep.f)))
return(y.rank)
}


################################################################

# Main function
# lb and ub are interval limits for interval-censored observations. 
# For complete and right-censored observations, lb and ub take the 
# same value of survival times.  
# Censoring indicator cen takes the value 0, 1 and 2 for right-censored, 
# complete and interval-censored observations, respectively. 
# x is the covariate. Currently the program only take a single covariate.
 
urn.midrank.f<-function(lb, ub, cen, x){

N<-length(x)
mrank.rc<-apply(as.matrix(cbind(lb,ub)),1,midrank, lb, ub)
ytt<-data.frame(cbind(cen, x, t(mrank.rc)))
names(ytt)<-c("cen", "x", "mrank.rc", "op.rc")
dat.rc<-cbind(ytt$cen, ytt$x, ytt$mrank.rc)[order(ytt$mrank.rc),1:3]
score.rc<-score.f(dat.rc)
ep.an.rc<-1/(N-ep.f(ytt$mrank.rc)+1)

cen.rc<-ifelse(ytt$cen==2, 1-(ytt$op.rc)/N, ytt$cen)
cen.rc<-ifelse(ytt$cen==2, 1, ytt$cen)
theta.rc<-sum(cen.rc)/N
xN<-sum(ytt$x)*(N-sum(ytt$x))/(N*(N-1))
var.rc<-xN*(N*theta.rc-sum(ep.an.rc*cen.rc[order(ytt$mrank.rc)]))            
urn.rc<-score.rc/sqrt(var.rc)
urn.rc
return(1-pnorm(urn.rc))
}


urn.midrank.f(lb, ub, cen,x)
